/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class HSnapshotDescription
implements Writable {
    private HBaseProtos.SnapshotDescription proto;

    public HSnapshotDescription() {
    }

    public HSnapshotDescription(HBaseProtos.SnapshotDescription proto) {
        assert (proto != null) : "proto must be non-null";
        this.proto = proto;
    }

    public String getName() {
        return this.proto.getName();
    }

    public HBaseProtos.SnapshotDescription getProto() {
        return this.proto;
    }

    public HBaseProtos.SnapshotDescription.Type getType() {
        return this.proto.getType();
    }

    public String getTable() {
        return this.proto.getTable();
    }

    public boolean hasTable() {
        return this.proto.hasTable();
    }

    public long getCreationTime() {
        return this.proto.getCreationTime();
    }

    public int getVersion() {
        return this.proto.getVersion();
    }

    public String toString() {
        if (this.proto != null) {
            return this.proto.toString();
        }
        return "(no snapshot)";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HSnapshotDescription)) {
            return false;
        }
        HBaseProtos.SnapshotDescription oproto = ((HSnapshotDescription)obj).getProto();
        if (this.proto == oproto) {
            return true;
        }
        if (this.proto == null && oproto != null) {
            return false;
        }
        return this.proto.equals(oproto);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] data = Bytes.readByteArray(in);
        this.proto = data.length > 0 ? HBaseProtos.SnapshotDescription.parseFrom(data) : null;
    }

    public void write(DataOutput out) throws IOException {
        if (this.proto != null) {
            Bytes.writeByteArray(out, this.proto.toByteArray());
        } else {
            Bytes.writeByteArray(out, new byte[0]);
        }
    }
}

