/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;

public class AccessControlLists {
    public static final String ACL_TABLE_NAME_STR = "_acl_";
    public static final byte[] ACL_TABLE_NAME = Bytes.toBytes("_acl_");
    public static final byte[] ACL_GLOBAL_NAME = ACL_TABLE_NAME;
    public static final String ACL_LIST_FAMILY_STR = "l";
    public static final byte[] ACL_LIST_FAMILY = Bytes.toBytes("l");
    public static final HTableDescriptor ACL_TABLEDESC = new HTableDescriptor(ACL_TABLE_NAME);
    public static final char ACL_KEY_DELIMITER = ',';
    public static final String GROUP_PREFIX = "@";
    public static final String SUPERUSER_CONF_KEY = "hbase.superuser";
    private static Log LOG;

    static void init(MasterServices master) throws IOException {
        if (!MetaReader.tableExists(master.getCatalogTracker(), ACL_TABLE_NAME_STR)) {
            master.createTable(ACL_TABLEDESC, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUserPermission(Configuration conf, UserPermission userPerm) throws IOException {
        Permission.Action[] actions = userPerm.getActions();
        Put p = new Put(userPerm.isGlobal() ? ACL_GLOBAL_NAME : userPerm.getTable());
        byte[] key = AccessControlLists.userPermissionKey(userPerm);
        if (actions == null || actions.length == 0) {
            String msg = "No actions associated with user '" + Bytes.toString(userPerm.getUser()) + "'";
            LOG.warn((Object)msg);
            throw new IOException(msg);
        }
        byte[] value = new byte[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            value[i] = actions[i].code();
        }
        p.add(ACL_LIST_FAMILY, key, value);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Writing permission for table " + Bytes.toString(userPerm.getTable()) + " " + Bytes.toString(key) + ": " + Bytes.toStringBinary(value)));
        }
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            acls.put(p);
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeUserPermission(Configuration conf, UserPermission userPerm) throws IOException {
        Delete d = new Delete(userPerm.isGlobal() ? ACL_GLOBAL_NAME : userPerm.getTable());
        byte[] key = AccessControlLists.userPermissionKey(userPerm);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing permission " + userPerm.toString()));
        }
        d.deleteColumns(ACL_LIST_FAMILY, key);
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            acls.delete(d);
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTablePermissions(Configuration conf, byte[] tableName) throws IOException {
        Delete d = new Delete(tableName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing permissions of removed table " + Bytes.toString(tableName)));
        }
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            acls.delete(d);
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTablePermissions(Configuration conf, byte[] tableName, byte[] column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing permissions of removed column " + Bytes.toString(column) + " from table " + Bytes.toString(tableName)));
        }
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            Scan scan = new Scan();
            scan.addFamily(ACL_LIST_FAMILY);
            String columnName = Bytes.toString(column);
            scan.setFilter(new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(String.format("(%s%s%s)|(%s%s)$", Character.valueOf(','), columnName, Character.valueOf(','), Character.valueOf(','), columnName))));
            TreeSet<byte[]> qualifierSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            ResultScanner scanner = acls.getScanner(scan);
            try {
                for (Result res : scanner) {
                    for (byte[] q : res.getFamilyMap(ACL_LIST_FAMILY).navigableKeySet()) {
                        qualifierSet.add(q);
                    }
                }
            }
            finally {
                scanner.close();
            }
            if (qualifierSet.size() > 0) {
                Delete d = new Delete(tableName);
                for (byte[] qualifier : qualifierSet) {
                    d.deleteColumns(ACL_LIST_FAMILY, qualifier);
                }
                acls.delete(d);
            }
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    static byte[] userPermissionKey(UserPermission userPerm) {
        byte[] qualifier = userPerm.getQualifier();
        byte[] family = userPerm.getFamily();
        byte[] key = userPerm.getUser();
        if (family != null && family.length > 0) {
            key = Bytes.add(key, Bytes.add(new byte[]{44}, family));
            if (qualifier != null && qualifier.length > 0) {
                key = Bytes.add(key, Bytes.add(new byte[]{44}, qualifier));
            }
        }
        return key;
    }

    static boolean isAclRegion(HRegion region) {
        return Bytes.equals(ACL_TABLE_NAME, region.getTableDesc().getName());
    }

    static boolean isAclTable(HTableDescriptor desc) {
        return Bytes.equals(ACL_TABLE_NAME, desc.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<byte[], ListMultimap<String, TablePermission>> loadAll(HRegion aclRegion) throws IOException {
        if (!AccessControlLists.isAclRegion(aclRegion)) {
            throw new IOException("Can only load permissions from _acl_");
        }
        TreeMap<byte[], ListMultimap<String, TablePermission>> allPerms = new TreeMap<byte[], ListMultimap<String, TablePermission>>(Bytes.BYTES_COMPARATOR);
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        RegionScanner iScanner = null;
        try {
            boolean hasNext;
            iScanner = aclRegion.getScanner(scan);
            do {
                ArrayList<KeyValue> row = new ArrayList<KeyValue>();
                hasNext = iScanner.next(row);
                ArrayListMultimap perms = ArrayListMultimap.create();
                byte[] table = null;
                for (KeyValue kv : row) {
                    Pair<String, TablePermission> permissionsOfUserOnTable;
                    if (table == null) {
                        table = kv.getRow();
                    }
                    if ((permissionsOfUserOnTable = AccessControlLists.parseTablePermissionRecord(table, kv)) == null) continue;
                    String username = permissionsOfUserOnTable.getFirst();
                    TablePermission permissions = permissionsOfUserOnTable.getSecond();
                    perms.put((Object)username, (Object)permissions);
                }
                if (table == null) continue;
                allPerms.put(table, (ListMultimap<String, TablePermission>)perms);
            } while (hasNext);
        }
        finally {
            if (iScanner != null) {
                iScanner.close();
            }
        }
        return allPerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<byte[], ListMultimap<String, TablePermission>> loadAll(Configuration conf) throws IOException {
        TreeMap<byte[], ListMultimap<String, TablePermission>> allPerms = new TreeMap<byte[], ListMultimap<String, TablePermission>>(Bytes.BYTES_COMPARATOR);
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        HTable acls = null;
        ResultScanner scanner = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            scanner = acls.getScanner(scan);
            for (Result row : scanner) {
                ListMultimap<String, TablePermission> resultPerms = AccessControlLists.parseTablePermissions(row.getRow(), row);
                allPerms.put(row.getRow(), resultPerms);
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (acls != null) {
                acls.close();
            }
        }
        return allPerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ListMultimap<String, TablePermission> getTablePermissions(Configuration conf, byte[] tableName) throws IOException {
        if (tableName == null) {
            tableName = ACL_TABLE_NAME;
        }
        ListMultimap<String, TablePermission> perms = ArrayListMultimap.create();
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            Get get2 = new Get(tableName);
            get2.addFamily(ACL_LIST_FAMILY);
            Result row = acls.get(get2);
            if (!row.isEmpty()) {
                perms = AccessControlLists.parseTablePermissions(tableName, row);
            } else {
                LOG.info((Object)("No permissions found in _acl_ for table " + Bytes.toString(tableName)));
            }
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
        return perms;
    }

    static List<UserPermission> getUserPermissions(Configuration conf, byte[] tableName) throws IOException {
        ListMultimap<String, TablePermission> allPerms = AccessControlLists.getTablePermissions(conf, tableName);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>();
        for (Map.Entry entry : allPerms.entries()) {
            UserPermission up = new UserPermission(Bytes.toBytes((String)entry.getKey()), ((TablePermission)((Object)entry.getValue())).getTable(), ((TablePermission)((Object)entry.getValue())).getFamily(), ((TablePermission)((Object)entry.getValue())).getQualifier(), ((TablePermission)((Object)entry.getValue())).getActions());
            perms.add(up);
        }
        return perms;
    }

    private static ListMultimap<String, TablePermission> parseTablePermissions(byte[] table, Result result) {
        ArrayListMultimap perms = ArrayListMultimap.create();
        if (result != null && result.size() > 0) {
            for (KeyValue kv : result.raw()) {
                Pair<String, TablePermission> permissionsOfUserOnTable = AccessControlLists.parseTablePermissionRecord(table, kv);
                if (permissionsOfUserOnTable == null) continue;
                String username = permissionsOfUserOnTable.getFirst();
                TablePermission permissions = permissionsOfUserOnTable.getSecond();
                perms.put((Object)username, (Object)permissions);
            }
        }
        return perms;
    }

    private static Pair<String, TablePermission> parseTablePermissionRecord(byte[] table, KeyValue kv) {
        byte[] family = kv.getFamily();
        if (!Bytes.equals(family, ACL_LIST_FAMILY)) {
            return null;
        }
        byte[] key = kv.getQualifier();
        byte[] value = kv.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Read acl: kv [" + Bytes.toStringBinary(key) + ": " + Bytes.toStringBinary(value) + "]"));
        }
        String username = Bytes.toString(key);
        int idx = username.indexOf(44);
        byte[] permFamily = null;
        byte[] permQualifier = null;
        if (idx > 0 && idx < username.length() - 1) {
            String remainder = username.substring(idx + 1);
            username = username.substring(0, idx);
            idx = remainder.indexOf(44);
            if (idx > 0 && idx < remainder.length() - 1) {
                permFamily = Bytes.toBytes(remainder.substring(0, idx));
                permQualifier = Bytes.toBytes(remainder.substring(idx + 1));
            } else {
                permFamily = Bytes.toBytes(remainder);
            }
        }
        return new Pair<String, TablePermission>(username, new TablePermission(table, permFamily, permQualifier, value));
    }

    public static void writePermissions(DataOutput out, ListMultimap<String, ? extends Permission> perms, Configuration conf) throws IOException {
        Set keys = perms.keySet();
        out.writeInt(keys.size());
        for (String key : keys) {
            Text.writeString((DataOutput)out, (String)key);
            HbaseObjectWritable.writeObject(out, perms.get((Object)key), List.class, conf);
        }
    }

    public static byte[] writePermissionsAsBytes(ListMultimap<String, ? extends Permission> perms, Configuration conf) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            AccessControlLists.writePermissions(new DataOutputStream(bos), perms, conf);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error serializing permissions", (Throwable)ioe);
            return null;
        }
    }

    public static <T extends Permission> ListMultimap<String, T> readPermissions(DataInput in, Configuration conf) throws IOException {
        ArrayListMultimap perms = ArrayListMultimap.create();
        int length = in.readInt();
        for (int i = 0; i < length; ++i) {
            String user = Text.readString((DataInput)in);
            List userPerms = (List)HbaseObjectWritable.readObject(in, conf);
            perms.putAll((Object)user, (Iterable)userPerms);
        }
        return perms;
    }

    public static boolean isGroupPrincipal(String name) {
        return name != null && name.startsWith(GROUP_PREFIX);
    }

    public static String getGroupName(String aclKey) {
        if (!AccessControlLists.isGroupPrincipal(aclKey)) {
            return aclKey;
        }
        return aclKey.substring(GROUP_PREFIX.length());
    }

    static {
        ACL_TABLEDESC.addFamily(new HColumnDescriptor(ACL_LIST_FAMILY, 10, Compression.Algorithm.NONE.getName(), true, true, 8192, Integer.MAX_VALUE, StoreFile.BloomType.NONE.toString(), 0));
        LOG = LogFactory.getLog(AccessControlLists.class);
    }
}

