/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.hadoop.hbase.rest.filter.GZIPResponseStream;

public class GZIPResponseWrapper
extends HttpServletResponseWrapper {
    private HttpServletResponse response;
    private ServletOutputStream os;
    private PrintWriter writer;
    private boolean compress = true;

    public GZIPResponseWrapper(HttpServletResponse response) {
        super(response);
        this.response = response;
    }

    public void setStatus(int status) {
        super.setStatus(status);
        if (status < 200 || status >= 300) {
            this.compress = false;
        }
    }

    public void addHeader(String name, String value) {
        if (!"content-length".equalsIgnoreCase(name)) {
            super.addHeader(name, value);
        }
    }

    public void setContentLength(int length) {
    }

    public void setIntHeader(String name, int value) {
        if (!"content-length".equalsIgnoreCase(name)) {
            super.setIntHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if (!"content-length".equalsIgnoreCase(name)) {
            super.setHeader(name, value);
        }
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.os != null && this.os instanceof GZIPResponseStream) {
            ((GZIPResponseStream)this.os).finish();
        } else {
            this.getResponse().flushBuffer();
        }
    }

    public void reset() {
        super.reset();
        if (this.os != null && this.os instanceof GZIPResponseStream) {
            ((GZIPResponseStream)this.os).resetBuffer();
        }
        this.writer = null;
        this.os = null;
        this.compress = true;
    }

    public void resetBuffer() {
        super.resetBuffer();
        if (this.os != null && this.os instanceof GZIPResponseStream) {
            ((GZIPResponseStream)this.os).resetBuffer();
        }
        this.writer = null;
        this.os = null;
    }

    public void sendError(int status, String msg) throws IOException {
        this.resetBuffer();
        super.sendError(status, msg);
    }

    public void sendError(int status) throws IOException {
        this.resetBuffer();
        super.sendError(status);
    }

    public void sendRedirect(String location) throws IOException {
        this.resetBuffer();
        super.sendRedirect(location);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = !this.response.isCommitted() && this.compress ? new GZIPResponseStream(this.response) : this.response.getOutputStream();
        }
        return this.os;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((OutputStream)this.getOutputStream());
        }
        return this.writer;
    }
}

