/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationStatistics;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class ReplicationSinkMetrics
implements Updater {
    private final MetricsRecord metricsRecord;
    private MetricsRegistry registry = new MetricsRegistry();
    private static ReplicationSinkMetrics instance;
    public final MetricsRate appliedOpsRate = new MetricsRate("appliedOpsRate", this.registry);
    public final MetricsRate appliedBatchesRate = new MetricsRate("appliedBatchesRate", this.registry);
    private final MetricsLongValue ageOfLastAppliedOp = new MetricsLongValue("ageOfLastAppliedOp", this.registry);

    public ReplicationSinkMetrics() {
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        String name = Thread.currentThread().getName();
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"replication");
        this.metricsRecord.setTag("RegionServer", name);
        context.registerUpdater((Updater)this);
        new ReplicationStatistics(this.registry, "ReplicationSink");
    }

    public void setAgeOfLastAppliedOp(long timestamp) {
        this.ageOfLastAppliedOp.set(System.currentTimeMillis() - timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext metricsContext) {
        ReplicationSinkMetrics replicationSinkMetrics = this;
        synchronized (replicationSinkMetrics) {
            this.appliedOpsRate.pushMetric(this.metricsRecord);
            this.appliedBatchesRate.pushMetric(this.metricsRecord);
            this.ageOfLastAppliedOp.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }
}

