/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.metrics.RegionMetricsStorage;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

public class StoreScanner
extends NonLazyKeyValueScanner
implements KeyValueScanner,
InternalScanner,
ChangedReadersObserver {
    static final Log LOG = LogFactory.getLog(StoreScanner.class);
    private Store store;
    private ScanQueryMatcher matcher;
    private KeyValueHeap heap;
    private boolean cacheBlocks;
    private String metricNamePrefix;
    private String metricNamePrefixNext;
    private boolean closing = false;
    private final boolean isGet;
    private final boolean explicitColumnQuery;
    private final boolean useRowColBloom;
    private final Scan scan;
    private final NavigableSet<byte[]> columns;
    private final long oldestUnexpiredTS;
    private final int minVersions;
    static final boolean LAZY_SEEK_ENABLED_BY_DEFAULT = true;
    private static boolean lazySeekEnabledGlobally = true;
    private KeyValue lastTop = null;
    private boolean scanUsePread = false;
    private ReentrantLock lock = new ReentrantLock();

    private StoreScanner(Store store, boolean cacheBlocks, Scan scan, NavigableSet<byte[]> columns, long ttl, int minVersions) {
        this.store = store;
        this.cacheBlocks = cacheBlocks;
        this.isGet = scan.isGetScan();
        int numCol = columns == null ? 0 : columns.size();
        this.explicitColumnQuery = numCol > 0;
        this.scan = scan;
        this.columns = columns;
        this.oldestUnexpiredTS = EnvironmentEdgeManager.currentTimeMillis() - ttl;
        this.minVersions = minVersions;
        this.useRowColBloom = numCol > 1 || !this.isGet && numCol == 1;
        this.scanUsePread = scan.isSmall();
    }

    public StoreScanner(Store store, Store.ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns) throws IOException {
        this(store, scan.getCacheBlocks(), scan, columns, scanInfo.getTtl(), scanInfo.getMinVersions());
        this.initializeMetricNames();
        if (columns != null && scan.isRaw()) {
            throw new DoNotRetryIOException("Cannot specify any column for a raw scan");
        }
        this.matcher = new ScanQueryMatcher(scan, scanInfo, columns, ScanType.USER_SCAN, Long.MAX_VALUE, Long.MAX_VALUE, this.oldestUnexpiredTS);
        List<KeyValueScanner> scanners = this.getScannersNoCompaction();
        if (this.explicitColumnQuery && lazySeekEnabledGlobally) {
            for (KeyValueScanner scanner : scanners) {
                scanner.requestSeek(this.matcher.getStartKey(), false, true);
            }
        } else {
            for (KeyValueScanner scanner : scanners) {
                scanner.seek(this.matcher.getStartKey());
            }
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
        this.store.addChangedReaderObserver(this);
    }

    public StoreScanner(Store store, Store.ScanInfo scanInfo, Scan scan, List<? extends KeyValueScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        this(store, false, scan, null, scanInfo.getTtl(), scanInfo.getMinVersions());
        this.initializeMetricNames();
        this.matcher = new ScanQueryMatcher(scan, scanInfo, null, scanType, smallestReadPoint, earliestPutTs, this.oldestUnexpiredTS);
        scanners = this.selectScannersFrom(scanners);
        for (KeyValueScanner keyValueScanner : scanners) {
            keyValueScanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
    }

    StoreScanner(Scan scan, Store.ScanInfo scanInfo, ScanType scanType, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners) throws IOException {
        this(scan, scanInfo, scanType, columns, scanners, Long.MAX_VALUE);
    }

    StoreScanner(Scan scan, Store.ScanInfo scanInfo, ScanType scanType, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners, long earliestPutTs) throws IOException {
        this(null, scan.getCacheBlocks(), scan, columns, scanInfo.getTtl(), scanInfo.getMinVersions());
        this.initializeMetricNames();
        this.matcher = new ScanQueryMatcher(scan, scanInfo, columns, scanType, Long.MAX_VALUE, earliestPutTs, this.oldestUnexpiredTS);
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, scanInfo.getComparator());
    }

    private void initializeMetricNames() {
        String tableName = "__unknown";
        String family = "__unknown";
        if (this.store != null) {
            tableName = this.store.getTableName();
            family = Bytes.toString(this.store.getFamily().getName());
        }
        this.metricNamePrefix = SchemaMetrics.generateSchemaMetricsPrefix(tableName, family);
    }

    private List<KeyValueScanner> getScannersNoCompaction() throws IOException {
        boolean isCompaction = false;
        boolean usePread = this.isGet || this.scanUsePread;
        return this.selectScannersFrom(this.store.getScanners(this.cacheBlocks, usePread, false, this.matcher));
    }

    private List<KeyValueScanner> selectScannersFrom(List<? extends KeyValueScanner> allScanners) {
        boolean filesOnly;
        boolean memOnly;
        if (this.scan instanceof InternalScan) {
            InternalScan iscan = (InternalScan)this.scan;
            memOnly = iscan.isCheckOnlyMemStore();
            filesOnly = iscan.isCheckOnlyStoreFiles();
        } else {
            memOnly = false;
            filesOnly = false;
        }
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(allScanners.size());
        long expiredTimestampCutoff = this.minVersions == 0 ? this.oldestUnexpiredTS : Long.MIN_VALUE;
        for (KeyValueScanner keyValueScanner : allScanners) {
            boolean isFile = keyValueScanner.isFileScanner();
            if (!isFile && filesOnly || isFile && memOnly || !keyValueScanner.shouldUseScanner(this.scan, this.columns, expiredTimestampCutoff)) continue;
            scanners.add(keyValueScanner);
        }
        return scanners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValue peek() {
        this.lock.lock();
        try {
            if (this.heap == null) {
                KeyValue keyValue = this.lastTop;
                return keyValue;
            }
            KeyValue keyValue = this.heap.peek();
            return keyValue;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public KeyValue next() {
        throw new RuntimeException("Never call StoreScanner.next()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.closing) {
                return;
            }
            this.closing = true;
            if (this.store != null) {
                this.store.deleteChangedReaderObserver(this);
            }
            if (this.heap != null) {
                this.heap.close();
            }
            this.heap = null;
            this.lastTop = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean seek(KeyValue key) throws IOException {
        this.lock.lock();
        try {
            if (this.heap == null) {
                List<KeyValueScanner> scanners = this.getScannersNoCompaction();
                this.heap = new KeyValueHeap(scanners, this.store.comparator);
            }
            boolean bl = this.heap.seek(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean next(List<KeyValue> outResult, int limit) throws IOException {
        return this.next(outResult, limit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next(List<KeyValue> outResult, int limit, String metric) throws IOException {
        this.lock.lock();
        try {
            int count;
            block45: {
                if (this.checkReseek()) {
                    boolean bl = true;
                    return bl;
                }
                if (this.heap == null) {
                    this.close();
                    boolean bl = false;
                    return bl;
                }
                KeyValue peeked = this.heap.peek();
                if (peeked == null) {
                    this.close();
                    boolean bl = false;
                    return bl;
                }
                byte[] row = peeked.getBuffer();
                int offset = peeked.getRowOffset();
                short length = peeked.getRowLength();
                if (limit < 0 || this.matcher.row == null || !Bytes.equals(row, offset, length, this.matcher.row, this.matcher.rowOffset, this.matcher.rowLength)) {
                    this.matcher.setRow(row, offset, length);
                }
                KeyValue prevKV = null;
                KeyValue.KVComparator comparator = this.store != null ? this.store.getComparator() : null;
                long cumulativeMetric = 0L;
                count = 0;
                try {
                    KeyValue kv;
                    block27: while ((kv = this.heap.peek()) != null) {
                        assert (prevKV == null || comparator == null || comparator.compare(prevKV, kv) <= 0) : "Key " + prevKV + " followed by a " + "smaller key " + kv + " in cf " + this.store;
                        prevKV = kv;
                        ScanQueryMatcher.MatchCode qcode = this.matcher.match(kv);
                        switch (qcode) {
                            case INCLUDE: 
                            case INCLUDE_AND_SEEK_NEXT_ROW: 
                            case INCLUDE_AND_SEEK_NEXT_COL: {
                                Filter f = this.matcher.getFilter();
                                outResult.add(f == null ? kv : f.transform(kv));
                                ++count;
                                if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW) {
                                    if (!this.matcher.moreRowsMayExistAfter(kv)) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                    this.reseek(this.matcher.getKeyForNextRow(kv));
                                } else if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL) {
                                    this.reseek(this.matcher.getKeyForNextColumn(kv));
                                } else {
                                    this.heap.next();
                                }
                                cumulativeMetric += (long)kv.getLength();
                                if (limit <= 0 || count != limit) continue block27;
                                break block45;
                            }
                            case DONE: {
                                boolean bl = true;
                                return bl;
                            }
                            case DONE_SCAN: {
                                this.close();
                                boolean bl = false;
                                return bl;
                            }
                            case SEEK_NEXT_ROW: {
                                if (!this.matcher.moreRowsMayExistAfter(kv)) {
                                    boolean bl = false;
                                    return bl;
                                }
                                this.reseek(this.matcher.getKeyForNextRow(kv));
                                break;
                            }
                            case SEEK_NEXT_COL: {
                                this.reseek(this.matcher.getKeyForNextColumn(kv));
                                break;
                            }
                            case SKIP: {
                                this.heap.next();
                                break;
                            }
                            case SEEK_NEXT_USING_HINT: {
                                KeyValue nextKV = this.matcher.getNextKeyHint(kv);
                                if (nextKV != null) {
                                    this.reseek(nextKV);
                                    break;
                                }
                                this.heap.next();
                                break;
                            }
                            default: {
                                throw new RuntimeException("UNEXPECTED");
                            }
                        }
                    }
                }
                finally {
                    if (cumulativeMetric > 0L && metric != null) {
                        if (metric == "nextsize") {
                            if (this.metricNamePrefixNext == null) {
                                this.metricNamePrefixNext = this.metricNamePrefix + metric;
                            }
                            RegionMetricsStorage.incrNumericMetric(this.metricNamePrefixNext, cumulativeMetric);
                        } else {
                            RegionMetricsStorage.incrNumericMetric(this.metricNamePrefix + metric, cumulativeMetric);
                        }
                    }
                }
            }
            if (count > 0) {
                boolean bl = true;
                return bl;
            }
            this.close();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean next(List<KeyValue> outResult) throws IOException {
        return this.next(outResult, -1, null);
    }

    @Override
    public boolean next(List<KeyValue> outResult, String metric) throws IOException {
        return this.next(outResult, -1, metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReaders() throws IOException {
        this.lock.lock();
        try {
            if (this.closing) {
                return;
            }
            if (this.heap == null) {
                return;
            }
            this.lastTop = this.peek();
            this.heap.close();
            this.heap = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean checkReseek() throws IOException {
        if (this.heap == null && this.lastTop != null) {
            this.resetScannerStack(this.lastTop);
            if (this.heap.peek() == null || this.store.comparator.compareRows(this.lastTop, this.heap.peek()) != 0) {
                LOG.debug((Object)("Storescanner.peek() is changed where before = " + this.lastTop.toString() + ",and after = " + this.heap.peek()));
                this.lastTop = null;
                return true;
            }
            this.lastTop = null;
        }
        return false;
    }

    private void resetScannerStack(KeyValue lastTopKey) throws IOException {
        if (this.heap != null) {
            throw new RuntimeException("StoreScanner.reseek run on an existing heap!");
        }
        List<KeyValueScanner> scanners = this.getScannersNoCompaction();
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(lastTopKey);
        }
        this.heap = new KeyValueHeap(scanners, this.store.comparator);
        KeyValue kv = this.heap.peek();
        if (kv == null) {
            kv = lastTopKey;
        }
        byte[] row = kv.getBuffer();
        int offset = kv.getRowOffset();
        short length = kv.getRowLength();
        if (this.matcher.row == null || !Bytes.equals(row, offset, length, this.matcher.row, this.matcher.rowOffset, this.matcher.rowLength)) {
            this.matcher.reset();
            this.matcher.setRow(row, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reseek(KeyValue kv) throws IOException {
        this.lock.lock();
        try {
            this.checkReseek();
            if (this.explicitColumnQuery && lazySeekEnabledGlobally) {
                boolean bl = this.heap.requestSeek(kv, true, this.useRowColBloom);
                return bl;
            }
            boolean bl = this.heap.reseek(kv);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }

    List<KeyValueScanner> getAllScannersForTesting() {
        ArrayList<KeyValueScanner> allScanners = new ArrayList<KeyValueScanner>();
        KeyValueScanner current = this.heap.getCurrentForTesting();
        if (current != null) {
            allScanners.add(current);
        }
        for (KeyValueScanner scanner : this.heap.getHeap()) {
            allScanners.add(scanner);
        }
        return allScanners;
    }

    static void enableLazySeekGlobally(boolean enable) {
        lazySeekEnabledGlobally = enable;
    }
}

