/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.catalog.RootLocationEditor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.AssignCallable;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.UnAssignCallable;
import org.apache.hadoop.hbase.master.handler.ClosedRegionHandler;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.OpenedRegionHandler;
import org.apache.hadoop.hbase.master.handler.ServerShutdownHandler;
import org.apache.hadoop.hbase.master.handler.SplitRegionHandler;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class AssignmentManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(AssignmentManager.class);
    protected Server master;
    private ServerManager serverManager;
    private CatalogTracker catalogTracker;
    private TimeoutMonitor timeoutMonitor;
    private TimerUpdater timerUpdater;
    private LoadBalancer balancer;
    private final Map<String, HRegionInfo> regionsToReopen;
    private final int maximumAssignmentAttempts;
    final ConcurrentSkipListMap<String, RegionState> regionsInTransition = new ConcurrentSkipListMap();
    final NavigableMap<String, RegionPlan> regionPlans = new TreeMap<String, RegionPlan>();
    private final ZKTable zkTable;
    Set<String> disablingTables = new HashSet<String>(1);
    Map<String, List<HRegionInfo>> enablingTables = new HashMap<String, List<HRegionInfo>>(1);
    private final NavigableMap<ServerName, Set<HRegionInfo>> servers = new TreeMap<ServerName, Set<HRegionInfo>>();
    private final ConcurrentSkipListSet<ServerName> serversInUpdatingTimer = new ConcurrentSkipListSet();
    private final SortedMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
    private final org.apache.hadoop.hbase.executor.ExecutorService executorService;
    private ExecutorService threadPoolExecutorService;
    private List<EventHandler.EventType> ignoreStatesRSOffline = Arrays.asList(EventHandler.EventType.RS_ZK_REGION_FAILED_OPEN, EventHandler.EventType.RS_ZK_REGION_CLOSED);
    private volatile boolean failover = false;
    private Map<String, HRegionInfo> failoverProcessedRegions = new HashMap<String, HRegionInfo>();

    public AssignmentManager(Server master, ServerManager serverManager, CatalogTracker catalogTracker, LoadBalancer balancer, org.apache.hadoop.hbase.executor.ExecutorService service) throws KeeperException, IOException {
        super(master.getZooKeeper());
        this.master = master;
        this.serverManager = serverManager;
        this.catalogTracker = catalogTracker;
        this.executorService = service;
        this.regionsToReopen = Collections.synchronizedMap(new HashMap());
        Configuration conf = master.getConfiguration();
        this.timeoutMonitor = new TimeoutMonitor(conf.getInt("hbase.master.assignment.timeoutmonitor.period", 10000), master, serverManager, conf.getInt("hbase.master.assignment.timeoutmonitor.timeout", 1800000));
        this.timerUpdater = new TimerUpdater(conf.getInt("hbase.master.assignment.timerupdater.period", 10000), (Stoppable)master);
        Threads.setDaemonThreadRunning(this.timerUpdater.getThread(), master.getServerName() + ".timerUpdater");
        this.zkTable = new ZKTable(this.master.getZooKeeper());
        this.maximumAssignmentAttempts = this.master.getConfiguration().getInt("hbase.assignment.maximum.attempts", 10);
        this.balancer = balancer;
        this.threadPoolExecutorService = Executors.newCachedThreadPool();
    }

    void startTimeOutMonitor() {
        Threads.setDaemonThreadRunning(this.timeoutMonitor.getThread(), this.master.getServerName() + ".timeoutMonitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getAverageLoad() {
        int totalLoad = 0;
        int numServers = 0;
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            for (Map.Entry e : this.servers.entrySet()) {
                ++numServers;
                totalLoad += ((Set)e.getValue()).size();
            }
        }
        return (double)totalLoad / (double)numServers;
    }

    public ZKTable getZKTable() {
        return this.zkTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerName getRegionServerOfRegion(HRegionInfo hri) {
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            return (ServerName)this.regions.get((Object)hri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegionAssigned(HRegionInfo hri) {
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            return this.regions.containsKey((Object)hri);
        }
    }

    public List<HRegionInfo> getEnablingTableRegions(String tableName) {
        return this.enablingTables.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlan(String encodedName, RegionPlan plan) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.put(encodedName, plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlans(Map<String, RegionPlan> plans) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.putAll(plans);
        }
    }

    public void setRegionsToReopen(List<HRegionInfo> regions) {
        for (HRegionInfo hri : regions) {
            this.regionsToReopen.put(hri.getEncodedName(), hri);
        }
    }

    public Pair<Integer, Integer> getReopenStatus(byte[] tableName) throws IOException {
        List<HRegionInfo> hris = MetaReader.getTableRegions(this.master.getCatalogTracker(), tableName);
        Integer pending = 0;
        for (HRegionInfo hri : hris) {
            String name = hri.getEncodedName();
            if (!this.regionsToReopen.containsKey(name) && !this.regionsInTransition.containsKey(name)) continue;
            Integer n = pending;
            Integer n2 = pending = Integer.valueOf(pending + 1);
        }
        return new Pair<Integer, Integer>(pending, hris.size());
    }

    void cleanoutUnassigned() throws IOException, KeeperException {
        ZKAssign.deleteAllNodes(this.watcher);
        ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.assignmentZNode);
    }

    void joinCluster() throws IOException, KeeperException, InterruptedException {
        Map<ServerName, List<Pair<HRegionInfo, Result>>> deadServers = this.rebuildUserRegions();
        this.processDeadServersAndRegionsInTransition(deadServers);
        boolean isWatcherCreated = this.recoverTableInDisablingState(this.disablingTables);
        this.recoverTableInEnablingState(this.enablingTables.keySet(), isWatcherCreated);
        this.enablingTables.clear();
        this.disablingTables.clear();
    }

    void processDeadServersAndRegionsInTransition() throws KeeperException, IOException, InterruptedException {
        this.processDeadServersAndRegionsInTransition(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDeadServersAndRegionsInTransition(Map<ServerName, List<Pair<HRegionInfo, Result>>> deadServers) throws KeeperException, IOException, InterruptedException {
        List<String> nodes = ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.assignmentZNode);
        if (nodes == null) {
            String errorMessage = "Failed to get the children from ZK";
            this.master.abort(errorMessage, new IOException(errorMessage));
            return;
        }
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            for (Map.Entry<HRegionInfo, ServerName> e : this.regions.entrySet()) {
                if (!e.getKey().isMetaTable() && e.getValue() != null) {
                    LOG.debug((Object)("Found " + e + " out on cluster"));
                    this.failover = true;
                    break;
                }
                if (!nodes.contains(e.getKey().getEncodedName())) continue;
                LOG.debug((Object)("Found " + e.getKey().getRegionNameAsString() + " in RITs"));
                this.failover = true;
                break;
            }
        }
        sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            nodes.removeAll(this.regionsInTransition.keySet());
        }
        if (!this.serverManager.getDeadServers().isEmpty()) {
            this.failover = true;
        }
        if (this.failover) {
            LOG.info((Object)"Found regions out on cluster or in RIT; failover");
            this.processDeadServersAndRecoverLostRegions(deadServers, nodes);
            this.failover = false;
            this.failoverProcessedRegions.clear();
        } else {
            LOG.info((Object)"Clean cluster startup. Assigning userregions");
            this.cleanoutUnassigned();
            this.assignAllUserRegions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRegionInTransitionAndBlockUntilAssigned(HRegionInfo hri) throws InterruptedException, KeeperException, IOException {
        boolean intransistion = this.processRegionInTransition(hri.getEncodedName(), hri, null);
        if (!intransistion) {
            return intransistion;
        }
        LOG.debug((Object)("Waiting on " + HRegionInfo.prettyPrint(hri.getEncodedName())));
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            while (!this.master.isStopped() && this.regionsInTransition.containsKey(hri.getEncodedName())) {
                this.regionsInTransition.wait(100L);
            }
        }
        return intransistion;
    }

    boolean processRegionInTransition(String encodedRegionName, HRegionInfo regionInfo, Map<ServerName, List<Pair<HRegionInfo, Result>>> deadServers) throws KeeperException, IOException {
        Stat stat = new Stat();
        RegionTransitionData data = ZKAssign.getDataAndWatch(this.watcher, encodedRegionName, stat);
        if (data == null) {
            return false;
        }
        HRegionInfo hri = regionInfo;
        if (hri == null && (hri = this.getHRegionInfo(data)) == null) {
            return false;
        }
        this.processRegionsInTransition(data, hri, deadServers, stat.getVersion());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRegionsInTransition(RegionTransitionData data, HRegionInfo regionInfo, Map<ServerName, List<Pair<HRegionInfo, Result>>> deadServers, int expectedVersion) throws KeeperException {
        String encodedRegionName = regionInfo.getEncodedName();
        LOG.info((Object)("Processing region " + regionInfo.getRegionNameAsString() + " in state " + (Object)((Object)data.getEventType())));
        List<HRegionInfo> hris = this.enablingTables.get(regionInfo.getTableNameAsString());
        if (hris != null && !hris.isEmpty()) {
            hris.remove((Object)regionInfo);
        }
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            RegionState regionState = this.regionsInTransition.get(encodedRegionName);
            if (regionState != null || this.failoverProcessedRegions.containsKey(encodedRegionName)) {
                return;
            }
            switch (data.getEventType()) {
                case M_ZK_REGION_CLOSING: {
                    if (this.isOnDeadServer(regionInfo, deadServers) && (data.getOrigin() == null || !this.serverManager.isServerOnline(data.getOrigin()))) {
                        this.forceOffline(regionInfo, data);
                    } else {
                        this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.CLOSING, data.getStamp(), data.getOrigin()));
                    }
                    this.failoverProcessedRegions.put(encodedRegionName, regionInfo);
                    break;
                }
                case RS_ZK_REGION_CLOSED: 
                case RS_ZK_REGION_FAILED_OPEN: {
                    this.addToRITandCallClose(regionInfo, RegionState.State.CLOSED, data);
                    this.failoverProcessedRegions.put(encodedRegionName, regionInfo);
                    break;
                }
                case M_ZK_REGION_OFFLINE: {
                    if (this.isOnDeadServer(regionInfo, deadServers) && (data.getOrigin() == null || !this.serverManager.isServerOnline(data.getOrigin()))) {
                        this.addToRITandCallClose(regionInfo, RegionState.State.OFFLINE, data);
                    } else if (data.getOrigin() != null && !this.serverManager.isServerOnline(data.getOrigin())) {
                        this.addToRITandCallClose(regionInfo, RegionState.State.OFFLINE, data);
                    } else {
                        this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.PENDING_OPEN, data.getStamp(), data.getOrigin()));
                    }
                    this.failoverProcessedRegions.put(encodedRegionName, regionInfo);
                    break;
                }
                case RS_ZK_REGION_OPENING: {
                    if (regionInfo.isMetaTable()) {
                        this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.OPENING, data.getStamp(), data.getOrigin()));
                        this.processOpeningState(regionInfo);
                        break;
                    }
                    this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.OPENING, data.getStamp(), data.getOrigin()));
                    this.failoverProcessedRegions.put(encodedRegionName, regionInfo);
                    break;
                }
                case RS_ZK_REGION_OPENED: {
                    ServerName sn;
                    this.regionsInTransition.put(encodedRegionName, new RegionState(regionInfo, RegionState.State.OPEN, data.getStamp(), data.getOrigin()));
                    ServerName serverName = sn = data.getOrigin() == null ? null : data.getOrigin();
                    if (sn == null) {
                        LOG.warn((Object)("Region in transition " + regionInfo.getEncodedName() + " references a null server; letting RIT timeout so will be " + "assigned elsewhere"));
                    } else if (!this.serverManager.isServerOnline(sn) && (this.isOnDeadServer(regionInfo, deadServers) || regionInfo.isMetaRegion() || regionInfo.isRootRegion())) {
                        this.forceOffline(regionInfo, data);
                    } else {
                        new OpenedRegionHandler(this.master, this, regionInfo, sn, expectedVersion).process();
                    }
                    this.failoverProcessedRegions.put(encodedRegionName, regionInfo);
                }
            }
        }
    }

    private void forceOffline(HRegionInfo hri, RegionTransitionData oldData) throws KeeperException {
        LOG.debug((Object)("RIT " + hri.getEncodedName() + " in state=" + (Object)((Object)oldData.getEventType()) + " was on deadserver; forcing offline"));
        ZKAssign.createOrForceNodeOffline(this.watcher, hri, this.master.getServerName());
        this.addToRITandCallClose(hri, RegionState.State.OFFLINE, oldData);
    }

    private void addToRITandCallClose(HRegionInfo hri, RegionState.State state, RegionTransitionData oldData) {
        this.regionsInTransition.put(hri.getEncodedName(), new RegionState(hri, state, oldData.getStamp(), oldData.getOrigin()));
        new ClosedRegionHandler(this.master, this, hri).process();
    }

    public void removeClosedRegion(HRegionInfo hri) {
        if (!this.regionsToReopen.isEmpty() && this.regionsToReopen.remove(hri.getEncodedName()) != null) {
            LOG.debug((Object)"Removed region from reopening regions because it was closed");
        }
    }

    private boolean isOnDeadServer(HRegionInfo regionInfo, Map<ServerName, List<Pair<HRegionInfo, Result>>> deadServers) {
        if (deadServers == null) {
            return false;
        }
        for (Map.Entry<ServerName, List<Pair<HRegionInfo, Result>>> deadServer : deadServers.entrySet()) {
            for (Pair<HRegionInfo, Result> e : deadServer.getValue()) {
                if (!e.getFirst().equals((Object)regionInfo)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegion(RegionTransitionData data, int expectedVersion) {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            HRegionInfo hri = null;
            if (data == null || data.getOrigin() == null) {
                LOG.warn((Object)("Unexpected NULL input " + data));
                return;
            }
            ServerName sn = data.getOrigin();
            if (sn.equals(HConstants.HBCK_CODE_SERVERNAME)) {
                this.handleHBCK(data);
                return;
            }
            String encodedName = HRegionInfo.encodeRegionName(data.getRegionName());
            String prettyPrintedRegionName = HRegionInfo.prettyPrint(encodedName);
            if (!(this.serverManager.isServerOnline(sn) || this.master.getServerName().equals(sn) || this.ignoreStatesRSOffline.contains((Object)data.getEventType()))) {
                LOG.warn((Object)("Attempted to handle region transition for server but server is not online: " + prettyPrintedRegionName));
                return;
            }
            boolean lateEvent = data.getStamp() < System.currentTimeMillis() - 15000L;
            LOG.debug((Object)("Handling transition=" + (Object)((Object)data.getEventType()) + ", server=" + data.getOrigin() + ", region=" + (prettyPrintedRegionName == null ? "null" : prettyPrintedRegionName) + (lateEvent ? ", which is more than 15 seconds late" : "")));
            RegionState regionState = this.regionsInTransition.get(encodedName);
            switch (data.getEventType()) {
                case M_ZK_REGION_OFFLINE: {
                    break;
                }
                case RS_ZK_REGION_SPLITTING: {
                    if (!this.isInStateForSplitting(regionState)) break;
                    this.addSplittingToRIT(sn, encodedName);
                    break;
                }
                case RS_ZK_REGION_SPLIT: {
                    if (!this.isInStateForSplitting(regionState)) break;
                    if (regionState == null) {
                        regionState = this.addSplittingToRIT(sn, encodedName);
                        String message = "Received SPLIT for region " + prettyPrintedRegionName + " from server " + sn;
                        if (regionState == null) {
                            LOG.warn((Object)(message + " but it doesn't exist anymore," + " probably already processed its split"));
                            break;
                        }
                        LOG.info((Object)(message + " but region was not first in SPLITTING state; continuing"));
                    }
                    byte[] payload = data.getPayload();
                    List<HRegionInfo> daughters = null;
                    try {
                        daughters = Writables.getHRegionInfos(payload, 0, payload.length);
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Dropped split! Failed reading split payload for " + prettyPrintedRegionName));
                        break;
                    }
                    assert (daughters.size() == 2);
                    if (!this.serverManager.isServerOnline(sn)) {
                        LOG.error((Object)("Dropped split! ServerName=" + sn + " unknown."));
                        break;
                    }
                    this.executorService.submit(new SplitRegionHandler(this.master, this, regionState.getRegion(), sn, daughters));
                    break;
                }
                case M_ZK_REGION_CLOSING: {
                    hri = this.checkIfInFailover(regionState, encodedName, data);
                    if (hri != null) {
                        regionState = new RegionState(hri, RegionState.State.CLOSING, data.getStamp(), data.getOrigin());
                        this.regionsInTransition.put(encodedName, regionState);
                        this.failoverProcessedRegions.put(encodedName, hri);
                        break;
                    }
                    if (regionState == null || !regionState.isPendingClose() && !regionState.isClosing()) {
                        LOG.warn((Object)("Received CLOSING for region " + prettyPrintedRegionName + " from server " + data.getOrigin() + " but region was in " + " the state " + regionState + " and not " + "in expected PENDING_CLOSE or CLOSING states"));
                        return;
                    }
                    regionState.update(RegionState.State.CLOSING, data.getStamp(), data.getOrigin());
                    break;
                }
                case RS_ZK_REGION_CLOSED: {
                    hri = this.checkIfInFailover(regionState, encodedName, data);
                    if (hri != null) {
                        regionState = new RegionState(hri, RegionState.State.CLOSED, data.getStamp(), data.getOrigin());
                        this.regionsInTransition.put(encodedName, regionState);
                        this.removeClosedRegion(regionState.getRegion());
                        new ClosedRegionHandler(this.master, this, regionState.getRegion()).process();
                        this.failoverProcessedRegions.put(encodedName, hri);
                        break;
                    }
                    if (regionState == null || !regionState.isPendingClose() && !regionState.isClosing()) {
                        LOG.warn((Object)("Received CLOSED for region " + prettyPrintedRegionName + " from server " + data.getOrigin() + " but region was in " + " the state " + regionState + " and not " + "in expected PENDING_CLOSE or CLOSING states"));
                        return;
                    }
                    regionState.update(RegionState.State.CLOSED, data.getStamp(), data.getOrigin());
                    this.removeClosedRegion(regionState.getRegion());
                    this.executorService.submit(new ClosedRegionHandler(this.master, this, regionState.getRegion()));
                    break;
                }
                case RS_ZK_REGION_FAILED_OPEN: {
                    hri = this.checkIfInFailover(regionState, encodedName, data);
                    if (hri != null) {
                        regionState = new RegionState(hri, RegionState.State.CLOSED, data.getStamp(), data.getOrigin());
                        this.regionsInTransition.put(encodedName, regionState);
                        new ClosedRegionHandler(this.master, this, regionState.getRegion()).process();
                        this.failoverProcessedRegions.put(encodedName, hri);
                        break;
                    }
                    if (regionState == null || !regionState.isOffline() && !regionState.isPendingOpen() && !regionState.isOpening()) {
                        LOG.warn((Object)("Received FAILED_OPEN for region " + prettyPrintedRegionName + " from server " + data.getOrigin() + " but region was in " + " the state " + regionState + " and not in OFFLINE, PENDING_OPEN or OPENING"));
                        return;
                    }
                    regionState.update(RegionState.State.CLOSED, data.getStamp(), data.getOrigin());
                    this.getRegionPlan(regionState, sn, true);
                    this.executorService.submit(new ClosedRegionHandler(this.master, this, regionState.getRegion()));
                    break;
                }
                case RS_ZK_REGION_OPENING: {
                    hri = this.checkIfInFailover(regionState, encodedName, data);
                    if (hri != null) {
                        regionState = new RegionState(hri, RegionState.State.OPENING, data.getStamp(), data.getOrigin());
                        this.regionsInTransition.put(encodedName, regionState);
                        this.failoverProcessedRegions.put(encodedName, hri);
                        break;
                    }
                    if (regionState == null || !regionState.isOffline() && !regionState.isPendingOpen() && !regionState.isOpening()) {
                        LOG.warn((Object)("Received OPENING for region " + prettyPrintedRegionName + " from server " + sn + " but region was in " + " the state " + regionState + " and not " + "in expected OFFLINE, PENDING_OPEN or OPENING states"));
                        return;
                    }
                    regionState.update(RegionState.State.OPENING, data.getStamp(), data.getOrigin());
                    break;
                }
                case RS_ZK_REGION_OPENED: {
                    hri = this.checkIfInFailover(regionState, encodedName, data);
                    if (hri != null) {
                        regionState = new RegionState(hri, RegionState.State.OPEN, data.getStamp(), data.getOrigin());
                        this.regionsInTransition.put(encodedName, regionState);
                        new OpenedRegionHandler(this.master, this, regionState.getRegion(), data.getOrigin(), expectedVersion).process();
                        this.failoverProcessedRegions.put(encodedName, hri);
                        break;
                    }
                    if (regionState == null || !regionState.isOffline() && !regionState.isPendingOpen() && !regionState.isOpening()) {
                        LOG.warn((Object)("Received OPENED for region " + prettyPrintedRegionName + " from server " + data.getOrigin() + " but region was in " + " the state " + regionState + " and not " + "in expected OFFLINE, PENDING_OPEN or OPENING states"));
                        return;
                    }
                    regionState.update(RegionState.State.OPEN, data.getStamp(), data.getOrigin());
                    this.executorService.submit(new OpenedRegionHandler(this.master, this, regionState.getRegion(), data.getOrigin(), expectedVersion));
                }
            }
        }
    }

    private HRegionInfo checkIfInFailover(RegionState regionState, String encodedName, RegionTransitionData data) {
        if (regionState == null && this.failover && (!this.failoverProcessedRegions.containsKey(encodedName) || this.failoverProcessedRegions.get(encodedName) == null)) {
            HRegionInfo hri = this.failoverProcessedRegions.get(encodedName);
            if (hri == null) {
                hri = this.getHRegionInfo(data);
            }
            return hri;
        }
        return null;
    }

    private HRegionInfo getHRegionInfo(RegionTransitionData data) {
        Pair<HRegionInfo, ServerName> p = null;
        try {
            p = MetaReader.getRegion(this.catalogTracker, data.getRegionName());
            if (p == null) {
                return null;
            }
            return p.getFirst();
        }
        catch (IOException e) {
            this.master.abort("Aborting because error occoured while reading " + data.getRegionName() + " from .META.", e);
            return null;
        }
    }

    private boolean isInStateForSplitting(RegionState rs) {
        if (rs == null) {
            return true;
        }
        if (rs.isSplitting()) {
            return true;
        }
        if (this.convertPendingCloseToSplitting(rs)) {
            return true;
        }
        LOG.warn((Object)("Dropped region split! Not in state good for SPLITTING; rs=" + rs));
        return false;
    }

    private boolean convertPendingCloseToSplitting(RegionState rs) {
        if (!rs.isPendingClose()) {
            return false;
        }
        LOG.debug((Object)("Converting PENDING_CLOSE to SPLITING; rs=" + rs));
        rs.update(RegionState.State.SPLITTING);
        this.clearRegionPlan(rs.getRegion());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionState addSplittingToRIT(ServerName serverName, String encodedName) {
        RegionState regionState = null;
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            regionState = this.findHRegionInfoThenAddToRIT(serverName, encodedName);
            if (regionState != null) {
                regionState.update(RegionState.State.SPLITTING, System.currentTimeMillis(), serverName);
            }
        }
        return regionState;
    }

    private RegionState findHRegionInfoThenAddToRIT(ServerName serverName, String encodedName) {
        HRegionInfo hri = this.findHRegionInfo(serverName, encodedName);
        if (hri == null) {
            LOG.warn((Object)("Region " + encodedName + " not found on server " + serverName + "; failed processing"));
            return null;
        }
        return this.addToRegionsInTransition(hri);
    }

    private HRegionInfo findHRegionInfo(ServerName sn, String encodedName) {
        if (!this.serverManager.isServerOnline(sn)) {
            return null;
        }
        Set hris = (Set)this.servers.get(sn);
        HRegionInfo foundHri = null;
        for (HRegionInfo hri : hris) {
            if (!hri.getEncodedName().equals(encodedName)) continue;
            foundHri = hri;
            break;
        }
        return foundHri;
    }

    private void handleHBCK(RegionTransitionData data) {
        String encodedName = HRegionInfo.encodeRegionName(data.getRegionName());
        LOG.info((Object)("Handling HBCK triggered transition=" + (Object)((Object)data.getEventType()) + ", server=" + data.getOrigin() + ", region=" + HRegionInfo.prettyPrint(encodedName)));
        RegionState regionState = this.regionsInTransition.get(encodedName);
        switch (data.getEventType()) {
            case M_ZK_REGION_OFFLINE: {
                HRegionInfo regionInfo = null;
                if (regionState != null) {
                    regionInfo = regionState.getRegion();
                } else {
                    try {
                        byte[] name = data.getRegionName();
                        Pair<HRegionInfo, ServerName> p = MetaReader.getRegion(this.catalogTracker, name);
                        regionInfo = p.getFirst();
                    }
                    catch (IOException e) {
                        LOG.info((Object)"Exception reading META doing HBCK repair operation", (Throwable)e);
                        return;
                    }
                }
                LOG.info((Object)("HBCK repair is triggering assignment of region=" + regionInfo.getRegionNameAsString()));
                this.assign(regionInfo, false);
                break;
            }
            default: {
                LOG.warn((Object)("Received unexpected region state from HBCK (" + (Object)((Object)data.getEventType()) + ")"));
            }
        }
    }

    @Override
    public void nodeCreated(String path) {
        if (path.startsWith(this.watcher.assignmentZNode)) {
            try {
                Stat stat = new Stat();
                RegionTransitionData data = ZKAssign.getDataAndWatch(this.watcher, path, stat);
                if (data == null) {
                    return;
                }
                this.handleRegion(data, stat.getVersion());
            }
            catch (KeeperException e) {
                this.master.abort("Unexpected ZK exception reading unassigned node data", e);
            }
        }
    }

    @Override
    public void nodeDataChanged(String path) {
        if (path.startsWith(this.watcher.assignmentZNode)) {
            try {
                Stat stat = new Stat();
                RegionTransitionData data = ZKAssign.getDataAndWatch(this.watcher, path, stat);
                if (data == null) {
                    return;
                }
                this.handleRegion(data, stat.getVersion());
            }
            catch (KeeperException e) {
                this.master.abort("Unexpected ZK exception reading unassigned node data", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDeleted(String path) {
        String regionName;
        RegionState rs;
        if (path.startsWith(this.watcher.assignmentZNode) && (rs = this.regionsInTransition.get(regionName = ZKAssign.getRegionName(this.master.getZooKeeper(), path))) != null) {
            HRegionInfo regionInfo = rs.getRegion();
            if (rs.isSplit()) {
                LOG.debug((Object)("Ephemeral node deleted, regionserver crashed?, offlining the region" + (Object)((Object)rs.getRegion()) + " clearing from RIT;"));
                this.regionOffline(rs.getRegion());
            } else if (rs.isSplitting()) {
                LOG.debug((Object)("Ephemeral node deleted.  Found in SPLITTING state. Removing from RIT " + (Object)((Object)rs.getRegion())));
                ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
                synchronized (concurrentSkipListMap) {
                    this.regionsInTransition.remove(regionName);
                }
            } else {
                LOG.debug((Object)("The znode of region " + regionInfo.getRegionNameAsString() + " has been deleted."));
                if (rs.isOpened()) {
                    this.makeRegionOnline(rs, regionInfo);
                }
            }
        }
    }

    private void makeRegionOnline(RegionState rs, HRegionInfo regionInfo) {
        this.regionOnline(regionInfo, rs.serverName);
        LOG.info((Object)("The master has opened the region " + regionInfo.getRegionNameAsString() + " that was online on " + rs.serverName));
        if (this.getZKTable().isDisablingOrDisabledTable(regionInfo.getTableNameAsString())) {
            LOG.debug((Object)("Opened region " + regionInfo.getRegionNameAsString() + " but " + "this table is disabled, triggering close of region"));
            this.unassign(regionInfo);
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.assignmentZNode)) {
            try {
                List<String> children = ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.assignmentZNode);
                if (children != null) {
                    Stat stat = new Stat();
                    for (String child : children) {
                        stat.setVersion(0);
                        RegionTransitionData data = ZKAssign.getDataAndWatch(this.watcher, ZKUtil.joinZNode(this.watcher.assignmentZNode, child), stat);
                        if (stat.getVersion() <= 0 || data.getEventType() != EventHandler.EventType.RS_ZK_REGION_SPLITTING) continue;
                        this.handleRegion(data, stat.getVersion());
                    }
                }
            }
            catch (KeeperException e) {
                this.master.abort("Unexpected ZK exception reading unassigned children", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void regionOnline(HRegionInfo regionInfo, ServerName sn) {
        SortedMap<Object, Object> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState rs = this.regionsInTransition.remove(regionInfo.getEncodedName());
            if (rs != null) {
                this.regionsInTransition.notifyAll();
            }
        }
        sortedMap = this.regions;
        synchronized (sortedMap) {
            ServerName oldSn = (ServerName)this.regions.get((Object)regionInfo);
            if (oldSn != null) {
                LOG.warn((Object)("Overwriting " + regionInfo.getEncodedName() + " on " + oldSn + " with " + sn));
            }
            if (this.isServerOnline(sn)) {
                this.regions.put(regionInfo, sn);
                this.addToServers(sn, regionInfo);
                this.regions.notifyAll();
            } else {
                LOG.info((Object)("The server is not in online servers, ServerName=" + sn.getServerName() + ", region=" + regionInfo.getEncodedName()));
            }
        }
        this.clearRegionPlan(regionInfo);
        this.addToServersInUpdatingTimer(sn);
    }

    private void addToServersInUpdatingTimer(ServerName sn) {
        this.serversInUpdatingTimer.add(sn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimers(ServerName sn) {
        HashMap<String, RegionPlan> copy = new HashMap<String, RegionPlan>();
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            copy.putAll(this.regionPlans);
        }
        for (Map.Entry e : copy.entrySet()) {
            if (e.getValue() == null || ((RegionPlan)e.getValue()).getDestination() == null || !((RegionPlan)e.getValue()).getDestination().equals(sn)) continue;
            RegionState rs = null;
            ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
            synchronized (concurrentSkipListMap) {
                rs = this.regionsInTransition.get(e.getKey());
            }
            if (rs == null) continue;
            rs.updateTimestampToNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regionOffline(HRegionInfo regionInfo) {
        this.clearRegionPlan(regionInfo);
        this.setOffline(regionInfo);
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            if (this.regionsInTransition.remove(regionInfo.getEncodedName()) != null) {
                this.regionsInTransition.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffline(HRegionInfo regionInfo) {
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            ServerName sn = (ServerName)this.regions.remove((Object)regionInfo);
            if (sn == null) {
                return;
            }
            Set serverRegions = (Set)this.servers.get(sn);
            if (!serverRegions.remove((Object)regionInfo)) {
                LOG.warn((Object)("No " + (Object)((Object)regionInfo) + " on " + sn));
            }
        }
    }

    public void offlineDisabledRegion(HRegionInfo regionInfo) {
        LOG.debug((Object)("Table being disabled so deleting ZK node and removing from regions in transition, skipping assignment of region " + regionInfo.getRegionNameAsString()));
        try {
            if (!ZKAssign.deleteClosedNode(this.watcher, regionInfo.getEncodedName())) {
                ZKAssign.deleteOfflineNode(this.watcher, regionInfo.getEncodedName());
            }
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.debug((Object)("Tried to delete closed node for " + (Object)((Object)regionInfo) + " but it " + "does not exist so just offlining"));
        }
        catch (KeeperException e) {
            this.master.abort("Error deleting CLOSED node in ZK", e);
        }
        this.regionOffline(regionInfo);
    }

    public void assign(HRegionInfo region, boolean setOfflineInZK) {
        this.assign(region, setOfflineInZK, false);
    }

    public void assign(HRegionInfo region, boolean setOfflineInZK, boolean forceNewPlan) {
        this.assign(region, setOfflineInZK, forceNewPlan, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(HRegionInfo region, boolean setOfflineInZK, boolean forceNewPlan, boolean hijack) {
        RegionState state;
        if (!hijack && this.isDisabledorDisablingRegionInRIT(region)) {
            return;
        }
        if (this.serverManager.isClusterShutdown()) {
            LOG.info((Object)("Cluster shutdown is set; skipping assign of " + region.getRegionNameAsString()));
            return;
        }
        if (AssignmentManager.isAssigningSplitParentRegion(region)) {
            return;
        }
        RegionState regionState = state = this.addToRegionsInTransition(region, hijack);
        synchronized (regionState) {
            this.assign(region, state, setOfflineInZK, forceNewPlan, hijack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assign(ServerName destination, List<HRegionInfo> regions) {
        block18: {
            if (regions.size() == 0) {
                return;
            }
            LOG.debug((Object)("Bulk assigning " + regions.size() + " region(s) to " + destination.toString()));
            ArrayList<RegionState> states = new ArrayList<RegionState>(regions.size());
            ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
            synchronized (concurrentSkipListMap) {
                for (HRegionInfo region : regions) {
                    states.add(this.forceRegionStateToOffline(region));
                }
            }
            HashMap<String, RegionPlan> plans = new HashMap<String, RegionPlan>();
            for (HRegionInfo region : regions) {
                plans.put(region.getEncodedName(), new RegionPlan(region, null, destination));
            }
            this.addPlans(plans);
            AtomicInteger counter = new AtomicInteger(0);
            CreateUnassignedAsyncCallback cb = new CreateUnassignedAsyncCallback(this.watcher, destination, counter);
            for (RegionState state : states) {
                if (this.asyncSetOfflineInZooKeeper(state, cb, state)) continue;
                return;
            }
            int total = regions.size();
            int oldCounter = 0;
            while (true) {
                int count;
                if (oldCounter != (count = counter.get())) {
                    LOG.info((Object)(destination.toString() + " outstanding calls=" + count + " of total=" + total));
                    oldCounter = count;
                }
                if (count == total) break;
                Threads.sleep(1L);
            }
            if (cb.hasErrors()) {
                LOG.error((Object)"Error creating nodes for some of the regions we are trying to bulk assign");
                return;
            }
            try {
                long maxWaitTime = System.currentTimeMillis() + this.master.getConfiguration().getLong("hbase.regionserver.rpc.startup.waittime", 60000L);
                if (this.master.isStopped()) break block18;
                try {
                    this.serverManager.sendRegionOpen(destination, regions);
                }
                catch (RemoteException e) {
                    IOException decodedException = e.unwrapRemoteException();
                    if (decodedException instanceof RegionServerStoppedException) {
                        LOG.warn((Object)"The region server was shut down, ", (Throwable)decodedException);
                        return;
                    }
                    if (decodedException instanceof ServerNotRunningYetException) {
                        long now = System.currentTimeMillis();
                        if (now > maxWaitTime) {
                            throw e;
                        }
                        LOG.debug((Object)("Server is not yet up; waiting up to " + (maxWaitTime - now) + "ms"), (Throwable)e);
                        Thread.sleep(1000L);
                    }
                    throw decodedException;
                }
            }
            catch (IOException e) {
                LOG.info((Object)"Unable to communicate with the region server in order to assign regions", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        LOG.debug((Object)("Bulk assigning done for " + destination.toString()));
    }

    private RegionState addToRegionsInTransition(HRegionInfo region) {
        return this.addToRegionsInTransition(region, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionState addToRegionsInTransition(HRegionInfo region, boolean hijack) {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            return this.forceRegionStateToOffline(region, hijack);
        }
    }

    private RegionState forceRegionStateToOffline(HRegionInfo region) {
        return this.forceRegionStateToOffline(region, false);
    }

    private RegionState forceRegionStateToOffline(HRegionInfo region, boolean hijack) {
        String encodedName = region.getEncodedName();
        RegionState state = this.regionsInTransition.get(encodedName);
        if (state == null) {
            state = new RegionState(region, RegionState.State.OFFLINE);
            this.regionsInTransition.put(encodedName, state);
        } else if (!hijack) {
            LOG.debug((Object)("Forcing OFFLINE; was=" + state));
            state.update(RegionState.State.OFFLINE);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assign(HRegionInfo region, RegionState state, boolean setOfflineInZK, boolean forceNewPlan, boolean hijack) {
        boolean regionAlreadyInTransitionException = false;
        boolean serverNotRunningYet = false;
        boolean socketTimeoutException = false;
        long maxRegionServerStartupWaitTime = -1L;
        for (int i = 0; i < this.maximumAssignmentAttempts; ++i) {
            int versionOfOfflineNode = -1;
            if (setOfflineInZK && (versionOfOfflineNode = this.setOfflineInZooKeeper(state, hijack, regionAlreadyInTransitionException)) != -1) {
                if (this.isDisabledorDisablingRegionInRIT(region)) {
                    return;
                }
                String tableName = region.getTableNameAsString();
                if (!this.zkTable.isEnablingTable(tableName) && !this.zkTable.isEnabledTable(tableName)) {
                    LOG.debug((Object)("Setting table " + tableName + " to ENABLED state."));
                    this.setEnabledTable(region);
                }
            }
            if (setOfflineInZK && versionOfOfflineNode == -1) {
                return;
            }
            if (this.master.isStopped()) {
                LOG.debug((Object)("Server stopped; skipping assign of " + state));
                return;
            }
            RegionPlan plan = this.getRegionPlan(state, !regionAlreadyInTransitionException && !serverNotRunningYet && forceNewPlan);
            if (plan == null) {
                LOG.debug((Object)("Unable to determine a plan to assign " + state));
                this.timeoutMonitor.setAllRegionServersOffline(true);
                return;
            }
            try {
                LOG.debug((Object)("Assigning region " + state.getRegion().getRegionNameAsString() + " to " + plan.getDestination().toString()));
                long currentOfflineTimeStamp = state.getStamp();
                RegionOpeningState regionOpenState = this.serverManager.sendRegionOpen(plan.getDestination(), state.getRegion(), versionOfOfflineNode);
                if (regionOpenState == RegionOpeningState.OPENED) {
                    if (state.isOffline() && currentOfflineTimeStamp != state.getStamp()) {
                        return;
                    }
                    if (state.isOffline() && !state.isOpening()) {
                        state.update(RegionState.State.PENDING_OPEN, System.currentTimeMillis(), plan.getDestination());
                    }
                    if (state.isOpening()) {
                        return;
                    }
                    if (state.isOpened()) {
                        return;
                    }
                    break;
                }
                if (regionOpenState != RegionOpeningState.ALREADY_OPENED) break;
                LOG.debug((Object)("ALREADY_OPENED region " + state.getRegion().getRegionNameAsString() + " to " + plan.getDestination().toString()));
                String encodedRegionName = state.getRegion().getEncodedName();
                try {
                    ZKAssign.deleteOfflineNode(this.master.getZooKeeper(), encodedRegionName);
                }
                catch (KeeperException.NoNodeException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("The unassigned node " + encodedRegionName + " doesnot exist."));
                    }
                }
                catch (KeeperException e) {
                    this.master.abort("Error deleting OFFLINED node in ZK for transition ZK node (" + encodedRegionName + ")", e);
                }
                SortedMap<Object, Object> sortedMap = this.regionsInTransition;
                synchronized (sortedMap) {
                    this.regionsInTransition.remove(plan.getRegionInfo().getEncodedName());
                }
                sortedMap = this.regions;
                synchronized (sortedMap) {
                    this.regions.put(plan.getRegionInfo(), plan.getDestination());
                    this.addToServers(plan.getDestination(), plan.getRegionInfo());
                    break;
                }
            }
            catch (Throwable t2) {
                IOException t2;
                if (t2 instanceof RemoteException) {
                    t2 = ((RemoteException)t2).unwrapRemoteException();
                }
                regionAlreadyInTransitionException = false;
                serverNotRunningYet = false;
                socketTimeoutException = false;
                if (t2 instanceof RegionAlreadyInTransitionException) {
                    regionAlreadyInTransitionException = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Failed assignment in: " + plan.getDestination() + " due to " + t2.getMessage()));
                    }
                } else if (t2 instanceof ServerNotRunningYetException) {
                    if (maxRegionServerStartupWaitTime < 0L) {
                        maxRegionServerStartupWaitTime = System.currentTimeMillis() + this.master.getConfiguration().getLong("hbase.regionserver.rpc.startup.waittime", 60000L);
                    }
                    try {
                        long now = System.currentTimeMillis();
                        if (now < maxRegionServerStartupWaitTime) {
                            LOG.debug((Object)("Server is not yet up; waiting up to " + (maxRegionServerStartupWaitTime - now) + "ms"), (Throwable)t2);
                            serverNotRunningYet = true;
                            Thread.sleep(100L);
                            --i;
                        }
                        LOG.debug((Object)"Server is not up for a while; try a new one", (Throwable)t2);
                    }
                    catch (InterruptedException ie) {
                        LOG.warn((Object)("Failed to assign " + state.getRegion().getRegionNameAsString() + " since interrupted"), (Throwable)ie);
                        Thread.currentThread().interrupt();
                        return;
                    }
                } else if (t2 instanceof SocketTimeoutException && this.serverManager.isServerOnline(plan.getDestination())) {
                    LOG.warn((Object)("Call openRegion() to " + plan.getDestination() + " has timed out when trying to assign " + region.getRegionNameAsString() + ", but the region might already be opened on " + plan.getDestination() + "."), (Throwable)t2);
                    socketTimeoutException = true;
                    try {
                        Thread.sleep(100L);
                        --i;
                    }
                    catch (InterruptedException ie) {
                        LOG.warn((Object)("Failed to assign " + state.getRegion().getRegionNameAsString() + " since interrupted"), (Throwable)ie);
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                LOG.warn((Object)("Failed assignment of " + state.getRegion().getRegionNameAsString() + " to " + plan.getDestination() + ", trying to assign " + (regionAlreadyInTransitionException || serverNotRunningYet || socketTimeoutException ? "to the same region server because of RegionAlreadyInTransitionException/ServerNotRunningYetException/SocketTimeoutException;" : "elsewhere instead; ") + "retry=" + i), (Throwable)t2);
                state.update(RegionState.State.OFFLINE);
                RegionPlan newPlan = plan;
                if (!(regionAlreadyInTransitionException || serverNotRunningYet || socketTimeoutException)) {
                    newPlan = this.getRegionPlan(state, true);
                }
                if (newPlan != null) continue;
                this.timeoutMonitor.setAllRegionServersOffline(true);
                LOG.warn((Object)("Unable to find a viable location to assign region " + state.getRegion().getRegionNameAsString()));
                return;
            }
        }
    }

    private static boolean isAssigningSplitParentRegion(HRegionInfo region) {
        if (region.isSplitParent()) {
            LOG.info((Object)("Skipping assign of " + region.getRegionNameAsString() + ", already split, or still splitting"));
            return true;
        }
        return false;
    }

    private boolean isDisabledorDisablingRegionInRIT(HRegionInfo region) {
        String tableName = region.getTableNameAsString();
        boolean disabled = this.zkTable.isDisabledTable(tableName);
        if (disabled || this.zkTable.isDisablingTable(tableName)) {
            LOG.info((Object)("Table " + tableName + (disabled ? " disabled;" : " disabling;") + " skipping assign of " + region.getRegionNameAsString()));
            this.offlineDisabledRegion(region);
            return true;
        }
        return false;
    }

    int setOfflineInZooKeeper(RegionState state, boolean hijack, boolean regionAlreadyInTransitionException) {
        if (!(hijack || state.isClosed() || state.isOffline())) {
            if (!regionAlreadyInTransitionException) {
                LOG.warn((Object)("Unexpected state : " + state + " .. Cannot transit it to OFFLINE."));
                return -1;
            }
            LOG.debug((Object)("Unexpected state : " + state + " but retrying to assign because RegionAlreadyInTransitionException."));
        }
        boolean allowZNodeCreation = false;
        if (hijack && (state.getState().equals((Object)RegionState.State.PENDING_OPEN) || state.getState().equals((Object)RegionState.State.OPENING))) {
            state.update(RegionState.State.PENDING_OPEN);
            allowZNodeCreation = false;
        } else {
            state.update(RegionState.State.OFFLINE);
            allowZNodeCreation = true;
        }
        int versionOfOfflineNode = -1;
        try {
            versionOfOfflineNode = ZKAssign.createOrForceNodeOffline(this.master.getZooKeeper(), state.getRegion(), this.master.getServerName(), hijack, allowZNodeCreation);
            if (versionOfOfflineNode == -1) {
                LOG.warn((Object)("Attempted to create/force node into OFFLINE state before completing assignment but failed to do so for " + state));
                return -1;
            }
        }
        catch (KeeperException e) {
            this.master.abort("Unexpected ZK exception creating/setting node OFFLINE", e);
            return -1;
        }
        return versionOfOfflineNode;
    }

    boolean asyncSetOfflineInZooKeeper(RegionState state, AsyncCallback.StringCallback cb, Object ctx) {
        if (!state.isClosed() && !state.isOffline()) {
            new RuntimeException("Unexpected state trying to OFFLINE; " + state);
            this.master.abort("Unexpected state trying to OFFLINE; " + state, new IllegalStateException());
            return false;
        }
        state.update(RegionState.State.OFFLINE);
        try {
            ZKAssign.asyncCreateNodeOffline(this.master.getZooKeeper(), state.getRegion(), this.master.getServerName(), cb, ctx);
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NodeExistsException) {
                LOG.warn((Object)("Node for " + (Object)((Object)state.getRegion()) + " already exists"));
            } else {
                this.master.abort("Unexpected ZK exception creating/setting node OFFLINE", e);
            }
            return false;
        }
        return true;
    }

    RegionPlan getRegionPlan(RegionState state, boolean forceNewPlan) {
        return this.getRegionPlan(state, null, forceNewPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegionPlan getRegionPlan(RegionState state, ServerName serverToExclude, boolean forceNewPlan) {
        String encodedName = state.getRegion().getEncodedName();
        List<ServerName> servers = this.serverManager.getOnlineServersList();
        List<ServerName> drainingServers = this.serverManager.getDrainingServersList();
        if (serverToExclude != null) {
            servers.remove(serverToExclude);
        }
        if (!drainingServers.isEmpty()) {
            for (ServerName server : drainingServers) {
                LOG.debug((Object)("Removing draining server: " + server + " from eligible server pool."));
                servers.remove(server);
            }
        }
        this.removeDeadNotExpiredServers(servers);
        if (servers.isEmpty()) {
            return null;
        }
        RegionPlan randomPlan = null;
        boolean newPlan = false;
        RegionPlan existingPlan = null;
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            existingPlan = (RegionPlan)this.regionPlans.get(encodedName);
            if (existingPlan != null && existingPlan.getDestination() != null) {
                LOG.debug((Object)("Found an existing plan for " + state.getRegion().getRegionNameAsString() + " destination server is " + existingPlan.getDestination().toString()));
            }
            if (forceNewPlan || existingPlan == null || existingPlan.getDestination() == null || drainingServers.contains(existingPlan.getDestination())) {
                newPlan = true;
                randomPlan = new RegionPlan(state.getRegion(), null, this.balancer.randomAssignment(servers));
                this.regionPlans.put(encodedName, randomPlan);
            }
        }
        if (newPlan) {
            LOG.debug((Object)("No previous transition plan was found (or we are ignoring an existing plan) for " + state.getRegion().getRegionNameAsString() + " so generated a random one; " + randomPlan + "; " + this.serverManager.countOfRegionServers() + " (online=" + this.serverManager.getOnlineServers().size() + ", available=" + servers.size() + ") available servers"));
            return randomPlan;
        }
        LOG.debug((Object)("Using pre-existing plan for region " + state.getRegion().getRegionNameAsString() + "; plan=" + existingPlan));
        return existingPlan;
    }

    public void removeDeadNotExpiredServers(List<ServerName> servers) {
        Set<ServerName> deadNotExpiredServers = this.serverManager.getDeadNotExpiredServers();
        if (!deadNotExpiredServers.isEmpty()) {
            for (ServerName server : deadNotExpiredServers) {
                LOG.debug((Object)("Removing dead but not expired server: " + server + " from eligible server pool."));
                servers.remove(server);
            }
        }
    }

    public void unassign(List<HRegionInfo> regions) {
        int waitTime = this.master.getConfiguration().getInt("hbase.bulk.waitbetween.reopen", 0);
        for (HRegionInfo region : regions) {
            if (this.isRegionInTransition(region) != null) continue;
            this.unassign(region, false);
            while (this.isRegionInTransition(region) != null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            if (waitTime <= 0) continue;
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {}
        }
    }

    public void unassign(HRegionInfo region) {
        this.unassign(region, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassign(HRegionInfo region, boolean force) {
        RegionState state;
        LOG.debug((Object)("Starting unassignment of region " + region.getRegionNameAsString() + " (offlining)"));
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            if (!this.regions.containsKey((Object)region)) {
                LOG.debug((Object)("Attempted to unassign region " + region.getRegionNameAsString() + " but it is not " + "currently assigned anywhere"));
                return;
            }
        }
        String encodedName = region.getEncodedName();
        int versionOfClosingNode = -1;
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            state = this.regionsInTransition.get(encodedName);
            if (state == null) {
                try {
                    versionOfClosingNode = ZKAssign.createNodeClosing(this.master.getZooKeeper(), region, this.master.getServerName());
                    if (versionOfClosingNode == -1) {
                        LOG.debug((Object)("Attempting to unassign region " + region.getRegionNameAsString() + " but ZK closing node " + "can't be created."));
                        return;
                    }
                }
                catch (KeeperException e) {
                    if (e instanceof KeeperException.NodeExistsException) {
                        KeeperException.NodeExistsException nee = (KeeperException.NodeExistsException)e;
                        String path = nee.getPath();
                        try {
                            if (this.isSplitOrSplitting(path)) {
                                LOG.debug((Object)(path + " is SPLIT or SPLITTING; " + "skipping unassign because region no longer exists -- its split"));
                                return;
                            }
                        }
                        catch (KeeperException.NoNodeException ke) {
                            LOG.warn((Object)("Failed getData on SPLITTING/SPLIT at " + path + "; presuming split and that the region to unassign, " + encodedName + ", no longer exists -- confirm"), (Throwable)ke);
                            return;
                        }
                        catch (KeeperException ke) {
                            LOG.error((Object)"Unexpected zk state", (Throwable)ke);
                            ke = e;
                        }
                    }
                    this.master.abort("Unexpected ZK exception creating node CLOSING", e);
                    return;
                }
                state = new RegionState(region, RegionState.State.PENDING_CLOSE);
                this.regionsInTransition.put(encodedName, state);
            } else if (force && (state.isPendingClose() || state.isClosing())) {
                LOG.debug((Object)("Attempting to unassign region " + region.getRegionNameAsString() + " which is already " + (Object)((Object)state.getState()) + " but forcing to send a CLOSE RPC again "));
                state.update(state.getState());
            } else {
                LOG.debug((Object)("Attempting to unassign region " + region.getRegionNameAsString() + " but it is " + "already in transition (" + (Object)((Object)state.getState()) + ", force=" + force + ")"));
                return;
            }
        }
        ServerName server = null;
        SortedMap<HRegionInfo, ServerName> e = this.regions;
        synchronized (e) {
            server = (ServerName)this.regions.get((Object)region);
        }
        if (server == null) {
            e = this.regionsInTransition;
            synchronized (e) {
                RegionState.State presentState;
                state = this.regionsInTransition.get(encodedName);
                if (state != null && ((presentState = state.getState()) == RegionState.State.PENDING_CLOSE || presentState == RegionState.State.CLOSING)) {
                    this.regionsInTransition.remove(encodedName);
                }
            }
            this.deleteClosingOrClosedNode(region);
            return;
        }
        try {
            if (this.serverManager.sendRegionClose(server, state.getRegion(), versionOfClosingNode)) {
                LOG.debug((Object)("Sent CLOSE to " + server + " for region " + region.getRegionNameAsString()));
                return;
            }
            LOG.warn((Object)("Server " + server + " region CLOSE RPC returned false for " + region.getRegionNameAsString()));
        }
        catch (NotServingRegionException nsre) {
            LOG.info((Object)("Server " + server + " returned " + nsre + " for " + region.getRegionNameAsString()));
        }
        catch (Throwable t2) {
            IOException t2;
            if (t2 instanceof RemoteException) {
                t2 = ((RemoteException)t2).unwrapRemoteException();
                if (t2 instanceof NotServingRegionException && (this.checkIfRegionBelongsToDisabling(region) || this.checkIfRegionBelongsToDisabled(region))) {
                    LOG.info((Object)("While trying to recover the table " + region.getTableNameAsString() + " to DISABLED state the region " + (Object)((Object)region) + " was offlined but the table was in DISABLING state"));
                    SortedMap<Object, Object> sortedMap2 = this.regionsInTransition;
                    synchronized (sortedMap2) {
                        this.regionsInTransition.remove(region.getEncodedName());
                    }
                    sortedMap2 = this.regions;
                    synchronized (sortedMap2) {
                        Set serverRegions;
                        ServerName sn = (ServerName)this.regions.remove((Object)region);
                        if (!(sn == null || (serverRegions = (Set)this.servers.get(sn)) != null && serverRegions.remove((Object)region))) {
                            LOG.warn((Object)("No " + (Object)((Object)region) + " on " + sn));
                        }
                    }
                    this.deleteClosingOrClosedNode(region);
                }
                if (t2 instanceof RegionAlreadyInTransitionException) {
                    LOG.debug((Object)("update " + state + " the timestamp."));
                    state.update(state.getState());
                }
            }
            LOG.info((Object)("Server " + server + " returned " + t2 + " for " + region.getEncodedName()));
        }
    }

    public void deleteClosingOrClosedNode(HRegionInfo region) {
        try {
            boolean deleteNode;
            if (!ZKAssign.deleteNode(this.master.getZooKeeper(), region.getEncodedName(), EventHandler.EventType.M_ZK_REGION_CLOSING) && !(deleteNode = ZKAssign.deleteNode(this.master.getZooKeeper(), region.getEncodedName(), EventHandler.EventType.RS_ZK_REGION_CLOSED))) {
                LOG.error((Object)("The deletion of the CLOSED node for the region " + region.getEncodedName() + " returned " + deleteNode));
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)("CLOSING/CLOSED node for the region " + region.getEncodedName() + " already deleted"));
        }
        catch (KeeperException ke) {
            this.master.abort("Unexpected ZK exception deleting node CLOSING/CLOSED for the region " + region.getEncodedName(), ke);
            return;
        }
    }

    private boolean isSplitOrSplitting(String path) throws KeeperException {
        boolean result = false;
        RegionTransitionData data = ZKAssign.getData(this.master.getZooKeeper(), path);
        EventHandler.EventType evt = data.getEventType();
        switch (evt) {
            case RS_ZK_REGION_SPLITTING: 
            case RS_ZK_REGION_SPLIT: {
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAssignment(HRegionInfo regionInfo) throws InterruptedException {
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            while (!this.master.isStopped() && !this.regions.containsKey((Object)regionInfo)) {
                this.regions.wait(100L);
            }
        }
    }

    public void assignRoot() throws KeeperException {
        RootLocationEditor.deleteRootLocation(this.master.getZooKeeper());
        this.assign(HRegionInfo.ROOT_REGIONINFO, true);
    }

    public void assignMeta() {
        this.assign(HRegionInfo.FIRST_META_REGIONINFO, true);
    }

    public void assignUserRegionsToOnlineServers(List<HRegionInfo> regions) throws IOException, InterruptedException {
        List<ServerName> servers = this.serverManager.getOnlineServersList();
        this.removeDeadNotExpiredServers(servers);
        this.assignUserRegions(regions, servers);
    }

    public void assignUserRegions(List<HRegionInfo> regions, List<ServerName> servers) throws IOException, InterruptedException {
        if (regions == null) {
            return;
        }
        Map<ServerName, List<HRegionInfo>> bulkPlan = null;
        bulkPlan = this.balancer.roundRobinAssignment(regions, servers);
        LOG.info((Object)("Bulk assigning " + regions.size() + " region(s) round-robin across " + servers.size() + " server(s)"));
        StartupBulkAssigner ba = new StartupBulkAssigner(this.master, bulkPlan, this);
        ba.bulkAssign();
        LOG.info((Object)"Bulk assigning done");
    }

    private void setEnabledTable(HRegionInfo hri) {
        String tableName = hri.getTableNameAsString();
        boolean isTableEnabled2 = this.zkTable.isEnabledTable(tableName);
        if (!isTableEnabled2) {
            this.setEnabledTable(tableName);
        }
    }

    public void assignAllUserRegions() throws IOException, InterruptedException {
        HashSet<String> disablingDisabledAndEnablingTables = new HashSet<String>(this.disablingTables);
        disablingDisabledAndEnablingTables.addAll(this.zkTable.getDisabledTables());
        disablingDisabledAndEnablingTables.addAll(this.enablingTables.keySet());
        Map<HRegionInfo, ServerName> allRegions = MetaReader.fullScan(this.catalogTracker, disablingDisabledAndEnablingTables, true);
        if (allRegions == null || allRegions.isEmpty()) {
            return;
        }
        List<ServerName> servers = this.serverManager.getOnlineServersList();
        this.removeDeadNotExpiredServers(servers);
        if (servers.isEmpty()) {
            return;
        }
        boolean retainAssignment = this.master.getConfiguration().getBoolean("hbase.master.startup.retainassign", true);
        Map<ServerName, List<HRegionInfo>> bulkPlan = null;
        if (!retainAssignment) {
            this.assignUserRegions(new ArrayList<HRegionInfo>(allRegions.keySet()), servers);
            for (HRegionInfo hri : allRegions.keySet()) {
                this.setEnabledTable(hri);
            }
            return;
        }
        bulkPlan = this.balancer.retainAssignment(allRegions, servers);
        LOG.info((Object)("Bulk assigning " + allRegions.size() + " region(s) across " + servers.size() + " server(s), retainAssignment=" + retainAssignment));
        StartupBulkAssigner ba = new StartupBulkAssigner(this.master, bulkPlan, this);
        ba.bulkAssign();
        for (HRegionInfo hri : allRegions.keySet()) {
            this.setEnabledTable(hri);
        }
        LOG.info((Object)"Bulk assigning done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitUntilNoRegionsInTransition(long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long remaining = timeout;
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            while (this.regionsInTransition.size() > 0 && !this.master.isStopped() && remaining > 0L) {
                this.regionsInTransition.wait(remaining);
                remaining = timeout - (System.currentTimeMillis() - startTime);
            }
        }
        return this.regionsInTransition.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitUntilNoRegionsInTransition(long timeout, Set<HRegionInfo> regions) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long remaining = timeout;
        boolean stillInTransition = true;
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            while (this.regionsInTransition.size() > 0 && !this.master.isStopped() && remaining > 0L && stillInTransition) {
                int count = 0;
                for (RegionState rs : this.regionsInTransition.values()) {
                    if (!regions.contains((Object)rs.getRegion())) continue;
                    ++count;
                    break;
                }
                if (count == 0) {
                    stillInTransition = false;
                    break;
                }
                this.regionsInTransition.wait(remaining);
                remaining = timeout - (System.currentTimeMillis() - startTime);
            }
        }
        return stillInTransition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ServerName, List<Pair<HRegionInfo, Result>>> rebuildUserRegions() throws IOException, KeeperException {
        List<Result> results = MetaReader.fullScan(this.catalogTracker);
        Set<ServerName> onlineServers = this.serverManager.getOnlineServers().keySet();
        TreeMap<ServerName, List<Pair<HRegionInfo, Result>>> offlineServers = new TreeMap<ServerName, List<Pair<HRegionInfo, Result>>>();
        for (Result result : results) {
            Stat stat;
            String node;
            byte[] data;
            boolean disabled = false;
            boolean disablingOrEnabling = false;
            Pair<HRegionInfo, ServerName> region = MetaReader.parseCatalogResult(result);
            if (region == null) continue;
            HRegionInfo regionInfo = region.getFirst();
            ServerName regionLocation = region.getSecond();
            if (regionInfo == null) continue;
            String tableName = regionInfo.getTableNameAsString();
            if (regionLocation == null) {
                boolean enabling = this.checkIfRegionsBelongsToEnabling(regionInfo);
                this.addTheTablesInPartialState(regionInfo);
                if (enabling) {
                    this.addToEnablingTableRegions(regionInfo);
                    continue;
                }
                LOG.warn((Object)("Region " + regionInfo.getEncodedName() + " has null regionLocation." + " But its table " + tableName + " isn't in ENABLING state."));
                continue;
            }
            if (!onlineServers.contains(regionLocation)) {
                ArrayList<Pair<HRegionInfo, Result>> offlineRegions = (ArrayList<Pair<HRegionInfo, Result>>)offlineServers.get(regionLocation);
                if (offlineRegions == null) {
                    offlineRegions = new ArrayList<Pair<HRegionInfo, Result>>(1);
                    offlineServers.put(regionLocation, offlineRegions);
                }
                offlineRegions.add(new Pair<HRegionInfo, Result>(regionInfo, result));
                disabled = this.checkIfRegionBelongsToDisabled(regionInfo);
                disablingOrEnabling = this.addTheTablesInPartialState(regionInfo);
                this.enableTableIfNotDisabledOrDisablingOrEnabling(disabled, disablingOrEnabling, tableName);
                continue;
            }
            if (regionInfo.isOffline() && regionInfo.isSplit() && (data = ZKUtil.getDataNoWatch(this.watcher, node = ZKAssign.getNodeName(this.watcher, regionInfo.getEncodedName()), stat = new Stat())) == null) {
                LOG.debug((Object)("Region " + regionInfo.getRegionNameAsString() + " split is completed. " + "Hence need not add to regions list"));
                continue;
            }
            boolean enabling = this.checkIfRegionsBelongsToEnabling(regionInfo);
            disabled = this.checkIfRegionBelongsToDisabled(regionInfo);
            if (!enabling && !disabled) {
                SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
                synchronized (sortedMap) {
                    this.regions.put(regionInfo, regionLocation);
                    this.addToServers(regionLocation, regionInfo);
                }
            }
            disablingOrEnabling = this.addTheTablesInPartialState(regionInfo);
            if (enabling) {
                this.addToEnablingTableRegions(regionInfo);
            }
            this.enableTableIfNotDisabledOrDisablingOrEnabling(disabled, disablingOrEnabling, tableName);
        }
        return offlineServers;
    }

    private void addToEnablingTableRegions(HRegionInfo regionInfo) {
        String tableName = regionInfo.getTableNameAsString();
        List<HRegionInfo> hris = this.enablingTables.get(tableName);
        if (!hris.contains((Object)regionInfo)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding region" + regionInfo.getRegionNameAsString() + " to enabling table " + tableName + "."));
            }
            hris.add(regionInfo);
        }
    }

    private void enableTableIfNotDisabledOrDisablingOrEnabling(boolean disabled, boolean disablingOrEnabling, String tableName) {
        if (!(disabled || disablingOrEnabling || this.getZKTable().isEnabledTable(tableName))) {
            this.setEnabledTable(tableName);
        }
    }

    private Boolean addTheTablesInPartialState(HRegionInfo regionInfo) {
        String tableName = regionInfo.getTableNameAsString();
        if (this.checkIfRegionBelongsToDisabling(regionInfo)) {
            this.disablingTables.add(tableName);
            return true;
        }
        if (this.checkIfRegionsBelongsToEnabling(regionInfo)) {
            if (!this.enablingTables.containsKey(tableName)) {
                this.enablingTables.put(tableName, new ArrayList());
            }
            return true;
        }
        return false;
    }

    private boolean recoverTableInDisablingState(Set<String> disablingTables) throws KeeperException, TableNotFoundException, IOException {
        boolean isWatcherCreated = false;
        if (disablingTables.size() != 0) {
            ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.assignmentZNode);
            isWatcherCreated = true;
            for (String tableName : disablingTables) {
                LOG.info((Object)("The table " + tableName + " is in DISABLING state.  Hence recovering by moving the table" + " to DISABLED state."));
                new DisableTableHandler(this.master, tableName.getBytes(), this.catalogTracker, this, true).process();
            }
        }
        return isWatcherCreated;
    }

    private void recoverTableInEnablingState(Set<String> enablingTables, boolean isWatcherCreated) throws KeeperException, TableNotFoundException, IOException {
        if (enablingTables.size() != 0) {
            if (!isWatcherCreated) {
                ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.assignmentZNode);
            }
            for (String tableName : enablingTables) {
                LOG.info((Object)("The table " + tableName + " is in ENABLING state.  Hence recovering by moving the table" + " to ENABLED state."));
                EnableTableHandler eth = null;
                try {
                    eth = new EnableTableHandler(this.master, tableName.getBytes(), this.catalogTracker, this, true);
                }
                catch (TableNotFoundException e) {
                    LOG.warn((Object)("Table " + tableName + " not found in .META. to recover."));
                    continue;
                }
                if (eth == null) continue;
                eth.process();
            }
        }
    }

    private boolean checkIfRegionsBelongsToEnabling(HRegionInfo regionInfo) {
        String tableName = regionInfo.getTableNameAsString();
        return this.getZKTable().isEnablingTable(tableName);
    }

    private boolean checkIfRegionBelongsToDisabled(HRegionInfo regionInfo) {
        String tableName = regionInfo.getTableNameAsString();
        return this.getZKTable().isDisabledTable(tableName);
    }

    private boolean checkIfRegionBelongsToDisabling(HRegionInfo regionInfo) {
        String tableName = regionInfo.getTableNameAsString();
        return this.getZKTable().isDisablingTable(tableName);
    }

    private void processDeadServersAndRecoverLostRegions(Map<ServerName, List<Pair<HRegionInfo, Result>>> deadServers, List<String> nodes) throws IOException, KeeperException {
        if (null != deadServers) {
            Set<ServerName> actualDeadServers = this.serverManager.getDeadServers();
            for (Map.Entry<ServerName, List<Pair<HRegionInfo, Result>>> deadServer : deadServers.entrySet()) {
                if (actualDeadServers.contains(deadServer.getKey())) {
                    for (Pair<HRegionInfo, Result> deadRegion : deadServer.getValue()) {
                        HRegionInfo hri = deadRegion.getFirst();
                        this.deleteNodeAndOfflineRegion(hri);
                        nodes.remove(deadRegion.getFirst().getEncodedName());
                    }
                    continue;
                }
                List<Pair<HRegionInfo, Result>> regions = deadServer.getValue();
                for (Pair<HRegionInfo, Result> region : regions) {
                    HRegionInfo regionInfo = region.getFirst();
                    Result result = region.getSecond();
                    try {
                        RegionTransitionData data = ZKAssign.getData(this.watcher, regionInfo.getEncodedName());
                        if (data != null && data.getOrigin() != null && this.serverManager.isServerOnline(data.getOrigin())) {
                            LOG.info((Object)("The region " + regionInfo.getEncodedName() + "is being handled on " + data.getOrigin()));
                            continue;
                        }
                        boolean assign = ServerShutdownHandler.processDeadRegion(regionInfo, result, this, this.catalogTracker);
                        if (!assign) continue;
                        ZKAssign.createOrForceNodeOffline(this.watcher, regionInfo, this.master.getServerName());
                        if (nodes.contains(regionInfo.getEncodedName())) continue;
                        nodes.add(regionInfo.getEncodedName());
                    }
                    catch (KeeperException.NoNodeException nne) {}
                }
            }
        }
        if (!nodes.isEmpty()) {
            for (String encodedRegionName : nodes) {
                this.processRegionInTransition(encodedRegionName, null, deadServers);
            }
        }
    }

    public void deleteNodeAndOfflineRegion(HRegionInfo hri) {
        if (this.zkTable.isDisablingOrDisabledTable(hri.getTableNameAsString())) {
            try {
                ZKAssign.deleteNodeFailSilent(this.master.getZooKeeper(), hri);
            }
            catch (KeeperException ke) {
                this.master.abort("Unexpected ZK exception deleting unassigned node " + (Object)((Object)hri), ke);
            }
            this.regionOffline(hri);
        }
    }

    private void addToServers(ServerName sn, HRegionInfo hri) {
        ConcurrentSkipListSet<HRegionInfo> hris = (ConcurrentSkipListSet<HRegionInfo>)this.servers.get(sn);
        if (hris == null) {
            hris = new ConcurrentSkipListSet<HRegionInfo>();
            this.servers.put(sn, hris);
        }
        if (!hris.contains((Object)hri)) {
            hris.add(hri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<String, RegionState> getRegionsInTransition() {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            return new TreeMap<String, RegionState>((SortedMap<String, RegionState>)this.regionsInTransition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegionsInTransition() {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            return !this.regionsInTransition.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionState isRegionInTransition(HRegionInfo hri) {
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            return this.regionsInTransition.get(hri.getEncodedName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegionFromTransition(HRegionInfo hri) {
        SortedMap<Object, Object> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            this.regionsInTransition.remove(hri.getEncodedName());
        }
        sortedMap = this.regions;
        synchronized (sortedMap) {
            this.regions.remove((Object)hri);
            for (Set regions : this.servers.values()) {
                regions.remove((Object)hri);
            }
        }
        this.clearRegionPlan(hri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRegionPlan(HRegionInfo region) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.remove(region.getEncodedName());
        }
    }

    public void waitOnRegionToClearRegionsInTransition(HRegionInfo hri) throws IOException {
        if (this.isRegionInTransition(hri) == null) {
            return;
        }
        RegionState rs = null;
        while (!this.master.isStopped() && (rs = this.isRegionInTransition(hri)) != null) {
            Threads.sleep(1000L);
            LOG.info((Object)("Waiting on " + rs + " to clear regions-in-transition"));
        }
        if (this.master.isStopped()) {
            LOG.info((Object)"Giving up wait on regions in transition because stoppable.isStopped is set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> getRegionsOfTable(byte[] tableName) {
        ArrayList<HRegionInfo> tableRegions = new ArrayList<HRegionInfo>();
        HRegionInfo boundary = new HRegionInfo(tableName, null, null, false, 0L);
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            for (HRegionInfo regionInfo : this.regions.tailMap(boundary).keySet()) {
                if (!Bytes.equals(regionInfo.getTableName(), tableName)) break;
                tableRegions.add(regionInfo);
            }
        }
        return tableRegions;
    }

    private void processOpeningState(HRegionInfo regionInfo) {
        LOG.info((Object)("Region has been OPENING for too long, reassigning region=" + regionInfo.getRegionNameAsString()));
        try {
            String node = ZKAssign.getNodeName(this.watcher, regionInfo.getEncodedName());
            Stat stat = new Stat();
            RegionTransitionData dataInZNode = ZKAssign.getDataNoWatch(this.watcher, node, stat);
            if (dataInZNode == null) {
                LOG.warn((Object)("Data is null, node " + node + " no longer exists"));
                return;
            }
            if (dataInZNode.getEventType() == EventHandler.EventType.RS_ZK_REGION_OPENED) {
                LOG.debug((Object)"Region has transitioned to OPENED, allowing watched event handlers to process");
                return;
            }
            if (dataInZNode.getEventType() != EventHandler.EventType.RS_ZK_REGION_OPENING && dataInZNode.getEventType() != EventHandler.EventType.RS_ZK_REGION_FAILED_OPEN) {
                LOG.warn((Object)("While timing out a region in state OPENING, found ZK node in unexpected state: " + (Object)((Object)dataInZNode.getEventType())));
                return;
            }
            this.invokeAssign(regionInfo);
        }
        catch (KeeperException ke) {
            LOG.error((Object)"Unexpected ZK exception timing out CLOSING region", (Throwable)ke);
            return;
        }
    }

    private void invokeAssign(HRegionInfo regionInfo) {
        this.threadPoolExecutorService.submit(new AssignCallable(this, regionInfo));
    }

    private void invokeUnassign(HRegionInfo regionInfo) {
        this.threadPoolExecutorService.submit(new UnAssignCallable(this, regionInfo));
    }

    public boolean isCarryingRoot(ServerName serverName) {
        return this.isCarryingRegion(serverName, HRegionInfo.ROOT_REGIONINFO);
    }

    public boolean isCarryingMeta(ServerName serverName) {
        return this.isCarryingRegion(serverName, HRegionInfo.FIRST_META_REGIONINFO);
    }

    public boolean isCarryingRegion(ServerName serverName, HRegionInfo hri) {
        ServerName addressFromZK;
        RegionTransitionData data = null;
        try {
            data = ZKAssign.getData(this.master.getZooKeeper(), hri.getEncodedName());
        }
        catch (KeeperException e) {
            this.master.abort("Unexpected ZK exception reading unassigned node for region=" + hri.getEncodedName(), e);
        }
        ServerName serverName2 = addressFromZK = data != null && data.getOrigin() != null ? data.getOrigin() : null;
        if (addressFromZK != null) {
            boolean matchZK = addressFromZK != null && addressFromZK.equals(serverName);
            LOG.debug((Object)("based on ZK, current region=" + hri.getRegionNameAsString() + " is on server=" + addressFromZK + " server being checked=: " + serverName));
            return matchZK;
        }
        ServerName addressFromAM = this.getRegionServerOfRegion(hri);
        boolean matchAM = addressFromAM != null && addressFromAM.equals(serverName);
        LOG.debug((Object)("based on AM, current region=" + hri.getRegionNameAsString() + " is on server=" + (addressFromAM != null ? addressFromAM : "null") + " server being checked: " + serverName));
        return matchAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Set<HRegionInfo>, List<RegionState>> processServerShutdown(ServerName sn) {
        Object i;
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            i = this.regionPlans.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                ServerName otherSn = ((RegionPlan)e.getValue()).getDestination();
                if (otherSn == null || !otherSn.equals(sn)) continue;
                i.remove();
            }
        }
        TreeSet deadRegions = new TreeSet();
        i = this.regions;
        synchronized (i) {
            Set assignedRegions = (Set)this.servers.remove(sn);
            if (assignedRegions != null && !assignedRegions.isEmpty()) {
                deadRegions.addAll(assignedRegions);
                for (HRegionInfo region : deadRegions) {
                    this.regions.remove((Object)region);
                }
            }
        }
        ConcurrentSkipListSet<HRegionInfo> ritsGoingToServer = new ConcurrentSkipListSet<HRegionInfo>();
        ArrayList<RegionState> ritsOnServer = new ArrayList<RegionState>();
        ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = this.regionsInTransition;
        synchronized (concurrentSkipListMap) {
            for (RegionState state : this.regionsInTransition.values()) {
                if (state.getServerName() != null && state.getServerName().equals(sn)) {
                    ritsGoingToServer.add(state.getRegion());
                }
                if (!deadRegions.contains((Object)state.getRegion())) continue;
                ritsOnServer.add(state);
            }
        }
        return new Pair<Set<HRegionInfo>, List<RegionState>>(ritsGoingToServer, ritsOnServer);
    }

    public void handleSplitReport(ServerName sn, HRegionInfo parent, HRegionInfo a, HRegionInfo b) {
        this.regionOffline(parent);
        this.regionOnline(a, sn);
        this.regionOnline(b, sn);
        if (this.zkTable.isDisablingOrDisabledTable(parent.getTableNameAsString())) {
            this.unassign(a);
            this.unassign(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Map<ServerName, List<HRegionInfo>>> getAssignmentsByTable() {
        HashMap<String, Map<ServerName, List<HRegionInfo>>> result = null;
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            result = new HashMap<String, Map<ServerName, List<HRegionInfo>>>();
            if (!this.master.getConfiguration().getBoolean("hbase.master.loadbalance.bytable", true)) {
                result.put("ensemble", this.getAssignments());
            } else {
                for (Map.Entry e : this.servers.entrySet()) {
                    for (HRegionInfo hri : (Set)e.getValue()) {
                        if (hri.isMetaRegion() || hri.isRootRegion()) continue;
                        String tablename = hri.getTableNameAsString();
                        HashMap svrToRegions = (HashMap)result.get(tablename);
                        if (svrToRegions == null) {
                            svrToRegions = new HashMap(this.servers.size());
                            result.put(tablename, svrToRegions);
                        }
                        List<HRegionInfo> regions = null;
                        if (!svrToRegions.containsKey(e.getKey())) {
                            regions = new ArrayList();
                            svrToRegions.put(e.getKey(), regions);
                        } else {
                            regions = (List)svrToRegions.get(e.getKey());
                        }
                        regions.add(hri);
                    }
                }
            }
        }
        Map<ServerName, HServerLoad> onlineSvrs = this.serverManager.getOnlineServers();
        List<ServerName> drainingServers = this.serverManager.getDrainingServersList();
        for (Map map : result.values()) {
            for (Map.Entry<ServerName, HServerLoad> svrEntry : onlineSvrs.entrySet()) {
                if (map.containsKey(svrEntry.getKey())) continue;
                map.put(svrEntry.getKey(), new ArrayList());
            }
            map.keySet().removeAll(drainingServers);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ServerName, List<HRegionInfo>> getAssignments() {
        HashMap<ServerName, List<HRegionInfo>> result = null;
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            result = new HashMap<ServerName, List<HRegionInfo>>(this.servers.size());
            for (Map.Entry e : this.servers.entrySet()) {
                result.put((ServerName)e.getKey(), new ArrayList((Collection)e.getValue()));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<HRegionInfo, ServerName> getAssignment(byte[] encodedRegionName) {
        String name = Bytes.toString(encodedRegionName);
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            for (Map.Entry<HRegionInfo, ServerName> e : this.regions.entrySet()) {
                if (!e.getKey().getEncodedName().equals(name)) continue;
                return new Pair<HRegionInfo, ServerName>(e.getKey(), e.getValue());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void balance(RegionPlan plan) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.put(plan.getRegionName(), plan);
        }
        this.unassign(plan.getRegionInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unassignCatalogRegions() {
        SortedMap<HRegionInfo, ServerName> sortedMap = this.regions;
        synchronized (sortedMap) {
            for (Map.Entry e : this.servers.entrySet()) {
                Set regions = (Set)e.getValue();
                if (regions == null || regions.isEmpty()) continue;
                for (HRegionInfo hri : regions) {
                    if (!hri.isMetaRegion()) continue;
                    this.unassign(hri);
                }
            }
        }
    }

    public void stop() {
        this.shutdown();
        this.timeoutMonitor.interrupt();
        this.timerUpdater.interrupt();
    }

    public boolean isServerOnline(ServerName serverName) {
        return this.serverManager.isServerOnline(serverName);
    }

    public void shutdown() {
        if (null != this.threadPoolExecutorService) {
            this.threadPoolExecutorService.shutdown();
        }
    }

    protected void setEnabledTable(String tableName) {
        try {
            this.zkTable.setEnabledTable(tableName);
        }
        catch (KeeperException e) {
            String errorMsg = "Unable to ensure that the table " + tableName + " will be" + " enabled because of a ZooKeeper issue";
            LOG.error((Object)errorMsg);
            this.master.abort(errorMsg, e);
        }
    }

    public static class RegionState
    implements Writable {
        private HRegionInfo region;
        private State state;
        private final AtomicLong stamp;
        private ServerName serverName;

        public RegionState() {
            this.stamp = new AtomicLong(System.currentTimeMillis());
        }

        RegionState(HRegionInfo region, State state) {
            this(region, state, System.currentTimeMillis(), null);
        }

        RegionState(HRegionInfo region, State state, long stamp, ServerName serverName) {
            this.region = region;
            this.state = state;
            this.stamp = new AtomicLong(stamp);
            this.serverName = serverName;
        }

        public void update(State state, long stamp, ServerName serverName) {
            this.state = state;
            this.updateTimestamp(stamp);
            this.serverName = serverName;
        }

        public void update(State state) {
            this.state = state;
            this.updateTimestampToNow();
            this.serverName = null;
        }

        public void updateTimestamp(long stamp) {
            this.stamp.set(stamp);
        }

        public void updateTimestampToNow() {
            this.stamp.set(System.currentTimeMillis());
        }

        public State getState() {
            return this.state;
        }

        public long getStamp() {
            return this.stamp.get();
        }

        public HRegionInfo getRegion() {
            return this.region;
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public boolean isClosing() {
            return this.state == State.CLOSING;
        }

        public boolean isClosed() {
            return this.state == State.CLOSED;
        }

        public boolean isPendingClose() {
            return this.state == State.PENDING_CLOSE;
        }

        public boolean isOpening() {
            return this.state == State.OPENING;
        }

        public boolean isOpened() {
            return this.state == State.OPEN;
        }

        public boolean isPendingOpen() {
            return this.state == State.PENDING_OPEN;
        }

        public boolean isOffline() {
            return this.state == State.OFFLINE;
        }

        public boolean isSplitting() {
            return this.state == State.SPLITTING;
        }

        public boolean isSplit() {
            return this.state == State.SPLIT;
        }

        public String toString() {
            return this.region.getRegionNameAsString() + " state=" + (Object)((Object)this.state) + ", ts=" + this.stamp + ", server=" + this.serverName;
        }

        public String toDescriptiveString() {
            long lstamp = this.stamp.get();
            long relTime = System.currentTimeMillis() - lstamp;
            return this.region.getRegionNameAsString() + " state=" + (Object)((Object)this.state) + ", ts=" + new Date(lstamp) + " (" + relTime / 1000L + "s ago)" + ", server=" + this.serverName;
        }

        public void readFields(DataInput in) throws IOException {
            this.region = new HRegionInfo();
            this.region.readFields(in);
            this.state = State.valueOf(in.readUTF());
            this.stamp.set(in.readLong());
        }

        public void write(DataOutput out) throws IOException {
            this.region.write(out);
            out.writeUTF(this.state.name());
            out.writeLong(this.stamp.get());
        }

        public static enum State {
            OFFLINE,
            PENDING_OPEN,
            OPENING,
            OPEN,
            PENDING_CLOSE,
            CLOSING,
            CLOSED,
            SPLITTING,
            SPLIT;

        }
    }

    public class TimeoutMonitor
    extends Chore {
        private final int timeout;
        private boolean bulkAssign;
        private boolean allRegionServersOffline;
        private ServerManager serverManager;

        public TimeoutMonitor(int period, Stoppable stopper, ServerManager serverManager, int timeout) {
            super("AssignmentTimeoutMonitor", period, stopper);
            this.bulkAssign = false;
            this.allRegionServersOffline = false;
            this.timeout = timeout;
            this.serverManager = serverManager;
        }

        public boolean bulkAssign(boolean bulkAssign) {
            boolean result = this.bulkAssign;
            this.bulkAssign = bulkAssign;
            return result;
        }

        private synchronized void setAllRegionServersOffline(boolean allRegionServersOffline) {
            this.allRegionServersOffline = allRegionServersOffline;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void chore() {
            if (this.bulkAssign) {
                return;
            }
            boolean allRSsOffline = this.serverManager.getOnlineServersList().isEmpty();
            ConcurrentSkipListMap<String, RegionState> concurrentSkipListMap = AssignmentManager.this.regionsInTransition;
            synchronized (concurrentSkipListMap) {
                long now = System.currentTimeMillis();
                for (RegionState regionState : AssignmentManager.this.regionsInTransition.values()) {
                    RegionPlan existingPlan;
                    if (regionState.getStamp() + (long)this.timeout <= now) {
                        this.actOnTimeOut(regionState);
                        continue;
                    }
                    if (!this.allRegionServersOffline || allRSsOffline || (existingPlan = (RegionPlan)AssignmentManager.this.regionPlans.get(regionState.getRegion().getEncodedName())) != null && this.serverManager.isServerOnline(existingPlan.getDestination())) continue;
                    this.actOnTimeOut(regionState);
                }
            }
            this.setAllRegionServersOffline(allRSsOffline);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void actOnTimeOut(RegionState regionState) {
            HRegionInfo regionInfo = regionState.getRegion();
            LOG.info((Object)("Regions in transition timed out:  " + regionState));
            switch (regionState.getState()) {
                case CLOSED: {
                    LOG.info((Object)("Region " + regionInfo.getEncodedName() + " has been CLOSED for too long, waiting on queued " + "ClosedRegionHandler to run or server shutdown"));
                    regionState.updateTimestampToNow();
                    break;
                }
                case OFFLINE: {
                    LOG.info((Object)("Region has been OFFLINE for too long, reassigning " + regionInfo.getRegionNameAsString() + " to a random server"));
                    AssignmentManager.this.invokeAssign(regionInfo);
                    break;
                }
                case PENDING_OPEN: {
                    LOG.info((Object)("Region has been PENDING_OPEN for too long, reassigning region=" + regionInfo.getRegionNameAsString()));
                    AssignmentManager.this.invokeAssign(regionInfo);
                    break;
                }
                case OPENING: {
                    AssignmentManager.this.processOpeningState(regionInfo);
                    break;
                }
                case OPEN: {
                    LOG.error((Object)"Region has been OPEN for too long, we don't know where region was opened so can't do anything");
                    RegionState regionState2 = regionState;
                    synchronized (regionState2) {
                        regionState.updateTimestampToNow();
                        break;
                    }
                }
                case PENDING_CLOSE: {
                    LOG.info((Object)("Region has been PENDING_CLOSE for too long, running forced unassign again on region=" + regionInfo.getRegionNameAsString()));
                    AssignmentManager.this.invokeUnassign(regionInfo);
                    break;
                }
                case CLOSING: {
                    LOG.info((Object)"Region has been CLOSING for too long, this should eventually complete or the server will expire, send RPC again");
                    AssignmentManager.this.invokeUnassign(regionInfo);
                }
            }
        }
    }

    public class TimerUpdater
    extends Chore {
        public TimerUpdater(int period, Stoppable stopper) {
            super("AssignmentTimerUpdater", period, stopper);
        }

        @Override
        protected void chore() {
            ServerName serverToUpdateTimer = null;
            while (!AssignmentManager.this.serversInUpdatingTimer.isEmpty() && !this.stopper.isStopped() && (serverToUpdateTimer = serverToUpdateTimer == null ? (ServerName)AssignmentManager.this.serversInUpdatingTimer.first() : (ServerName)AssignmentManager.this.serversInUpdatingTimer.higher(serverToUpdateTimer)) != null) {
                AssignmentManager.this.updateTimers(serverToUpdateTimer);
                AssignmentManager.this.serversInUpdatingTimer.remove(serverToUpdateTimer);
            }
        }
    }

    static class SingleServerBulkAssigner
    implements Runnable {
        private final ServerName regionserver;
        private final List<HRegionInfo> regions;
        private final AssignmentManager assignmentManager;

        SingleServerBulkAssigner(ServerName regionserver, List<HRegionInfo> regions, AssignmentManager am) {
            Iterator<HRegionInfo> it = regions.iterator();
            while (it.hasNext()) {
                if (!AssignmentManager.isAssigningSplitParentRegion(it.next())) continue;
                it.remove();
            }
            this.regionserver = regionserver;
            this.regions = regions;
            this.assignmentManager = am;
        }

        @Override
        public void run() {
            this.assignmentManager.assign(this.regionserver, this.regions);
        }
    }

    static class StartupBulkAssigner
    extends BulkAssigner {
        final Map<ServerName, List<HRegionInfo>> bulkPlan;
        final AssignmentManager assignmentManager;

        StartupBulkAssigner(Server server, Map<ServerName, List<HRegionInfo>> bulkPlan, AssignmentManager am) {
            super(server);
            this.bulkPlan = bulkPlan;
            this.assignmentManager = am;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean bulkAssign(boolean sync) throws InterruptedException, IOException {
            this.assignmentManager.timeoutMonitor.bulkAssign(true);
            try {
                boolean bl = super.bulkAssign(sync);
                return bl;
            }
            finally {
                this.assignmentManager.timeoutMonitor.bulkAssign(false);
            }
        }

        @Override
        protected String getThreadNamePrefix() {
            return this.server.getServerName() + "-StartupBulkAssigner";
        }

        @Override
        protected void populatePool(ExecutorService pool) {
            for (Map.Entry<ServerName, List<HRegionInfo>> e : this.bulkPlan.entrySet()) {
                pool.execute(new SingleServerBulkAssigner(e.getKey(), e.getValue(), this.assignmentManager));
            }
        }

        @Override
        protected boolean waitUntilDone(long timeout) throws InterruptedException {
            HashSet<HRegionInfo> regionSet = new HashSet<HRegionInfo>();
            for (List<HRegionInfo> regionList : this.bulkPlan.values()) {
                regionSet.addAll(regionList);
            }
            return this.assignmentManager.waitUntilNoRegionsInTransition(timeout, regionSet);
        }

        @Override
        protected long getTimeoutOnRIT() {
            long perRegionOpenTimeGuesstimate = this.server.getConfiguration().getLong("hbase.bulk.assignment.perregion.open.time", 1000L);
            int regionsPerServer = this.bulkPlan.entrySet().iterator().next().getValue().size();
            long timeout = perRegionOpenTimeGuesstimate * (long)regionsPerServer;
            LOG.debug((Object)("Timeout-on-RIT=" + timeout));
            return timeout;
        }
    }

    static class ExistsUnassignedAsyncCallback
    implements AsyncCallback.StatCallback {
        private final Log LOG = LogFactory.getLog(ExistsUnassignedAsyncCallback.class);
        private ServerName destination;
        private CreateUnassignedAsyncCallback parent;

        ExistsUnassignedAsyncCallback(CreateUnassignedAsyncCallback parent, ServerName destination) {
            this.parent = parent;
            this.destination = destination;
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc != 0) {
                this.LOG.warn((Object)("rc != 0 for " + path + " -- some error, may be connection loss -- " + "FIX see http://wiki.apache.org/hadoop/ZooKeeper/FAQ#A2"));
                this.parent.reportCompletion(false);
                return;
            }
            RegionState state = (RegionState)ctx;
            this.LOG.debug((Object)("rs=" + state));
            state.update(RegionState.State.PENDING_OPEN, System.currentTimeMillis(), this.destination);
            this.parent.reportCompletion(true);
        }
    }

    static class CreateUnassignedAsyncCallback
    implements AsyncCallback.StringCallback {
        private final Log LOG = LogFactory.getLog(CreateUnassignedAsyncCallback.class);
        private final ZooKeeperWatcher zkw;
        private final ServerName destination;
        private final AtomicInteger counter;
        private final AtomicInteger errorCount = new AtomicInteger(0);

        CreateUnassignedAsyncCallback(ZooKeeperWatcher zkw, ServerName destination, AtomicInteger counter) {
            this.zkw = zkw;
            this.destination = destination;
            this.counter = counter;
        }

        boolean hasErrors() {
            return this.errorCount.get() > 0;
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            if (rc == KeeperException.Code.NODEEXISTS.intValue()) {
                this.LOG.warn((Object)("Node for " + path + " already exists"));
                this.reportCompletion(false);
                return;
            }
            if (rc != 0) {
                this.LOG.warn((Object)("rc != 0 for " + path + " -- some error, may be retryable connection loss -- " + "FIX see http://wiki.apache.org/hadoop/ZooKeeper/FAQ#A2"));
                this.zkw.abort("Some error, may be connection loss writing unassigned at " + path + ", rc=" + rc, null);
                return;
            }
            this.LOG.debug((Object)("rs=" + (RegionState)ctx + ", server=" + this.destination.toString()));
            this.zkw.getRecoverableZooKeeper().getZooKeeper().exists(path, (Watcher)this.zkw, (AsyncCallback.StatCallback)new ExistsUnassignedAsyncCallback(this, this.destination), ctx);
        }

        void reportCompletion(boolean success) {
            if (!success) {
                this.errorCount.incrementAndGet();
            }
            this.counter.incrementAndGet();
        }
    }
}

