/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class MultiTableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    final Log LOG = LogFactory.getLog(MultiTableInputFormatBase.class);
    private List<Scan> scans;
    private TableRecordReader tableRecordReader = null;

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TableSplit tSplit = (TableSplit)split;
        if (tSplit.getTableName() == null) {
            throw new IOException("Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.");
        }
        HTable table = new HTable(context.getConfiguration(), tSplit.getTableName());
        TableRecordReader trr = this.tableRecordReader;
        if (trr == null) {
            trr = new TableRecordReader();
        }
        Scan sc = tSplit.getScan();
        sc.setStartRow(tSplit.getStartRow());
        sc.setStopRow(tSplit.getEndRow());
        trr.setScan(sc);
        trr.setHTable(table);
        trr.initialize(split, context);
        return trr;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        ArrayList<Scan> scanList;
        String tableNameStr;
        if (this.scans.isEmpty()) {
            throw new IOException("No scans were provided.");
        }
        HashMap<String, ArrayList<Scan>> tableMaps = new HashMap<String, ArrayList<Scan>>();
        for (Scan scan : this.scans) {
            byte[] tableName = scan.getAttribute("scan.attributes.table.name");
            if (tableName == null) {
                throw new IOException("A scan object did not have a table name");
            }
            tableNameStr = Bytes.toString(tableName);
            scanList = (ArrayList<Scan>)tableMaps.get(tableNameStr);
            if (scanList == null) {
                scanList = new ArrayList<Scan>();
                tableMaps.put(tableNameStr, scanList);
            }
            scanList.add(scan);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (Map.Entry entry : tableMaps.entrySet()) {
            tableNameStr = (String)entry.getKey();
            scanList = (List)entry.getValue();
            HTable table = new HTable(context.getConfiguration(), tableNameStr);
            Pair<byte[][], byte[][]> keys = table.getStartEndKeys();
            for (Scan scan : scanList) {
                if (keys == null || keys.getFirst() == null || keys.getFirst().length == 0) {
                    throw new IOException("Expecting at least one region for table : " + tableNameStr);
                }
                int count = 0;
                byte[] startRow = scan.getStartRow();
                byte[] stopRow = scan.getStopRow();
                for (int i = 0; i < keys.getFirst().length; ++i) {
                    if (!this.includeRegionInSplit(keys.getFirst()[i], keys.getSecond()[i]) || startRow.length != 0 && keys.getSecond()[i].length != 0 && Bytes.compareTo(startRow, keys.getSecond()[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo(stopRow, keys.getFirst()[i]) <= 0) continue;
                    byte[] splitStart = startRow.length == 0 || Bytes.compareTo(keys.getFirst()[i], startRow) >= 0 ? keys.getFirst()[i] : startRow;
                    byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo(keys.getSecond()[i], stopRow) <= 0) && keys.getSecond()[i].length > 0 ? keys.getSecond()[i] : stopRow;
                    String regionLocation = table.getRegionLocation(keys.getFirst()[i], false).getHostname();
                    TableSplit split = new TableSplit(Bytes.toBytes(tableNameStr), scan, splitStart, splitStop, regionLocation);
                    splits.add(split);
                    if (!this.LOG.isDebugEnabled()) continue;
                    this.LOG.debug((Object)("getSplits: split -> " + count++ + " -> " + split));
                }
            }
            table.close();
        }
        return splits;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    protected List<Scan> getScans() {
        return this.scans;
    }

    protected void setScans(List<Scan> scans) {
        this.scans = scans;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }
}

