/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class CompareFilter
extends FilterBase {
    protected CompareOp compareOp;
    protected WritableByteArrayComparable comparator;

    public CompareFilter() {
    }

    public CompareFilter(CompareOp compareOp, WritableByteArrayComparable comparator) {
        this.compareOp = compareOp;
        this.comparator = comparator;
    }

    public CompareOp getOperator() {
        return this.compareOp;
    }

    public WritableByteArrayComparable getComparator() {
        return this.comparator;
    }

    protected boolean doCompare(CompareOp compareOp, WritableByteArrayComparable comparator, byte[] data, int offset, int length) {
        if (compareOp == CompareOp.NO_OP) {
            return true;
        }
        int compareResult = comparator.compareTo(data, offset, length);
        switch (compareOp) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + compareOp.name());
    }

    public static ArrayList extractArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 but got: %s", (Object[])new Object[]{filterArguments.size()});
        CompareOp compareOp = ParseFilter.createCompareOp(filterArguments.get(0));
        WritableByteArrayComparable comparator = ParseFilter.createComparator(ParseFilter.removeQuotesFromByteArray(filterArguments.get(1)));
        if ((comparator instanceof RegexStringComparator || comparator instanceof SubstringComparator) && compareOp != CompareOp.EQUAL && compareOp != CompareOp.NOT_EQUAL) {
            throw new IllegalArgumentException("A regexstring comparator and substring comparator can only be used with EQUAL and NOT_EQUAL");
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add((Object)compareOp);
        arguments.add(comparator);
        return arguments;
    }

    public void readFields(DataInput in) throws IOException {
        this.compareOp = CompareOp.valueOf(in.readUTF());
        this.comparator = (WritableByteArrayComparable)HbaseObjectWritable.readObject(in, null);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.compareOp.name());
        HbaseObjectWritable.writeObject(out, this.comparator, WritableByteArrayComparable.class, null);
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.compareOp.name(), Bytes.toStringBinary(this.comparator.getValue()));
    }

    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER,
        NO_OP;

    }
}

