/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class RegionTransitionData
implements Writable {
    private EventHandler.EventType eventType;
    private byte[] regionName;
    private ServerName origin;
    private long stamp;
    private byte[] payload;

    public RegionTransitionData() {
    }

    public RegionTransitionData(EventHandler.EventType eventType, byte[] regionName) {
        this(eventType, regionName, null);
    }

    public RegionTransitionData(EventHandler.EventType eventType, byte[] regionName, ServerName origin) {
        this(eventType, regionName, origin, null);
    }

    public RegionTransitionData(EventHandler.EventType eventType, byte[] regionName, ServerName serverName, byte[] payload) {
        this.eventType = eventType;
        this.stamp = System.currentTimeMillis();
        this.regionName = regionName;
        this.origin = serverName;
        this.payload = payload;
    }

    public EventHandler.EventType getEventType() {
        return this.eventType;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public ServerName getOrigin() {
        return this.origin;
    }

    public long getStamp() {
        return this.stamp;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void readFields(DataInput in) throws IOException {
        this.eventType = EventHandler.EventType.values()[in.readShort()];
        this.stamp = in.readLong();
        this.regionName = Bytes.readByteArray(in);
        if (in.readBoolean()) {
            byte[] versionedBytes = Bytes.readByteArray(in);
            this.origin = ServerName.parseVersionedServerName(versionedBytes);
        }
        if (in.readBoolean()) {
            this.payload = Bytes.readByteArray(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.eventType.ordinal());
        out.writeLong(System.currentTimeMillis());
        Bytes.writeByteArray(out, this.regionName);
        out.writeBoolean(this.origin != null);
        if (this.origin != null) {
            Bytes.writeByteArray(out, this.origin.getVersionedBytes());
        }
        out.writeBoolean(this.payload != null);
        if (this.payload != null) {
            Bytes.writeByteArray(out, this.payload);
        }
    }

    public byte[] getBytes() {
        try {
            return Writables.getBytes((Writable)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RegionTransitionData fromBytes(byte[] bytes) {
        try {
            RegionTransitionData data = new RegionTransitionData();
            Writables.getWritable(bytes, data);
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "region=" + Bytes.toStringBinary(this.regionName) + ", origin=" + this.origin + ", state=" + (Object)((Object)this.eventType);
    }
}

