/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ForeignExceptionDispatcher
implements ForeignExceptionListener,
ForeignExceptionSnare {
    public static final Log LOG = LogFactory.getLog(ForeignExceptionDispatcher.class);
    protected final String name;
    protected final List<ForeignExceptionListener> listeners = new ArrayList<ForeignExceptionListener>();
    private ForeignException exception;

    public ForeignExceptionDispatcher(String name) {
        this.name = name;
    }

    public ForeignExceptionDispatcher() {
        this("");
    }

    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void receive(ForeignException e) {
        if (this.exception != null) {
            return;
        }
        LOG.debug((Object)(this.name + " accepting received exception"), (Throwable)e);
        this.exception = e != null ? e : new ForeignException(this.name, "");
        this.dispatch(e);
    }

    @Override
    public synchronized void rethrowException() throws ForeignException {
        if (this.exception != null) {
            throw new ForeignException(this.exception.getSource(), this.exception.getCause());
        }
    }

    @Override
    public synchronized boolean hasException() {
        return this.exception != null;
    }

    @Override
    public synchronized ForeignException getException() {
        return this.exception;
    }

    private void dispatch(ForeignException e) {
        for (ForeignExceptionListener l : this.listeners) {
            l.receive(e);
        }
    }

    public synchronized void addListener(ForeignExceptionListener errorable) {
        this.listeners.add(errorable);
    }
}

