/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.MultiPut;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class MultiPutResponse
implements Writable {
    protected MultiPut request;
    protected Map<byte[], Integer> answers = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);

    public void addResult(byte[] regionName, int result) {
        this.answers.put(regionName, result);
    }

    public Integer getAnswer(byte[] region) {
        return this.answers.get(region);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.answers.size());
        for (Map.Entry<byte[], Integer> e : this.answers.entrySet()) {
            Bytes.writeByteArray(out, e.getKey());
            out.writeInt(e.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.answers.clear();
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            byte[] key = Bytes.readByteArray(in);
            int value = in.readInt();
            this.answers.put(key, value);
        }
    }
}

