/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.service.Destroyable;
import org.apache.dubbo.rpc.service.EchoService;
import org.apache.dubbo.rpc.service.GenericService;

public abstract class AbstractProxyFactory
implements ProxyFactory {
    private static final Class<?>[] INTERNAL_INTERFACES = new Class[]{EchoService.class, Destroyable.class};
    private static final Logger logger = LoggerFactory.getLogger(AbstractProxyFactory.class);

    @Override
    public <T> T getProxy(Invoker<T> invoker) throws RpcException {
        return this.getProxy(invoker, false);
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker, boolean generic) throws RpcException {
        LinkedHashSet interfaces = new LinkedHashSet();
        ClassLoader classLoader = this.getClassLoader(invoker);
        String config = invoker.getUrl().getParameter("interfaces");
        if (StringUtils.isNotEmpty(config)) {
            String[] types;
            for (String type : types = CommonConstants.COMMA_SPLIT_PATTERN.split(config)) {
                try {
                    interfaces.add(ReflectUtils.forName(classLoader, type));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        Class<?> realInterfaceClass = null;
        if (generic) {
            try {
                String realInterface = invoker.getUrl().getParameter("interface");
                realInterfaceClass = ReflectUtils.forName(classLoader, realInterface);
                interfaces.add(realInterfaceClass);
            }
            catch (Throwable realInterface) {
                // empty catch block
            }
            if (GenericService.class.equals(invoker.getInterface()) || !GenericService.class.isAssignableFrom(invoker.getInterface())) {
                interfaces.add(com.alibaba.dubbo.rpc.service.GenericService.class);
            }
        }
        interfaces.add(invoker.getInterface());
        interfaces.addAll(Arrays.asList(INTERNAL_INTERFACES));
        try {
            return this.getProxy(invoker, interfaces.toArray(new Class[0]));
        }
        catch (Throwable t) {
            if (generic) {
                if (realInterfaceClass != null) {
                    interfaces.remove(realInterfaceClass);
                }
                interfaces.remove(invoker.getInterface());
                logger.error("Error occur when creating proxy. Invoker is in generic mode. Trying to create proxy without real interface class.", t);
                return this.getProxy(invoker, interfaces.toArray(new Class[0]));
            }
            throw t;
        }
    }

    private <T> ClassLoader getClassLoader(Invoker<T> invoker) {
        ServiceModel serviceModel = invoker.getUrl().getServiceModel();
        ClassLoader classLoader = null;
        if (serviceModel != null && serviceModel.getConfig() != null) {
            classLoader = serviceModel.getConfig().getInterfaceClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassUtils.getClassLoader();
        }
        return classLoader;
    }

    public static Class<?>[] getInternalInterfaces() {
        return (Class[])INTERNAL_INTERFACES.clone();
    }

    public abstract <T> T getProxy(Invoker<T> var1, Class<?>[] var2);
}

