/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.command;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import org.apache.dubbo.rpc.protocol.tri.command.QueuedCommand;

public class DataQueueCommand
extends QueuedCommand {
    private final byte[] data;
    private final int compressFlag;
    private final boolean endStream;

    private DataQueueCommand(byte[] data, int compressFlag, boolean endStream) {
        this.data = data;
        this.compressFlag = compressFlag;
        this.endStream = endStream;
    }

    public static DataQueueCommand createGrpcCommand(byte[] data, boolean endStream, int compressFlag) {
        return new DataQueueCommand(data, compressFlag, endStream);
    }

    @Override
    public void doSend(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.data == null) {
            ctx.write((Object)new DefaultHttp2DataFrame(this.endStream), promise);
        } else {
            ByteBuf buf = ctx.alloc().buffer();
            buf.writeByte(this.compressFlag);
            buf.writeInt(this.data.length);
            buf.writeBytes(this.data);
            ctx.write((Object)new DefaultHttp2DataFrame(buf, this.endStream), promise);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isEndStream() {
        return this.endStream;
    }
}

