/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.rpc.ProtocolServer;

public class DubboProtocolServer
implements ProtocolServer {
    private RemotingServer server;
    private String address;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public DubboProtocolServer(RemotingServer server) {
        this.server = server;
    }

    @Override
    public RemotingServer getRemotingServer() {
        return this.server;
    }

    @Override
    public String getAddress() {
        return StringUtils.isNotEmpty(this.address) ? this.address : this.server.getUrl().getAddress();
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public URL getUrl() {
        return this.server.getUrl();
    }

    @Override
    public void reset(URL url) {
        this.server.reset(url);
    }

    @Override
    public void close() {
        this.server.close();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

