/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.context.ApplicationExt;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.rpc.model.ApplicationInitListener;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;
import org.apache.dubbo.rpc.model.ServiceRepository;

public class ApplicationModel
extends ScopeModel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModel.class);
    public static final String NAME = "ApplicationModel";
    private final List<ModuleModel> moduleModels = new CopyOnWriteArrayList<ModuleModel>();
    private final List<ModuleModel> pubModuleModels = new CopyOnWriteArrayList<ModuleModel>();
    private Environment environment;
    private ConfigManager configManager;
    private ServiceRepository serviceRepository;
    private ApplicationDeployer deployer;
    private final FrameworkModel frameworkModel;
    private ModuleModel internalModule;
    private volatile ModuleModel defaultModule;
    private AtomicInteger moduleIndex = new AtomicInteger(0);
    private Object moduleLock = new Object();

    public static ApplicationModel ofNullable(ApplicationModel applicationModel) {
        if (applicationModel != null) {
            return applicationModel;
        }
        return ApplicationModel.defaultModel();
    }

    public static ApplicationModel defaultModel() {
        return FrameworkModel.defaultModel().defaultApplication();
    }

    @Deprecated
    public static Collection<ConsumerModel> allConsumerModels() {
        return ApplicationModel.defaultModel().getApplicationServiceRepository().allConsumerModels();
    }

    @Deprecated
    public static Collection<ProviderModel> allProviderModels() {
        return ApplicationModel.defaultModel().getApplicationServiceRepository().allProviderModels();
    }

    @Deprecated
    public static ProviderModel getProviderModel(String serviceKey) {
        return ApplicationModel.defaultModel().getDefaultModule().getServiceRepository().lookupExportedService(serviceKey);
    }

    @Deprecated
    public static ConsumerModel getConsumerModel(String serviceKey) {
        return ApplicationModel.defaultModel().getDefaultModule().getServiceRepository().lookupReferredService(serviceKey);
    }

    @Deprecated
    public static Environment getEnvironment() {
        return ApplicationModel.defaultModel().getModelEnvironment();
    }

    @Deprecated
    public static ConfigManager getConfigManager() {
        return ApplicationModel.defaultModel().getApplicationConfigManager();
    }

    @Deprecated
    public static ServiceRepository getServiceRepository() {
        return ApplicationModel.defaultModel().getApplicationServiceRepository();
    }

    @Deprecated
    public static ExecutorRepository getExecutorRepository() {
        return ApplicationModel.defaultModel().getApplicationExecutorRepository();
    }

    @Deprecated
    public static ApplicationConfig getApplicationConfig() {
        return ApplicationModel.defaultModel().getCurrentConfig();
    }

    @Deprecated
    public static String getName() {
        return ApplicationModel.defaultModel().getCurrentConfig().getName();
    }

    @Deprecated
    public static String getApplication() {
        return ApplicationModel.getName();
    }

    @Deprecated
    public static void reset() {
        if (FrameworkModel.defaultModel().getDefaultAppModel() != null) {
            FrameworkModel.defaultModel().getDefaultAppModel().destroy();
        }
    }

    public ApplicationModel(FrameworkModel frameworkModel) {
        this(frameworkModel, false);
    }

    public ApplicationModel(FrameworkModel frameworkModel, boolean isInternal) {
        super(frameworkModel, ExtensionScope.APPLICATION, isInternal);
        Assert.notNull((Object)frameworkModel, "FrameworkModel can not be null");
        this.frameworkModel = frameworkModel;
        frameworkModel.addApplication(this);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this.getDesc() + " is created");
        }
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.internalModule = new ModuleModel(this, true);
        this.serviceRepository = new ServiceRepository(this);
        ExtensionLoader<ApplicationInitListener> extensionLoader = this.getExtensionLoader(ApplicationInitListener.class);
        Set<String> listenerNames = extensionLoader.getSupportedExtensions();
        for (String listenerName : listenerNames) {
            extensionLoader.getExtension(listenerName).init();
        }
        this.initApplicationExts();
        ExtensionLoader<ScopeModelInitializer> initializerExtensionLoader = this.getExtensionLoader(ScopeModelInitializer.class);
        Set<ScopeModelInitializer> initializers = initializerExtensionLoader.getSupportedExtensionInstances();
        for (ScopeModelInitializer initializer : initializers) {
            initializer.initializeApplicationModel(this);
        }
    }

    private void initApplicationExts() {
        Set<ApplicationExt> exts = this.getExtensionLoader(ApplicationExt.class).getSupportedExtensionInstances();
        for (ApplicationExt ext : exts) {
            ext.initialize();
        }
    }

    @Override
    protected void onDestroy() {
        this.frameworkModel.removeApplication(this);
        if (this.deployer != null) {
            this.deployer.preDestroy();
        }
        this.frameworkModel.tryDestroyProtocols();
        for (ModuleModel moduleModel : new ArrayList<ModuleModel>(this.moduleModels)) {
            if (moduleModel == this.internalModule) continue;
            moduleModel.destroy();
        }
        this.internalModule.destroy();
        if (this.deployer != null) {
            this.deployer.postDestroy();
        }
        this.notifyDestroy();
        if (this.environment != null) {
            this.environment.destroy();
            this.environment = null;
        }
        if (this.configManager != null) {
            this.configManager.destroy();
            this.configManager = null;
        }
        if (this.serviceRepository != null) {
            this.serviceRepository.destroy();
            this.serviceRepository = null;
        }
        this.frameworkModel.tryDestroy();
    }

    public FrameworkModel getFrameworkModel() {
        return this.frameworkModel;
    }

    public ModuleModel newModule() {
        return new ModuleModel(this);
    }

    @Override
    public Environment getModelEnvironment() {
        if (this.environment == null) {
            this.environment = (Environment)this.getExtensionLoader(ApplicationExt.class).getExtension("environment");
        }
        return this.environment;
    }

    public ConfigManager getApplicationConfigManager() {
        if (this.configManager == null) {
            this.configManager = (ConfigManager)this.getExtensionLoader(ApplicationExt.class).getExtension("config");
        }
        return this.configManager;
    }

    public ServiceRepository getApplicationServiceRepository() {
        return this.serviceRepository;
    }

    public ExecutorRepository getApplicationExecutorRepository() {
        return this.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
    }

    public ApplicationConfig getCurrentConfig() {
        return this.getApplicationConfigManager().getApplicationOrElseThrow();
    }

    public String getApplicationName() {
        return this.getCurrentConfig().getName();
    }

    public String tryGetApplicationName() {
        Optional<ApplicationConfig> appCfgOptional = this.getApplicationConfigManager().getApplication();
        return appCfgOptional.isPresent() ? appCfgOptional.get().getName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addModule(ModuleModel moduleModel, boolean isInternal) {
        Object object = this.moduleLock;
        synchronized (object) {
            if (!this.moduleModels.contains(moduleModel)) {
                this.checkDestroyed();
                this.moduleModels.add(moduleModel);
                moduleModel.setInternalId(this.buildInternalId(this.getInternalId(), this.moduleIndex.getAndIncrement()));
                if (!isInternal) {
                    this.pubModuleModels.add(moduleModel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModule(ModuleModel moduleModel) {
        Object object = this.moduleLock;
        synchronized (object) {
            this.moduleModels.remove(moduleModel);
            this.pubModuleModels.remove(moduleModel);
            if (moduleModel == this.defaultModule) {
                this.defaultModule = this.findDefaultModule();
            }
        }
    }

    void tryDestroy() {
        if (this.moduleModels.isEmpty() || this.moduleModels.size() == 1 && this.moduleModels.get(0) == this.internalModule) {
            this.destroy();
        }
    }

    private void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("ApplicationModel is destroyed");
        }
    }

    public List<ModuleModel> getModuleModels() {
        return Collections.unmodifiableList(this.moduleModels);
    }

    public List<ModuleModel> getPubModuleModels() {
        return Collections.unmodifiableList(this.pubModuleModels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleModel getDefaultModule() {
        if (this.defaultModule == null) {
            Object object = this.moduleLock;
            synchronized (object) {
                if (this.defaultModule == null) {
                    this.defaultModule = this.findDefaultModule();
                    if (this.defaultModule == null) {
                        this.defaultModule = this.newModule();
                    }
                }
            }
        }
        return this.defaultModule;
    }

    private ModuleModel findDefaultModule() {
        for (ModuleModel moduleModel : this.moduleModels) {
            if (moduleModel == this.internalModule) continue;
            return moduleModel;
        }
        return null;
    }

    public ModuleModel getInternalModule() {
        return this.internalModule;
    }

    @Deprecated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Deprecated
    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    @Deprecated
    public void setServiceRepository(ServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        super.addClassLoader(classLoader);
        if (this.environment != null) {
            this.environment.refreshClassLoaders();
        }
    }

    @Override
    public void removeClassLoader(ClassLoader classLoader) {
        super.removeClassLoader(classLoader);
        if (this.environment != null) {
            this.environment.refreshClassLoaders();
        }
    }

    @Override
    protected boolean checkIfClassLoaderCanRemoved(ClassLoader classLoader) {
        return super.checkIfClassLoaderCanRemoved(classLoader) && !this.containsClassLoader(classLoader);
    }

    protected boolean containsClassLoader(ClassLoader classLoader) {
        return this.moduleModels.stream().anyMatch(moduleModel -> moduleModel.getClassLoaders().contains(classLoader));
    }

    public ApplicationDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ApplicationDeployer deployer) {
        this.deployer = deployer;
    }
}

