/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.Experimental;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvocationProfilerUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;

@SPI(value="default", scope=ExtensionScope.APPLICATION)
public interface FilterChainBuilder {
    public <T> Invoker<T> buildInvokerChain(Invoker<T> var1, String var2, String var3);

    public <T> ClusterInvoker<T> buildClusterInvokerChain(ClusterInvoker<T> var1, String var2, String var3);

    @Experimental(value="Works for the same purpose as ClusterFilterChainNode, replace ClusterFilterChainNode with this one when proved stable enough")
    public static class CopyOfClusterFilterChainNode<T, TYPE extends ClusterInvoker<T>, FILTER extends BaseFilter>
    extends CopyOfFilterChainNode<T, TYPE, FILTER>
    implements ClusterInvoker<T> {
        public CopyOfClusterFilterChainNode(TYPE originalInvoker, Invoker<T> nextNode, FILTER filter) {
            super(originalInvoker, nextNode, filter);
        }

        @Override
        public URL getRegistryUrl() {
            return ((ClusterInvoker)this.getOriginalInvoker()).getRegistryUrl();
        }

        @Override
        public Directory<T> getDirectory() {
            return ((ClusterInvoker)this.getOriginalInvoker()).getDirectory();
        }

        @Override
        public boolean isDestroyed() {
            return ((ClusterInvoker)this.getOriginalInvoker()).isDestroyed();
        }
    }

    @Experimental(value="Works for the same purpose as FilterChainNode, replace FilterChainNode with this one when proved stable enough")
    public static class CopyOfFilterChainNode<T, TYPE extends Invoker<T>, FILTER extends BaseFilter>
    implements Invoker<T> {
        TYPE originalInvoker;
        Invoker<T> nextNode;
        FILTER filter;

        public CopyOfFilterChainNode(TYPE originalInvoker, Invoker<T> nextNode, FILTER filter) {
            this.originalInvoker = originalInvoker;
            this.nextNode = nextNode;
            this.filter = filter;
        }

        public TYPE getOriginalInvoker() {
            return this.originalInvoker;
        }

        @Override
        public Class<T> getInterface() {
            return this.originalInvoker.getInterface();
        }

        @Override
        public URL getUrl() {
            return this.originalInvoker.getUrl();
        }

        @Override
        public boolean isAvailable() {
            return this.originalInvoker.isAvailable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            try {
                InvocationProfilerUtils.enterDetailProfiler(invocation, () -> "Filter " + this.filter.getClass().getName() + " invoke.");
                return this.filter.invoke(this.nextNode, invocation);
            }
            catch (Exception e) {
                InvocationProfilerUtils.releaseDetailProfiler(invocation);
                if (this.filter instanceof ListenableFilter) {
                    ListenableFilter listenableFilter = (ListenableFilter)this.filter;
                    try {
                        BaseFilter.Listener listener = listenableFilter.listener(invocation);
                        if (listener == null) throw e;
                        listener.onError(e, (Invoker<?>)this.originalInvoker, invocation);
                        throw e;
                    }
                    finally {
                        listenableFilter.removeListener(invocation);
                    }
                } else {
                    if (!(this.filter instanceof BaseFilter.Listener)) throw e;
                    BaseFilter.Listener listener = (BaseFilter.Listener)this.filter;
                    listener.onError(e, (Invoker<?>)this.originalInvoker, invocation);
                }
                throw e;
            }
        }

        @Override
        public void destroy() {
            this.originalInvoker.destroy();
        }

        public String toString() {
            return this.originalInvoker.toString();
        }
    }

    public static class ClusterCallbackRegistrationInvoker<T, FILTER extends BaseFilter>
    extends CallbackRegistrationInvoker<T, FILTER>
    implements ClusterInvoker<T> {
        private ClusterInvoker<T> originalInvoker;

        public ClusterCallbackRegistrationInvoker(ClusterInvoker<T> originalInvoker, Invoker<T> filterInvoker, List<FILTER> filters) {
            super(filterInvoker, filters);
            this.originalInvoker = originalInvoker;
        }

        public ClusterInvoker<T> getOriginalInvoker() {
            return this.originalInvoker;
        }

        @Override
        public URL getRegistryUrl() {
            return this.getOriginalInvoker().getRegistryUrl();
        }

        @Override
        public Directory<T> getDirectory() {
            return this.getOriginalInvoker().getDirectory();
        }

        @Override
        public boolean isDestroyed() {
            return this.getOriginalInvoker().isDestroyed();
        }
    }

    public static class CallbackRegistrationInvoker<T, FILTER extends BaseFilter>
    implements Invoker<T> {
        static final Logger LOGGER = LoggerFactory.getLogger(CallbackRegistrationInvoker.class);
        final Invoker<T> filterInvoker;
        final List<FILTER> filters;

        public CallbackRegistrationInvoker(Invoker<T> filterInvoker, List<FILTER> filters) {
            this.filterInvoker = filterInvoker;
            this.filters = filters;
        }

        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            Result asyncResult = this.filterInvoker.invoke(invocation);
            asyncResult.whenCompleteWithContext((r, t) -> {
                for (int i = this.filters.size() - 1; i >= 0; --i) {
                    BaseFilter filter = (BaseFilter)this.filters.get(i);
                    try {
                        InvocationProfilerUtils.releaseDetailProfiler(invocation);
                        if (filter instanceof ListenableFilter) {
                            ListenableFilter listenableFilter = (ListenableFilter)filter;
                            BaseFilter.Listener listener = listenableFilter.listener(invocation);
                            try {
                                if (listener == null) continue;
                                if (t == null) {
                                    listener.onResponse((Result)r, this.filterInvoker, invocation);
                                    continue;
                                }
                                listener.onError((Throwable)t, this.filterInvoker, invocation);
                                continue;
                            }
                            finally {
                                listenableFilter.removeListener(invocation);
                            }
                        }
                        if (!(filter instanceof BaseFilter.Listener)) continue;
                        BaseFilter.Listener listener = (BaseFilter.Listener)((Object)filter);
                        if (t == null) {
                            listener.onResponse((Result)r, this.filterInvoker, invocation);
                            continue;
                        }
                        listener.onError((Throwable)t, this.filterInvoker, invocation);
                        continue;
                    }
                    catch (Throwable filterThrowable) {
                        LOGGER.error(String.format("Exception occurred while executing the %s filter named %s.", i, filter.getClass().getSimpleName()));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.format("Whole filter list is: %s", this.filters.stream().map(tmpFilter -> tmpFilter.getClass().getSimpleName()).collect(Collectors.toList())));
                        }
                        throw filterThrowable;
                    }
                }
            });
            return asyncResult;
        }

        @Override
        public Class<T> getInterface() {
            return this.filterInvoker.getInterface();
        }

        @Override
        public URL getUrl() {
            return this.filterInvoker.getUrl();
        }

        @Override
        public boolean isAvailable() {
            return this.filterInvoker.isAvailable();
        }

        @Override
        public void destroy() {
            this.filterInvoker.destroy();
        }
    }

    public static class ClusterFilterChainNode<T, TYPE extends ClusterInvoker<T>, FILTER extends BaseFilter>
    extends FilterChainNode<T, TYPE, FILTER>
    implements ClusterInvoker<T> {
        public ClusterFilterChainNode(TYPE originalInvoker, Invoker<T> nextNode, FILTER filter) {
            super(originalInvoker, nextNode, filter);
        }

        @Override
        public URL getRegistryUrl() {
            return ((ClusterInvoker)this.getOriginalInvoker()).getRegistryUrl();
        }

        @Override
        public Directory<T> getDirectory() {
            return ((ClusterInvoker)this.getOriginalInvoker()).getDirectory();
        }

        @Override
        public boolean isDestroyed() {
            return ((ClusterInvoker)this.getOriginalInvoker()).isDestroyed();
        }
    }

    public static class FilterChainNode<T, TYPE extends Invoker<T>, FILTER extends BaseFilter>
    implements Invoker<T> {
        TYPE originalInvoker;
        Invoker<T> nextNode;
        FILTER filter;

        public FilterChainNode(TYPE originalInvoker, Invoker<T> nextNode, FILTER filter) {
            this.originalInvoker = originalInvoker;
            this.nextNode = nextNode;
            this.filter = filter;
        }

        public TYPE getOriginalInvoker() {
            return this.originalInvoker;
        }

        @Override
        public Class<T> getInterface() {
            return this.originalInvoker.getInterface();
        }

        @Override
        public URL getUrl() {
            return this.originalInvoker.getUrl();
        }

        @Override
        public boolean isAvailable() {
            return this.originalInvoker.isAvailable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            try {
                InvocationProfilerUtils.enterDetailProfiler(invocation, () -> "Filter " + this.filter.getClass().getName() + " invoke.");
                Result asyncResult = this.filter.invoke(this.nextNode, invocation);
                return asyncResult.whenCompleteWithContext((r, t) -> {
                    InvocationProfilerUtils.releaseDetailProfiler(invocation);
                    if (this.filter instanceof ListenableFilter) {
                        ListenableFilter listenableFilter = (ListenableFilter)this.filter;
                        BaseFilter.Listener listener = listenableFilter.listener(invocation);
                        try {
                            if (listener == null) return;
                            if (t == null) {
                                listener.onResponse((Result)r, (Invoker<?>)this.originalInvoker, invocation);
                                return;
                            }
                            listener.onError((Throwable)t, (Invoker<?>)this.originalInvoker, invocation);
                            return;
                        }
                        finally {
                            listenableFilter.removeListener(invocation);
                        }
                    } else {
                        if (!(this.filter instanceof BaseFilter.Listener)) return;
                        BaseFilter.Listener listener = (BaseFilter.Listener)this.filter;
                        if (t == null) {
                            listener.onResponse((Result)r, (Invoker<?>)this.originalInvoker, invocation);
                            return;
                        } else {
                            listener.onError((Throwable)t, (Invoker<?>)this.originalInvoker, invocation);
                        }
                    }
                });
            }
            catch (Exception e) {
                InvocationProfilerUtils.releaseDetailProfiler(invocation);
                if (this.filter instanceof ListenableFilter) {
                    ListenableFilter listenableFilter = (ListenableFilter)this.filter;
                    try {
                        BaseFilter.Listener listener = listenableFilter.listener(invocation);
                        if (listener == null) throw e;
                        listener.onError(e, (Invoker<?>)this.originalInvoker, invocation);
                        throw e;
                    }
                    finally {
                        listenableFilter.removeListener(invocation);
                    }
                } else {
                    if (!(this.filter instanceof BaseFilter.Listener)) throw e;
                    BaseFilter.Listener listener = (BaseFilter.Listener)this.filter;
                    listener.onError(e, (Invoker<?>)this.originalInvoker, invocation);
                }
                throw e;
            }
        }

        @Override
        public void destroy() {
            this.originalInvoker.destroy();
        }

        public String toString() {
            return this.originalInvoker.toString();
        }
    }
}

