/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.router.RouterResult;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotSwitcher;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterFactory;
import org.apache.dubbo.rpc.cluster.router.state.TailStateRouter;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class RouterChain<T> {
    private static final Logger logger = LoggerFactory.getLogger(RouterChain.class);
    private volatile BitList<Invoker<T>> invokers = BitList.emptyList();
    private volatile List<Router> routers = Collections.emptyList();
    private volatile List<Router> builtinRouters = Collections.emptyList();
    private volatile StateRouter<T> headStateRouter;
    private volatile List<StateRouter<T>> stateRouters;
    private final boolean shouldFailFast;
    private final RouterSnapshotSwitcher routerSnapshotSwitcher;

    public static <T> RouterChain<T> buildChain(Class<T> interfaceClass, URL url) {
        ModuleModel moduleModel = url.getOrDefaultModuleModel();
        List<RouterFactory> extensionFactories = moduleModel.getExtensionLoader(RouterFactory.class).getActivateExtension(url, "router");
        List<Router> routers = extensionFactories.stream().map(factory -> factory.getRouter(url)).sorted(Router::compareTo).collect(Collectors.toList());
        List<StateRouter<T>> stateRouters = moduleModel.getExtensionLoader(StateRouterFactory.class).getActivateExtension(url, "router").stream().map(factory -> factory.getRouter(interfaceClass, url)).collect(Collectors.toList());
        boolean shouldFailFast = Boolean.parseBoolean(ConfigurationUtils.getProperty(moduleModel, "dubbo.router.should-fail-fast", "true"));
        RouterSnapshotSwitcher routerSnapshotSwitcher = ScopeModelUtil.getFrameworkModel(moduleModel).getBeanFactory().getBean(RouterSnapshotSwitcher.class);
        return new RouterChain<T>(routers, stateRouters, shouldFailFast, routerSnapshotSwitcher);
    }

    public RouterChain(List<Router> routers, List<StateRouter<T>> stateRouters, boolean shouldFailFast, RouterSnapshotSwitcher routerSnapshotSwitcher) {
        this.initWithRouters(routers);
        this.initWithStateRouters(stateRouters);
        this.shouldFailFast = shouldFailFast;
        this.routerSnapshotSwitcher = routerSnapshotSwitcher;
    }

    private void initWithStateRouters(List<StateRouter<T>> stateRouters) {
        StateRouter stateRouter = TailStateRouter.getInstance();
        for (int i = stateRouters.size() - 1; i >= 0; --i) {
            StateRouter nextStateRouter = stateRouters.get(i);
            nextStateRouter.setNextRouter(stateRouter);
            stateRouter = nextStateRouter;
        }
        this.headStateRouter = stateRouter;
        this.stateRouters = Collections.unmodifiableList(stateRouters);
    }

    public void initWithRouters(List<Router> builtinRouters) {
        this.builtinRouters = builtinRouters;
        this.routers = new LinkedList<Router>(builtinRouters);
    }

    public void addRouters(List<Router> routers) {
        LinkedList<Router> newRouters = new LinkedList<Router>();
        newRouters.addAll(this.builtinRouters);
        newRouters.addAll(routers);
        CollectionUtils.sort(newRouters);
        this.routers = newRouters;
    }

    public List<Router> getRouters() {
        return this.routers;
    }

    public StateRouter<T> getHeadStateRouter() {
        return this.headStateRouter;
    }

    public List<Invoker<T>> route(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        if (RpcContext.getServiceContext().isNeedPrintRouterSnapshot()) {
            return this.routeAndPrint(url, availableInvokers, invocation);
        }
        return this.simpleRoute(url, availableInvokers, invocation);
    }

    public List<Invoker<T>> routeAndPrint(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        RouterSnapshotNode<T> snapshot = this.buildRouterSnapshot(url, availableInvokers, invocation);
        this.logRouterSnapshot(url, invocation, snapshot);
        return snapshot.getChainOutputInvokers();
    }

    public List<Invoker<T>> simpleRoute(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        BitList<Invoker<T>> resultInvokers = availableInvokers.clone();
        if ((resultInvokers = this.headStateRouter.route(resultInvokers, url, invocation, false, null)).isEmpty() && (this.shouldFailFast || this.routers.isEmpty())) {
            this.printRouterSnapshot(url, availableInvokers, invocation);
            return BitList.emptyList();
        }
        if (this.routers.isEmpty()) {
            return resultInvokers;
        }
        List<Invoker<T>> commonRouterResult = resultInvokers.cloneToArrayList();
        for (Router router : this.routers) {
            RouterResult<Invoker<T>> routeResult = router.route(commonRouterResult, url, invocation, false);
            commonRouterResult = routeResult.getResult();
            if (CollectionUtils.isEmpty(commonRouterResult) && this.shouldFailFast) {
                this.printRouterSnapshot(url, availableInvokers, invocation);
                return BitList.emptyList();
            }
            if (routeResult.isNeedContinueRoute()) continue;
            return commonRouterResult;
        }
        if (commonRouterResult.isEmpty()) {
            this.printRouterSnapshot(url, availableInvokers, invocation);
            return BitList.emptyList();
        }
        return commonRouterResult;
    }

    private void printRouterSnapshot(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        if (logger.isWarnEnabled()) {
            this.logRouterSnapshot(url, invocation, this.buildRouterSnapshot(url, availableInvokers, invocation));
        }
    }

    public RouterSnapshotNode<T> buildRouterSnapshot(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        BitList<Invoker<T>> resultInvokers = availableInvokers.clone();
        RouterSnapshotNode parentNode = new RouterSnapshotNode("Parent", resultInvokers.clone());
        parentNode.setNodeOutputInvokers(resultInvokers.clone());
        Holder nodeHolder = new Holder();
        nodeHolder.set(parentNode);
        resultInvokers = this.headStateRouter.route(resultInvokers, url, invocation, true, nodeHolder);
        if (this.routers.isEmpty() || resultInvokers.isEmpty() && this.shouldFailFast) {
            parentNode.setChainOutputInvokers(resultInvokers.clone());
            return parentNode;
        }
        RouterSnapshotNode commonRouterNode = new RouterSnapshotNode("CommonRouter", resultInvokers.clone());
        parentNode.appendNode(commonRouterNode);
        List<Invoker<T>> commonRouterResult = resultInvokers;
        for (Router router : this.routers) {
            ArrayList<Invoker<T>> inputInvokers = new ArrayList<Invoker<T>>(commonRouterResult);
            RouterSnapshotNode<T> currentNode = new RouterSnapshotNode<T>(router.getClass().getSimpleName(), inputInvokers);
            commonRouterNode.appendNode(currentNode);
            commonRouterNode = currentNode;
            RouterResult<Invoker<T>> routeStateResult = router.route(inputInvokers, url, invocation, true);
            List<Invoker<T>> routeResult = routeStateResult.getResult();
            String routerMessage = routeStateResult.getMessage();
            currentNode.setNodeOutputInvokers(routeResult);
            currentNode.setRouterMessage(routerMessage);
            commonRouterResult = routeResult;
            if ((!CollectionUtils.isEmpty(routeResult) || !this.shouldFailFast) && routeStateResult.isNeedContinueRoute()) continue;
            break;
        }
        commonRouterNode.setChainOutputInvokers(commonRouterNode.getNodeOutputInvokers());
        RouterSnapshotNode currentNode = commonRouterNode;
        while (currentNode != null) {
            RouterSnapshotNode parent = currentNode.getParentNode();
            if (parent != null) {
                parent.setChainOutputInvokers(currentNode.getChainOutputInvokers());
            }
            currentNode = parent;
        }
        return parentNode;
    }

    private void logRouterSnapshot(URL url, Invocation invocation, RouterSnapshotNode<T> snapshotNode) {
        if (snapshotNode.getChainOutputInvokers() == null || snapshotNode.getChainOutputInvokers().isEmpty()) {
            if (logger.isWarnEnabled()) {
                String message = "No provider available after route for the service " + url.getServiceKey() + " from registry " + url.getAddress() + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ". Router snapshot is below: \n" + snapshotNode.toString();
                if (this.routerSnapshotSwitcher.isEnable()) {
                    this.routerSnapshotSwitcher.setSnapshot(message);
                }
                logger.warn(message);
            }
        } else if (logger.isInfoEnabled()) {
            String message = "Router snapshot service " + url.getServiceKey() + " from registry " + url.getAddress() + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + " is below: \n" + snapshotNode.toString();
            if (this.routerSnapshotSwitcher.isEnable()) {
                this.routerSnapshotSwitcher.setSnapshot(message);
            }
            logger.info(message);
        }
    }

    public void setInvokers(BitList<Invoker<T>> invokers) {
        this.invokers = invokers == null ? BitList.emptyList() : invokers;
        this.routers.forEach(router -> router.notify(this.invokers));
        this.stateRouters.forEach(router -> router.notify(this.invokers));
    }

    @Deprecated
    public void setHeadStateRouter(StateRouter<T> headStateRouter) {
        this.headStateRouter = headStateRouter;
    }

    @Deprecated
    public List<StateRouter<T>> getStateRouters() {
        return this.stateRouters;
    }

    public void destroy() {
        this.invokers = BitList.emptyList();
        for (Router router : this.routers) {
            try {
                router.stop();
            }
            catch (Exception e) {
                logger.error("Error trying to stop router " + router.getClass(), e);
            }
        }
        this.routers = Collections.emptyList();
        this.builtinRouters = Collections.emptyList();
        for (StateRouter stateRouter : this.stateRouters) {
            try {
                stateRouter.stop();
            }
            catch (Exception e) {
                logger.error("Error trying to stop stateRouter " + stateRouter.getClass(), e);
            }
        }
        this.stateRouters = Collections.emptyList();
        this.headStateRouter = TailStateRouter.getInstance();
    }
}

