/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.List;
import org.apache.dubbo.common.utils.StringUtils;

public class NacosNamingServiceWrapper {
    private static final String INNERCLASS_SYMBOL = "$";
    private static final String INNERCLASS_COMPATIBLE_SYMBOL = "___";
    private final NamingService namingService;

    public NacosNamingServiceWrapper(NamingService namingService) {
        this.namingService = namingService;
    }

    public String getServerStatus() {
        return this.namingService.getServerStatus();
    }

    public void subscribe(String serviceName, EventListener eventListener) throws NacosException {
        this.namingService.subscribe(this.handleInnerSymbol(serviceName), eventListener);
    }

    public void subscribe(String serviceName, String group, EventListener eventListener) throws NacosException {
        this.namingService.subscribe(this.handleInnerSymbol(serviceName), group, eventListener);
    }

    public List<Instance> getAllInstances(String serviceName, String group) throws NacosException {
        return this.namingService.getAllInstances(this.handleInnerSymbol(serviceName), group);
    }

    public void registerInstance(String serviceName, String group, Instance instance) throws NacosException {
        this.namingService.registerInstance(this.handleInnerSymbol(serviceName), group, instance);
    }

    public void deregisterInstance(String serviceName, String group, String ip, int port) throws NacosException {
        this.namingService.deregisterInstance(this.handleInnerSymbol(serviceName), group, ip, port);
    }

    public void deregisterInstance(String serviceName, String group, Instance instance) throws NacosException {
        this.namingService.deregisterInstance(this.handleInnerSymbol(serviceName), group, instance);
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize, String parameter) throws NacosException {
        return this.namingService.getServicesOfServer(pageNo, pageSize, parameter);
    }

    public List<Instance> selectInstances(String serviceName, boolean healthy) throws NacosException {
        return this.namingService.selectInstances(this.handleInnerSymbol(serviceName), healthy);
    }

    public List<Instance> selectInstances(String serviceName, String group, boolean healthy) throws NacosException {
        return this.namingService.selectInstances(this.handleInnerSymbol(serviceName), group, healthy);
    }

    public void shutdown() throws NacosException {
        this.namingService.shutDown();
    }

    private String handleInnerSymbol(String serviceName) {
        if (StringUtils.isEmpty(serviceName)) {
            return null;
        }
        return serviceName.replace(INNERCLASS_SYMBOL, INNERCLASS_COMPATIBLE_SYMBOL);
    }
}

