/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.command.util.ServiceCheckUtils;
import org.apache.dubbo.qos.textui.TTable;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ProviderModel;

@Cmd(name="ls", summary="ls service", example={"ls"})
public class Ls
implements BaseCommand {
    private FrameworkModel frameworkModel;

    public Ls(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        StringBuilder result = new StringBuilder();
        result.append(this.listProvider());
        result.append(this.listConsumer());
        return result.toString();
    }

    public String listProvider() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("As Provider side:" + System.lineSeparator());
        List<ProviderModel> providerModelList = this.frameworkModel.getServiceRepository().allProviderModels();
        TTable tTable = new TTable(new TTable.ColumnDefine[]{new TTable.ColumnDefine(TTable.Align.MIDDLE), new TTable.ColumnDefine(TTable.Align.MIDDLE)});
        tTable.addRow("Provider Service Name", "PUB");
        for (ProviderModel providerModel : providerModelList) {
            tTable.addRow(providerModel.getServiceKey(), ServiceCheckUtils.isRegistered(providerModel) ? "Y" : "N");
        }
        stringBuilder.append(tTable.rendering());
        return stringBuilder.toString();
    }

    public String listConsumer() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("As Consumer side:" + System.lineSeparator());
        List<ConsumerModel> consumerModelList = this.frameworkModel.getServiceRepository().allConsumerModels();
        TTable tTable = new TTable(new TTable.ColumnDefine[]{new TTable.ColumnDefine(TTable.Align.MIDDLE), new TTable.ColumnDefine(TTable.Align.MIDDLE)});
        tTable.addRow("Consumer Service Name", "NUM");
        for (ConsumerModel consumerModel : consumerModelList) {
            tTable.addRow(consumerModel.getServiceKey(), ServiceCheckUtils.getConsumerAddressNum(consumerModel));
        }
        stringBuilder.append(tTable.rendering());
        return stringBuilder.toString();
    }
}

