/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.probe.LivenessProbe;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="live", summary="Judge if service is alive? ")
public class Live
implements BaseCommand {
    private FrameworkModel frameworkModel;

    public Live(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        String config = this.frameworkModel.getApplicationModels().stream().map(applicationModel -> applicationModel.getApplicationConfigManager().getApplication()).map(o -> o.orElse(null)).filter(Objects::nonNull).map(ApplicationConfig::getLivenessProbe).filter(Objects::nonNull).collect(Collectors.joining(","));
        URL url = URL.valueOf("application://").addParameter("dubbo.application.liveness-probe", config);
        List<LivenessProbe> livenessProbes = this.frameworkModel.getExtensionLoader(LivenessProbe.class).getActivateExtension(url, "dubbo.application.liveness-probe");
        if (!livenessProbes.isEmpty()) {
            for (LivenessProbe livenessProbe : livenessProbes) {
                if (livenessProbe.check()) continue;
                commandContext.setHttpCode(503);
                return "false";
            }
        }
        commandContext.setHttpCode(200);
        return "true";
    }
}

