/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;

@Cmd(name="cd", summary="Change default service.", example={"cd [service]"})
public class ChangeTelnet
implements BaseCommand {
    public static final AttributeKey<String> SERVICE_KEY = AttributeKey.valueOf((String)"telnet.service");
    private DubboProtocol dubboProtocol;

    public ChangeTelnet(FrameworkModel frameworkModel) {
        this.dubboProtocol = DubboProtocol.getDubboProtocol(frameworkModel);
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        Channel channel = commandContext.getRemote();
        if (ArrayUtils.isEmpty(args)) {
            return "Please input service name, eg: \r\ncd XxxService\r\ncd com.xxx.XxxService";
        }
        String message = args[0];
        StringBuilder buf = new StringBuilder();
        if ("/".equals(message) || "..".equals(message)) {
            String service = (String)channel.attr(SERVICE_KEY).getAndRemove();
            buf.append("Cancelled default service ").append(service).append(".");
        } else {
            boolean found = false;
            for (Exporter<?> exporter : this.dubboProtocol.getExporters()) {
                if (!message.equals(exporter.getInvoker().getInterface().getSimpleName()) && !message.equals(exporter.getInvoker().getInterface().getName()) && !message.equals(exporter.getInvoker().getUrl().getPath())) continue;
                found = true;
                break;
            }
            if (found) {
                channel.attr(SERVICE_KEY).set((Object)message);
                buf.append("Used the ").append(message).append(" as default.\r\nYou can cancel default service by command: cd /");
            } else {
                buf.append("No such service ").append(message);
            }
        }
        return buf.toString();
    }
}

