/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportFactory;

public abstract class AbstractMetadataReportFactory
implements MetadataReportFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetadataReportFactory.class);
    private static final String EXPORT_KEY = "export";
    private static final String REFER_KEY = "refer";
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, MetadataReport> serviceStoreMap = new ConcurrentHashMap<String, MetadataReport>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataReport getMetadataReport(URL url) {
        String key = (url = url.setPath(MetadataReport.class.getName()).removeParameters(EXPORT_KEY, REFER_KEY)).toServiceString();
        MetadataReport metadataReport = this.serviceStoreMap.get(key);
        if (metadataReport != null) {
            return metadataReport;
        }
        this.lock.lock();
        try {
            metadataReport = this.serviceStoreMap.get(key);
            if (metadataReport != null) {
                MetadataReport metadataReport2 = metadataReport;
                return metadataReport2;
            }
            boolean check = url.getParameter("check", true) && url.getPort() != 0;
            try {
                metadataReport = this.createMetadataReport(url);
            }
            catch (Exception e) {
                if (!check) {
                    logger.warn("The metadata reporter failed to initialize", e);
                }
                throw e;
            }
            if (check && metadataReport == null) {
                throw new IllegalStateException("Can not create metadata Report " + url);
            }
            if (metadataReport != null) {
                this.serviceStoreMap.put(key, metadataReport);
            }
            MetadataReport metadataReport3 = metadataReport;
            return metadataReport3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.lock.lock();
        try {
            for (MetadataReport metadataReport : this.serviceStoreMap.values()) {
                try {
                    metadataReport.destroy();
                }
                catch (Throwable ignored) {
                    logger.warn(ignored.getMessage(), ignored);
                }
            }
            this.serviceStoreMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract MetadataReport createMetadataReport(URL var1);
}

