/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;

public class CompositeReferenceCache
implements ReferenceCache {
    private ApplicationModel applicationModel;

    public CompositeReferenceCache(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public <T> T get(ReferenceConfigBase<T> referenceConfig) {
        return referenceConfig.get();
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            T proxy = moduleModel.getDeployer().getReferenceCache().get(key, type);
            if (proxy == null) continue;
            return proxy;
        }
        return null;
    }

    @Override
    public <T> T get(String key) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            Object proxy = moduleModel.getDeployer().getReferenceCache().get(key);
            if (proxy == null) continue;
            return proxy;
        }
        return null;
    }

    @Override
    public <T> List<T> getAll(Class<T> type) {
        ArrayList<T> proxies = new ArrayList<T>();
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            proxies.addAll(moduleModel.getDeployer().getReferenceCache().getAll(type));
        }
        return proxies;
    }

    @Override
    public <T> T get(Class<T> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            T proxy = moduleModel.getDeployer().getReferenceCache().get(type);
            if (proxy == null) continue;
            return proxy;
        }
        return null;
    }

    @Override
    public void destroy(String key, Class<?> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroy(key, type);
        }
    }

    @Override
    public void destroy(Class<?> type) {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroy(type);
        }
    }

    @Override
    public <T> void destroy(ReferenceConfigBase<T> referenceConfig) {
        referenceConfig.getScopeModel().getDeployer().getReferenceCache().destroy(referenceConfig);
    }

    @Override
    public void destroyAll() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().getReferenceCache().destroyAll();
        }
    }
}

