/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;

public class MetadataServiceURLParamsMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance, ApplicationModel applicationModel) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        String propertyName = this.resolveMetadataPropertyName(serviceInstance);
        String propertyValue = this.resolveMetadataPropertyValue(applicationModel);
        if (!StringUtils.isBlank(propertyName) && !StringUtils.isBlank(propertyValue)) {
            metadata.put(propertyName, propertyValue);
        }
    }

    private String resolveMetadataPropertyName(ServiceInstance serviceInstance) {
        return "dubbo.metadata-service.url-params";
    }

    private String resolveMetadataPropertyValue(ApplicationModel applicationModel) {
        List<URL> metadataURLs;
        ModuleServiceRepository serviceRepository = applicationModel.getInternalModule().getServiceRepository();
        String key = BaseServiceMetadata.buildServiceKey(MetadataService.class.getName(), applicationModel.getApplicationName(), "1.0.0");
        ProviderModel providerModel = serviceRepository.lookupExportedService(key);
        String metadataValue = "";
        if (providerModel != null && CollectionUtils.isNotEmpty(metadataURLs = providerModel.getServiceConfig().getExportedUrls())) {
            metadataValue = ServiceInstanceMetadataUtils.getMetadataServiceParameter(metadataURLs.get(0));
        }
        return metadataValue;
    }
}

