/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.metadata.MetadataServiceDelegation;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurableMetadataServiceExporter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MetadataServiceDelegation metadataService;
    private volatile ServiceConfig<MetadataService> serviceConfig;
    private final ApplicationModel applicationModel;

    public ConfigurableMetadataServiceExporter(ApplicationModel applicationModel, MetadataServiceDelegation metadataService) {
        this.applicationModel = applicationModel;
        this.metadataService = metadataService;
    }

    public synchronized ConfigurableMetadataServiceExporter export() {
        if (this.serviceConfig == null || !this.isExported()) {
            this.serviceConfig = this.buildServiceConfig();
            this.serviceConfig.export();
            this.metadataService.setMetadataURL(this.serviceConfig.getExportedUrls().get(0));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The MetadataService exports urls : " + this.serviceConfig.getExportedUrls());
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The MetadataService has been exported : " + this.serviceConfig.getExportedUrls());
        }
        return this;
    }

    public ConfigurableMetadataServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
            this.metadataService.setMetadataURL(null);
        }
        return this;
    }

    public boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported() && !this.serviceConfig.isUnexported();
    }

    private ApplicationConfig getApplicationConfig() {
        return this.applicationModel.getApplicationConfigManager().getApplication().get();
    }

    private ProtocolConfig generateMetadataProtocol() {
        String specifiedProtocol = this.getSpecifiedProtocol();
        Integer port = this.getSpecifiedPort();
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setName(specifiedProtocol);
        if (port == null || port < -1) {
            try {
                Iterator<ProtocolServer> it;
                Protocol protocol;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Metadata Service Port hasn't been set will use default protocol defined in protocols.");
                }
                if ((protocol = this.applicationModel.getExtensionLoader(Protocol.class).getExtension(specifiedProtocol)) != null && protocol.getServers() != null && (it = protocol.getServers().iterator()).hasNext()) {
                    String addr = it.next().getAddress();
                    String rawPort = addr.substring(addr.indexOf(":") + 1);
                    protocolConfig.setPort(Integer.parseInt(rawPort));
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to find any valid " + specifiedProtocol + " protocol, will use random port to export metadata service.");
            }
        } else {
            protocolConfig.setPort(port);
        }
        if (protocolConfig.getPort() == null) {
            protocolConfig.setPort(-1);
        }
        this.logger.info("Using " + specifiedProtocol + " protocol to export metadata service on port " + protocolConfig.getPort());
        return protocolConfig;
    }

    private Integer getSpecifiedPort() {
        String rawPort;
        Map<String, String> params;
        Integer port = this.getApplicationConfig().getMetadataServicePort();
        if (port == null && CollectionUtils.isNotEmptyMap(params = this.getApplicationConfig().getParameters()) && StringUtils.isNotEmpty(rawPort = this.getApplicationConfig().getParameters().get("metadata-service-port"))) {
            port = Integer.parseInt(rawPort);
        }
        return port;
    }

    private String getSpecifiedProtocol() {
        Map<String, String> params;
        String protocol = this.getApplicationConfig().getMetadataServiceProtocol();
        if (StringUtils.isEmpty(protocol) && CollectionUtils.isNotEmptyMap(params = this.getApplicationConfig().getParameters())) {
            protocol = this.getApplicationConfig().getParameters().get("metadata-service-protocol");
        }
        return StringUtils.isNotEmpty(protocol) ? protocol : "dubbo";
    }

    private ServiceConfig<MetadataService> buildServiceConfig() {
        ApplicationConfig applicationConfig = this.getApplicationConfig();
        ServiceConfig<MetadataService> serviceConfig = new ServiceConfig<MetadataService>();
        serviceConfig.setScopeModel(this.applicationModel.getInternalModule());
        serviceConfig.setApplication(applicationConfig);
        serviceConfig.setRegistry(new RegistryConfig("N/A"));
        serviceConfig.setProtocol(this.generateMetadataProtocol());
        serviceConfig.setInterface(MetadataService.class);
        serviceConfig.setDelay(0);
        serviceConfig.setRef(this.metadataService);
        serviceConfig.setGroup(applicationConfig.getName());
        serviceConfig.setVersion("1.0.0");
        serviceConfig.setConnections(1);
        serviceConfig.setExecutes(100);
        return serviceConfig;
    }

    public void setMetadataService(MetadataServiceDelegation metadataService) {
        this.metadataService = metadataService;
    }

    public List<URL> getExportedURLs() {
        return this.serviceConfig != null ? this.serviceConfig.getExportedUrls() : Collections.emptyList();
    }
}

