/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.hessian2.dubbo.Hessian2FactoryInitializer;

public class Hessian2ObjectOutput
implements ObjectOutput,
Cleanable {
    private final Hessian2Output mH2o;

    public Hessian2ObjectOutput(OutputStream os) {
        this.mH2o = new Hessian2Output(os);
        this.mH2o.setSerializerFactory(Hessian2FactoryInitializer.getInstance().getSerializerFactory());
    }

    @Override
    public void writeBool(boolean v) throws IOException {
        this.mH2o.writeBoolean(v);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.mH2o.writeInt(v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.mH2o.writeInt(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.mH2o.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.mH2o.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.mH2o.writeDouble(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.mH2o.writeDouble(v);
    }

    @Override
    public void writeBytes(byte[] b) throws IOException {
        this.mH2o.writeBytes(b);
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.mH2o.writeBytes(b, off, len);
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.mH2o.writeString(v);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.mH2o.writeObject(obj);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.mH2o.flushBuffer();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mH2o.getBytesOutputStream();
    }

    @Override
    public void cleanup() {
        if (this.mH2o != null) {
            this.mH2o.reset();
        }
    }
}

