/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.url.component.URLItemCache;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.Utf8Utils;

public final class URLStrParser {
    public static final String ENCODED_QUESTION_MARK = "%3F";
    public static final String ENCODED_TIMESTAMP_KEY = "timestamp%3D";
    public static final String ENCODED_PID_KEY = "pid%3D";
    public static final String ENCODED_AND_MARK = "%26";
    private static final char SPACE = ' ';
    private static final ThreadLocal<TempBuf> DECODE_TEMP_BUF = ThreadLocal.withInitial(() -> new TempBuf(1024));

    private URLStrParser() {
    }

    public static URL parseDecodedStr(String decodedURLStr) {
        Map<String, String> parameters = null;
        int pathEndIdx = decodedURLStr.indexOf(63);
        if (pathEndIdx >= 0) {
            parameters = URLStrParser.parseDecodedParams(decodedURLStr, pathEndIdx + 1);
        } else {
            pathEndIdx = decodedURLStr.length();
        }
        String decodedBody = decodedURLStr.substring(0, pathEndIdx);
        return URLStrParser.parseURLBody(decodedURLStr, decodedBody, parameters);
    }

    private static Map<String, String> parseDecodedParams(String str, int from) {
        int i;
        int len = str.length();
        if (from >= len) {
            return Collections.emptyMap();
        }
        TempBuf tempBuf = DECODE_TEMP_BUF.get();
        HashMap<String, String> params = new HashMap<String, String>();
        int nameStart = from;
        int valueStart = -1;
        block4: for (i = from; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        continue block4;
                    }
                    if (valueStart >= nameStart) continue block4;
                    valueStart = i + 1;
                    continue block4;
                }
                case '&': 
                case ';': {
                    URLStrParser.addParam(str, false, nameStart, valueStart, i, params, tempBuf);
                    nameStart = i + 1;
                    continue block4;
                }
            }
        }
        URLStrParser.addParam(str, false, nameStart, valueStart, i, params, tempBuf);
        return params;
    }

    private static URL parseURLBody(String fullURLStr, String decodedBody, Map<String, String> parameters) {
        int starIdx = 0;
        int endIdx = decodedBody.length();
        int poundIndex = decodedBody.indexOf(35);
        if (poundIndex != -1) {
            endIdx = poundIndex;
        }
        String protocol = null;
        int protoEndIdx = decodedBody.indexOf("://");
        if (protoEndIdx >= 0) {
            if (protoEndIdx == 0) {
                throw new IllegalStateException("url missing protocol: \"" + fullURLStr + "\"");
            }
            protocol = decodedBody.substring(0, protoEndIdx);
            starIdx = protoEndIdx + 3;
        } else {
            protoEndIdx = decodedBody.indexOf(":/");
            if (protoEndIdx >= 0) {
                if (protoEndIdx == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + fullURLStr + "\"");
                }
                protocol = decodedBody.substring(0, protoEndIdx);
                starIdx = protoEndIdx + 1;
            }
        }
        String path = null;
        int pathStartIdx = URLStrParser.indexOf(decodedBody, '/', starIdx, endIdx);
        if (pathStartIdx >= 0) {
            path = decodedBody.substring(pathStartIdx + 1, endIdx);
            endIdx = pathStartIdx;
        }
        String username = null;
        String password = null;
        int pwdEndIdx = URLStrParser.lastIndexOf(decodedBody, '@', starIdx, endIdx);
        if (pwdEndIdx > 0) {
            int passwordStartIdx = URLStrParser.indexOf(decodedBody, ':', starIdx, pwdEndIdx);
            if (passwordStartIdx != -1) {
                username = decodedBody.substring(starIdx, passwordStartIdx);
                password = decodedBody.substring(passwordStartIdx + 1, pwdEndIdx);
            } else {
                username = decodedBody.substring(starIdx, pwdEndIdx);
            }
            starIdx = pwdEndIdx + 1;
        }
        String host = null;
        int port = 0;
        int hostEndIdx = URLStrParser.lastIndexOf(decodedBody, ':', starIdx, endIdx);
        if (hostEndIdx > 0 && hostEndIdx < decodedBody.length() - 1 && URLStrParser.lastIndexOf(decodedBody, '%', starIdx, endIdx) <= hostEndIdx) {
            port = Integer.parseInt(decodedBody.substring(hostEndIdx + 1, endIdx));
            endIdx = hostEndIdx;
        }
        if (endIdx > starIdx) {
            host = decodedBody.substring(starIdx, endIdx);
        }
        protocol = URLItemCache.intern(protocol);
        path = URLItemCache.checkPath(path);
        return new ServiceConfigURL(protocol, username, password, host, port, path, parameters);
    }

    public static String[] parseRawURLToArrays(String rawURLStr, int pathEndIdx) {
        String[] parts = new String[2];
        int paramStartIdx = pathEndIdx + 3;
        if (pathEndIdx == -1) {
            pathEndIdx = rawURLStr.indexOf(63);
            if (pathEndIdx == -1) {
                rawURLStr = URL.decode(rawURLStr);
            } else {
                paramStartIdx = pathEndIdx + 1;
            }
        }
        if (pathEndIdx >= 0) {
            parts[0] = rawURLStr.substring(0, pathEndIdx);
            parts[1] = rawURLStr.substring(paramStartIdx);
        } else {
            parts = new String[]{rawURLStr};
        }
        return parts;
    }

    public static Map<String, String> parseParams(String rawParams, boolean encoded) {
        if (encoded) {
            return URLStrParser.parseEncodedParams(rawParams, 0);
        }
        return URLStrParser.parseDecodedParams(rawParams, 0);
    }

    public static URL parseEncodedStr(String encodedURLStr) {
        Map<String, String> parameters = null;
        int pathEndIdx = encodedURLStr.toUpperCase().indexOf(ENCODED_QUESTION_MARK);
        if (pathEndIdx >= 0) {
            parameters = URLStrParser.parseEncodedParams(encodedURLStr, pathEndIdx + 3);
        } else {
            pathEndIdx = encodedURLStr.length();
        }
        String decodedBody = URLStrParser.decodeComponent(encodedURLStr, 0, pathEndIdx, false, DECODE_TEMP_BUF.get());
        return URLStrParser.parseURLBody(encodedURLStr, decodedBody, parameters);
    }

    private static Map<String, String> parseEncodedParams(String str, int from) {
        int i;
        int len = str.length();
        if (from >= len) {
            return Collections.emptyMap();
        }
        TempBuf tempBuf = DECODE_TEMP_BUF.get();
        HashMap<String, String> params = new HashMap<String, String>();
        int nameStart = from;
        int valueStart = -1;
        block4: for (i = from; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '%') {
                if (i + 3 > len) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i + " of: " + str);
                }
                ch = (char)StringUtils.decodeHexByte(str, i + 1);
                i += 2;
            }
            switch (ch) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        continue block4;
                    }
                    if (valueStart >= nameStart) continue block4;
                    valueStart = i + 1;
                    continue block4;
                }
                case '&': 
                case ';': {
                    URLStrParser.addParam(str, true, nameStart, valueStart, i - 2, params, tempBuf);
                    nameStart = i + 1;
                    continue block4;
                }
            }
        }
        URLStrParser.addParam(str, true, nameStart, valueStart, i, params, tempBuf);
        return params;
    }

    private static boolean addParam(String str, boolean isEncoded, int nameStart, int valueStart, int valueEnd, Map<String, String> params, TempBuf tempBuf) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        if (isEncoded) {
            String name = URLStrParser.decodeComponent(str, nameStart, valueStart - 3, false, tempBuf);
            String value = valueStart >= valueEnd ? name : URLStrParser.decodeComponent(str, valueStart, valueEnd, false, tempBuf);
            URLItemCache.putParams(params, name, value);
            if (name.startsWith("default.")) {
                params.putIfAbsent(name.substring("default.".length()), value);
            }
        } else {
            String name = str.substring(nameStart, valueStart - 1);
            String value = valueStart >= valueEnd ? name : str.substring(valueStart, valueEnd);
            URLItemCache.putParams(params, name, value);
            if (name.startsWith("default.")) {
                params.putIfAbsent(name.substring("default.".length()), value);
            }
        }
        return true;
    }

    private static String decodeComponent(String s, int from, int toExcluded, boolean isPath, TempBuf tempBuf) {
        int len = toExcluded - from;
        if (len <= 0) {
            return "";
        }
        int firstEscaped = -1;
        for (int i = from; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%' && (c != '+' || isPath)) continue;
            firstEscaped = i;
            break;
        }
        if (firstEscaped == -1) {
            return s.substring(from, toExcluded);
        }
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        byte[] buf = tempBuf.byteBuf(decodedCapacity);
        char[] charBuf = tempBuf.charBuf(len);
        s.getChars(from, firstEscaped, charBuf, 0);
        int charBufIdx = firstEscaped - from;
        return URLStrParser.decodeUtf8Component(s, firstEscaped, toExcluded, isPath, buf, charBuf, charBufIdx);
    }

    private static String decodeUtf8Component(String str, int firstEscaped, int toExcluded, boolean isPath, byte[] buf, char[] charBuf, int charBufIdx) {
        for (int i = firstEscaped; i < toExcluded; ++i) {
            int c = str.charAt(i);
            if (c != 37) {
                charBuf[charBufIdx++] = c != 43 || isPath ? c : 32;
                continue;
            }
            int bufIdx = 0;
            do {
                if (i + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i + " of: " + str);
                }
                buf[bufIdx++] = StringUtils.decodeHexByte(str, i + 1);
            } while ((i += 3) < toExcluded && str.charAt(i) == '%');
            --i;
            charBufIdx += Utf8Utils.decodeUtf8(buf, 0, bufIdx, charBuf, charBufIdx);
        }
        return new String(charBuf, 0, charBufIdx);
    }

    private static int indexOf(String str, char ch, int from, int toExclude) {
        if ((from = Math.max(from, 0)) > (toExclude = Math.min(toExclude, str.length()))) {
            return -1;
        }
        for (int i = from; i < toExclude; ++i) {
            if (str.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(String str, char ch, int from, int toExclude) {
        if ((from = Math.max(from, 0)) > (toExclude = Math.min(toExclude, str.length() - 1))) {
            return -1;
        }
        for (int i = toExclude; i >= from; --i) {
            if (str.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static final class TempBuf {
        private final char[] chars;
        private final byte[] bytes;

        TempBuf(int bufSize) {
            this.chars = new char[bufSize];
            this.bytes = new byte[bufSize];
        }

        public char[] charBuf(int size) {
            char[] chars = this.chars;
            if (size <= chars.length) {
                return chars;
            }
            return new char[size];
        }

        public byte[] byteBuf(int size) {
            byte[] bytes = this.bytes;
            if (size <= bytes.length) {
                return bytes;
            }
            return new byte[size];
        }
    }
}

