/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.file.CodecFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public abstract class AvroOutputFormatBase<K, V>
extends FileOutputFormat<K, V> {
    protected static CodecFactory getCompressionCodec(TaskAttemptContext context) {
        if (FileOutputFormat.getCompressOutput((JobContext)context)) {
            String outputCodec = context.getConfiguration().get("avro.output.codec", "deflate");
            if ("deflate".equals(outputCodec)) {
                int compressionLevel = context.getConfiguration().getInt("avro.mapred.deflate.level", 1);
                return CodecFactory.deflateCodec((int)compressionLevel);
            }
            return CodecFactory.fromString((String)outputCodec);
        }
        return CodecFactory.nullCodec();
    }

    protected OutputStream getAvroFileOutputStream(TaskAttemptContext context) throws IOException {
        Path path = new Path(((FileOutputCommitter)this.getOutputCommitter(context)).getWorkPath(), AvroOutputFormatBase.getUniqueFile((TaskAttemptContext)context, (String)context.getConfiguration().get("avro.mo.config.namedOutput", "part"), (String)".avro"));
        return path.getFileSystem(context.getConfiguration()).create(path);
    }
}

