/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.handlers;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.requestcycle.UserAction;
import net.fckeditor.requestcycle.UserPathBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCycleHandler {
    private static Logger logger;
    private static UserAction userAction;
    private static UserPathBuilder userPathBuilder;

    public static boolean isEnabledForFileBrowsing(HttpServletRequest servletRequest) {
        return userAction != null && userAction.isEnabledForFileBrowsing(servletRequest);
    }

    public static boolean isEnabledForFileUpload(HttpServletRequest request) {
        return userAction != null && userAction.isEnabledForFileUpload(request);
    }

    protected static String getUserFilePath(HttpServletRequest request) {
        return userPathBuilder != null ? userPathBuilder.getUserFilesPath(request) : null;
    }

    static {
        Class<?> clazz;
        logger = LoggerFactory.getLogger((Class)RequestCycleHandler.class);
        userAction = null;
        userPathBuilder = null;
        String fqcn = PropertiesLoader.getProperty("connector.userActionImpl");
        if (fqcn == null) {
            logger.warn("No property found for UserAction implementation, any user action is disabled!");
        } else {
            try {
                clazz = Class.forName(fqcn);
                userAction = (UserAction)clazz.newInstance();
                logger.info("UserAction object successful instanciated!");
            }
            catch (Exception e) {
                logger.error("Couldn't instanciate the class [".concat(fqcn).concat("], any user action of the ConnectorServlet is disabled!"), (Throwable)e);
            }
        }
        fqcn = PropertiesLoader.getProperty("connector.userPathBuilderImpl");
        if (fqcn == null) {
            logger.warn("No property found for UserPathBuilder implementation! ".concat("The default of users's 'BaseDir' will be used in the ConnectorServlet!"));
        } else {
            try {
                clazz = Class.forName(fqcn);
                userPathBuilder = (UserPathBuilder)clazz.newInstance();
                logger.info("UserPathBuilder object successfull instanciated!");
            }
            catch (Exception e) {
                logger.error("Couldn't instanciate the class [".concat(fqcn).concat("], The default of users's 'BaseDir' will be used in the ConnectorServlet!"), (Throwable)e);
            }
        }
    }
}

