/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Preconditions;
import me.hao0.common.util.Strings;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.model.qrcode.Qrcode;
import me.hao0.wechat.model.qrcode.QrcodeType;

public final class QrCodes
extends Component {
    private static final String TICKET_GET = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=";
    private static final String SHOW_QRCODE = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=";
    private static final String LONG_TO_SHORT = "https://api.weixin.qq.com/cgi-bin/shorturl?access_token=";

    QrCodes() {
    }

    public String getTempQrcode(String sceneId, Integer expire) {
        return this.getTempQrcode(this.loadAccessToken(), sceneId, expire);
    }

    public void getTempQrcode(String sceneId, Integer expire, Callback<String> cb) {
        this.getTempQrcode(this.loadAccessToken(), sceneId, expire, cb);
    }

    public void getTempQrcode(final String accessToken, final String sceneId, final Integer expire, Callback<String> cb) {
        this.doAsync(new AsyncFunction<String>(cb){

            @Override
            public String execute() {
                return QrCodes.this.getTempQrcode(accessToken, sceneId, expire);
            }
        });
    }

    public String getTempQrcode(String accessToken, String sceneId, Integer expire) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)sceneId, (String)"sceneId");
        Preconditions.checkArgument((expire != null && expire > 0 ? 1 : 0) != 0, (Object)"expire must > 0");
        String url = TICKET_GET + accessToken;
        Map<String, Object> params = this.buildQrcodeParams(sceneId, null, QrcodeType.QR_SCENE);
        params.put("expire_seconds", expire);
        Map<String, Object> resp = this.doPost(url, params);
        Qrcode qr = (Qrcode)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), Qrcode.class);
        return this.showQrcode(qr.getTicket());
    }

    public String getPermQrcode(String sceneId) {
        return this.getPermQrcode(this.loadAccessToken(), sceneId);
    }

    public void getPermQrcode(String sceneId, Callback<String> cb) {
        this.getPermQrcode(this.loadAccessToken(), sceneId, cb);
    }

    public void getPermQrcode(final String accessToken, final String sceneId, Callback<String> cb) {
        this.doAsync(new AsyncFunction<String>(cb){

            @Override
            public String execute() {
                return QrCodes.this.getPermQrcode(accessToken, sceneId);
            }
        });
    }

    public String getPermQrcode(String accessToken, String sceneId) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)sceneId, (String)"sceneId");
        String url = TICKET_GET + accessToken;
        Map<String, Object> params = this.buildQrcodeParams(sceneId, null, QrcodeType.QR_LIMIT_SCENE);
        Map<String, Object> resp = this.doPost(url, params);
        Qrcode qr = (Qrcode)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), Qrcode.class);
        return this.showQrcode(qr.getTicket());
    }

    public String getPermQrcodeBySceneStr(String sceneStr) {
        return this.getPermQrcodeBySceneStr(this.loadAccessToken(), sceneStr);
    }

    public void getPermQrcodeBySceneStr(String sceneStr, Callback<String> cb) {
        this.getPermQrcodeBySceneStr(this.loadAccessToken(), sceneStr, cb);
    }

    public void getPermQrcodeBySceneStr(final String accessToken, final String sceneStr, Callback<String> cb) {
        this.doAsync(new AsyncFunction<String>(cb){

            @Override
            public String execute() {
                return QrCodes.this.getPermQrcodeBySceneStr(accessToken, sceneStr);
            }
        });
    }

    public String getPermQrcodeBySceneStr(String accessToken, String sceneStr) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)sceneStr, (String)"sceneStr");
        String url = TICKET_GET + accessToken;
        Map<String, Object> params = this.buildQrcodeParams(null, sceneStr, QrcodeType.QR_LIMIT_STR_SCENE);
        Map<String, Object> resp = this.doPost(url, params);
        Qrcode qr = (Qrcode)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), Qrcode.class);
        return this.showQrcode(qr.getTicket());
    }

    private Map<String, Object> buildQrcodeParams(String sceneId, String sceneStr, QrcodeType type) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("action_name", type.value());
        HashMap sceneMap = Maps.newHashMapWithExpectedSize((int)1);
        if (!Strings.isNullOrEmpty((String)sceneId).booleanValue()) {
            sceneMap.put("scene_id", sceneId);
        } else if (!Strings.isNullOrEmpty((String)sceneStr).booleanValue()) {
            sceneMap.put("scene_str", sceneStr);
        }
        HashMap scene = Maps.newHashMapWithExpectedSize((int)1);
        scene.put("scene", sceneMap);
        params.put("action_info", scene);
        return params;
    }

    private String showQrcode(String ticket) {
        try {
            return SHOW_QRCODE + URLEncoder.encode(ticket, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WechatException(e);
        }
    }

    public String shortUrl(String longUrl) {
        return this.shortUrl(this.loadAccessToken(), longUrl);
    }

    public void shortUrl(String longUrl, Callback<String> cb) {
        this.shortUrl(longUrl, longUrl, cb);
    }

    public void shortUrl(final String accessToken, final String longUrl, Callback<String> cb) {
        this.doAsync(new AsyncFunction<String>(cb){

            @Override
            public String execute() {
                return QrCodes.this.shortUrl(accessToken, longUrl);
            }
        });
    }

    public String shortUrl(String accessToken, String longUrl) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)longUrl, (String)"longUrl");
        String url = LONG_TO_SHORT + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("action", "long2short");
        params.put("long_url", longUrl);
        Map<String, Object> resp = this.doPost(url, params);
        return (String)resp.get("short_url");
    }
}

