/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.hao0.common.util.Preconditions;
import me.hao0.common.xml.XmlReaders;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.model.message.receive.RecvMessage;
import me.hao0.wechat.model.message.receive.RecvMessageType;
import me.hao0.wechat.model.message.receive.event.RecvEvent;
import me.hao0.wechat.model.message.receive.event.RecvEventType;
import me.hao0.wechat.model.message.receive.event.RecvLocationEvent;
import me.hao0.wechat.model.message.receive.event.RecvMenuEvent;
import me.hao0.wechat.model.message.receive.event.RecvScanEvent;
import me.hao0.wechat.model.message.receive.event.RecvSubscribeEvent;
import me.hao0.wechat.model.message.receive.event.RecvTemplateSendJobFinishEvent;
import me.hao0.wechat.model.message.receive.event.RecvUnSubscribeEvent;
import me.hao0.wechat.model.message.receive.event.RecvUnknownEvent;
import me.hao0.wechat.model.message.receive.msg.RecvImageMessage;
import me.hao0.wechat.model.message.receive.msg.RecvLinkMessage;
import me.hao0.wechat.model.message.receive.msg.RecvLocationMessage;
import me.hao0.wechat.model.message.receive.msg.RecvMsg;
import me.hao0.wechat.model.message.receive.msg.RecvShortVideoMessage;
import me.hao0.wechat.model.message.receive.msg.RecvTextMessage;
import me.hao0.wechat.model.message.receive.msg.RecvVideoMessage;
import me.hao0.wechat.model.message.receive.msg.RecvVoiceMessage;
import me.hao0.wechat.model.message.resp.Article;
import me.hao0.wechat.model.message.resp.RespMessageType;
import me.hao0.wechat.model.message.send.SendMessage;
import me.hao0.wechat.model.message.send.SendMessageScope;
import me.hao0.wechat.model.message.send.SendMessageType;
import me.hao0.wechat.model.message.send.SendPreviewMessage;
import me.hao0.wechat.model.message.send.TemplateField;
import me.hao0.wechat.utils.XmlWriters;

public final class Messages
extends Component {
    private static final String TEMPLATE_SEND = "http://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";
    private static final String SEND_ALL = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall?access_token=";
    private static final String SEND = "https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token=";
    private static final String DELETE_SEND = "https://api.weixin.qq.com/cgi-bin/message/mass/delete?access_token=";
    private static final String PREVIEW_SEND = "https://api.weixin.qq.com/cgi-bin/message/mass/preview?access_token=";
    private static final String GET_SEND = "https://api.weixin.qq.com/cgi-bin/message/mass/get?access_token=";

    Messages() {
    }

    public String respText(RecvMessage recv, String content) {
        Preconditions.checkNotNull((Object)recv, (Object)"recv can't be null");
        Preconditions.checkNotNullAndEmpty((String)content, (String)"content");
        XmlWriters msg = this.respCommonElements(recv, RespMessageType.TEXT);
        msg.element("Content", content);
        return msg.build();
    }

    public String respImage(RecvMessage recv, String mediaId) {
        Preconditions.checkNotNull((Object)recv, (Object)"recv can't be null");
        Preconditions.checkNotNullAndEmpty((String)mediaId, (String)"mediaId");
        XmlWriters msg = this.respCommonElements(recv, RespMessageType.IMAGE);
        msg.element("Image", "MediaId", mediaId);
        return msg.build();
    }

    public String respVoice(RecvMessage recv, String mediaId) {
        Preconditions.checkNotNull((Object)recv, (Object)"recv can't be null");
        Preconditions.checkNotNullAndEmpty((String)mediaId, (String)"mediaId");
        XmlWriters msg = this.respCommonElements(recv, RespMessageType.VOICE);
        msg.element("Voice", "MediaId", mediaId);
        return msg.build();
    }

    public String respVideo(RecvMessage recv, String mediaId, String title, String desc) {
        Preconditions.checkNotNull((Object)recv, (Object)"recv can't be null");
        Preconditions.checkNotNullAndEmpty((String)mediaId, (String)"mediaId");
        XmlWriters msg = this.respCommonElements(recv, RespMessageType.VIDEO);
        msg.element("Video", "MediaId", mediaId, "Title", title, "Description", desc);
        return msg.build();
    }

    public String respMusic(RecvMessage recv, String mediaId, String title, String desc, String url, String hqUrl) {
        Preconditions.checkNotNull((Object)recv, (Object)"recv can't be null");
        Preconditions.checkNotNullAndEmpty((String)mediaId, (String)"mediaId");
        XmlWriters msg = this.respCommonElements(recv, RespMessageType.MUSIC);
        msg.element("Music", "Title", title, "Description", desc, "MusicURL", url, "HQMusicUrl", hqUrl, "ThumbMediaId", mediaId);
        return msg.build();
    }

    public String respNews(RecvMessage recv, List<Article> articles) {
        Preconditions.checkNotNull((Object)recv, (Object)"recv can't be null");
        Preconditions.checkNotNullAndEmpty(articles, (String)"articles");
        Preconditions.checkArgument((articles.size() < 10 ? 1 : 0) != 0, (Object)"articles length must < 10");
        XmlWriters xmlWriters = this.respCommonElements(recv, RespMessageType.NEWS);
        xmlWriters.element("ArticleCount", articles.size());
        ArrayList<XmlWriters.E> items = new ArrayList<XmlWriters.E>();
        for (Article article : articles) {
            XmlWriters.E item = xmlWriters.newElement("item", "Title", article.getTitle(), "Description", article.getDesc(), "PicUrl", article.getPicUrl(), "Url", article.getUrl());
            items.add(item);
        }
        xmlWriters.element("Articles", items);
        return xmlWriters.build();
    }

    private XmlWriters respCommonElements(RecvMessage recv, RespMessageType type) {
        XmlWriters xmlWriters = XmlWriters.create();
        xmlWriters.element("ToUserName", recv.getFromUserName()).element("FromUserName", recv.getToUserName()).element("CreateTime", System.currentTimeMillis() / 1000L).element("MsgType", type.value());
        return xmlWriters;
    }

    public String forward(RecvMessage recv) {
        return this.forward(recv, null);
    }

    public String forward(RecvMessage recv, String kfAccount) {
        Preconditions.checkNotNull((Object)recv, (Object)"recv can't be null");
        XmlWriters xmlWriters = XmlWriters.create();
        xmlWriters.element("ToUserName", recv.getFromUserName()).element("FromUserName", recv.getToUserName()).element("CreateTime", System.currentTimeMillis() / 1000L);
        if (!Strings.isNullOrEmpty((String)kfAccount)) {
            xmlWriters.element("TransInfo", "KfAccount", kfAccount);
        }
        xmlWriters.element("MsgType", RespMessageType.CS.value());
        return xmlWriters.build();
    }

    public RecvMessage receive(String xml) {
        XmlReaders readers = XmlReaders.create((String)xml);
        return this.receiveRecvMessage(readers);
    }

    public RecvMessage receive(InputStream xml) {
        XmlReaders readers = XmlReaders.create((InputStream)xml);
        return this.receiveRecvMessage(readers);
    }

    private RecvMessage receiveRecvMessage(XmlReaders readers) {
        RecvMessage msg = this.parse2RecvMessage(readers);
        RecvMessageType type = RecvMessageType.from(msg.getMsgType());
        if (RecvMessageType.EVENT == type) {
            return this.parse2RecvEvent(readers, msg);
        }
        return this.parse2RecvMsg(readers, msg);
    }

    private RecvMessage parse2RecvMessage(XmlReaders readers) {
        RecvMessage m = new RecvMessage();
        m.setFromUserName(readers.getNodeStr("FromUserName"));
        m.setToUserName(readers.getNodeStr("ToUserName"));
        m.setCreateTime(readers.getNodeInt("CreateTime"));
        m.setMsgType(readers.getNodeStr("MsgType"));
        return m;
    }

    private RecvMessage parse2RecvEvent(XmlReaders readers, RecvMessage msg) {
        String eventValue = readers.getNodeStr("Event");
        RecvEvent event = new RecvEvent(msg);
        event.setEventType(eventValue);
        RecvEventType type = RecvEventType.from(eventValue);
        switch (type) {
            case SUBSCRIBE: {
                RecvSubscribeEvent subscribe = new RecvSubscribeEvent(event);
                subscribe.setEventKey(readers.getNodeStr("EventKey"));
                subscribe.setTicket(readers.getNodeStr("Ticket"));
                return subscribe;
            }
            case UN_SUBSCRIBE: {
                return new RecvUnSubscribeEvent(event);
            }
            case MENU_CLICK: 
            case MENU_VIEW: {
                RecvMenuEvent menu = new RecvMenuEvent(event);
                menu.setEventKey(readers.getNodeStr("EventKey"));
                return menu;
            }
            case LOCATION: {
                RecvLocationEvent location = new RecvLocationEvent(event);
                location.setLatitude(readers.getNodeStr("Latitude"));
                location.setLongitude(readers.getNodeStr("Longitude"));
                location.setPrecision(readers.getNodeStr("Precision"));
                return location;
            }
            case SCAN: {
                RecvScanEvent scan = new RecvScanEvent(event);
                scan.setEventKey(readers.getNodeStr("EventKey"));
                scan.setTicket(readers.getNodeStr("Ticket"));
                return scan;
            }
            case TEMPLATE_SEND_JOB_FINISH: {
                RecvTemplateSendJobFinishEvent send = new RecvTemplateSendJobFinishEvent(event);
                send.setStatus(readers.getNodeStr("Status"));
                return send;
            }
            case UNKNOW: {
                return new RecvUnknownEvent(event);
            }
        }
        throw new IllegalArgumentException("unknown event msg");
    }

    private RecvMessage parse2RecvMsg(XmlReaders readers, RecvMessage message) {
        RecvMessageType type = RecvMessageType.from(message.getMsgType());
        RecvMsg msg = new RecvMsg(message);
        msg.setMsgId(readers.getNodeLong("MsgId"));
        switch (type) {
            case TEXT: {
                RecvTextMessage text = new RecvTextMessage(msg);
                text.setContent(readers.getNodeStr("Content"));
                return text;
            }
            case IMAGE: {
                RecvImageMessage image = new RecvImageMessage(msg);
                image.setPicUrl(readers.getNodeStr("PicUrl"));
                image.setMediaId(readers.getNodeStr("MediaId"));
                return image;
            }
            case VOICE: {
                RecvVoiceMessage voice = new RecvVoiceMessage(msg);
                voice.setFormat(readers.getNodeStr("Format"));
                voice.setMediaId(readers.getNodeStr("MediaId"));
                voice.setRecognition(readers.getNodeStr("Recognition"));
                return voice;
            }
            case VIDEO: {
                RecvVideoMessage video = new RecvVideoMessage(msg);
                video.setMediaId(readers.getNodeStr("MediaId"));
                video.setThumbMediaId(readers.getNodeStr("ThumbMediaId"));
                return video;
            }
            case SHORT_VIDEO: {
                RecvShortVideoMessage svideo = new RecvShortVideoMessage(msg);
                svideo.setMediaId(readers.getNodeStr("MediaId"));
                svideo.setThumbMediaId(readers.getNodeStr("ThumbMediaId"));
                return svideo;
            }
            case LINK: {
                RecvLinkMessage link = new RecvLinkMessage(msg);
                link.setTitle(readers.getNodeStr("Title"));
                link.setDescription(readers.getNodeStr("Description"));
                link.setUrl(readers.getNodeStr("Url"));
                return link;
            }
            case LOCATION: {
                RecvLocationMessage location = new RecvLocationMessage(msg);
                location.setLabel(readers.getNodeStr("Label"));
                location.setLocationX(readers.getNodeStr("LocationX"));
                location.setLocationY(readers.getNodeStr("LocationY"));
                location.setScale(readers.getNodeInt("Scale"));
                return location;
            }
        }
        throw new IllegalArgumentException("unknown msg type");
    }

    public Long sendTemplate(String openId, String templateId, List<TemplateField> fields) {
        return this.sendTemplate(this.loadAccessToken(), openId, templateId, null, fields);
    }

    public Long sendTemplate(String accessToken, String openId, String templateId, List<TemplateField> fields) {
        return this.sendTemplate(accessToken, openId, templateId, null, fields);
    }

    public Long sendTemplate(String openId, String templateId, List<TemplateField> fields, String link) {
        return this.sendTemplate(this.loadAccessToken(), openId, templateId, link, fields);
    }

    public void sendTemplate(String openId, String templateId, List<TemplateField> fields, Callback<Long> cb) {
        this.sendTemplate(this.loadAccessToken(), openId, templateId, null, fields, cb);
    }

    public void sendTemplate(String openId, String templateId, String link, List<TemplateField> fields, Callback<Long> cb) {
        this.sendTemplate(this.loadAccessToken(), openId, templateId, link, fields, cb);
    }

    public void sendTemplate(final String accessToken, final String openId, final String templateId, final String link, final List<TemplateField> fields, Callback<Long> cb) {
        this.doAsync(new AsyncFunction<Long>(cb){

            @Override
            public Long execute() {
                return Messages.this.sendTemplate(accessToken, openId, templateId, link, fields);
            }
        });
    }

    public Long sendTemplate(String accessToken, String openId, String templateId, String link, List<TemplateField> fields) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)openId, (String)"openId");
        Preconditions.checkNotNullAndEmpty((String)templateId, (String)"templateId");
        String url = TEMPLATE_SEND + accessToken;
        Map<String, Object> params = this.buildTemplateParams(openId, templateId, link, fields);
        Map<String, Object> resp = this.doPost(url, params);
        Object msgId = resp.get("msgid");
        return msgId instanceof Long ? ((Long)msgId).longValue() : ((Integer)msgId).longValue();
    }

    private Map<String, Object> buildTemplateParams(String openId, String templateId, String link, List<TemplateField> fields) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("touser", openId);
        params.put("template_id", templateId);
        if (!Strings.isNullOrEmpty((String)link)) {
            params.put("url", link);
        }
        if (fields != null && !fields.isEmpty()) {
            HashMap data = Maps.newHashMapWithExpectedSize((int)fields.size());
            for (TemplateField field : fields) {
                HashMap dataItem = Maps.newHashMapWithExpectedSize((int)2);
                dataItem.put("value", field.getValue());
                dataItem.put("color", field.getColor());
                data.put(field.getName(), dataItem);
            }
            params.put("data", data);
        }
        return params;
    }

    public Long send(SendMessage msg) {
        return this.send(this.loadAccessToken(), msg);
    }

    public void send(SendMessage msg, Callback<Long> cb) {
        this.send(this.loadAccessToken(), msg, cb);
    }

    public void send(final String accessToken, final SendMessage msg, Callback<Long> cb) {
        this.doAsync(new AsyncFunction<Long>(cb){

            @Override
            public Long execute() {
                return Messages.this.send(accessToken, msg);
            }
        });
    }

    public Long send(String accessToken, SendMessage msg) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNull((Object)msg, (Object)"msg can't be null");
        String url = (SendMessageScope.GROUP == msg.getScope() ? SEND_ALL : SEND) + accessToken;
        Map<String, Object> params = this.buildSendParams(msg);
        Map<String, Object> resp = this.doPost(url, params);
        Object msgId = resp.get("msg_id");
        return msgId instanceof Long ? ((Long)msgId).longValue() : ((Integer)msgId).longValue();
    }

    private Map<String, Object> buildSendParams(SendMessage msg) {
        HashMap params = Maps.newHashMap();
        if (SendMessageScope.GROUP == msg.getScope()) {
            HashMap scope = Maps.newHashMapWithExpectedSize((int)2);
            scope.put("is_to_all", msg.getIsToAll());
            scope.put("group_id", msg.getGroupId());
            params.put("filter", scope);
        } else {
            params.put("touser", msg.getOpenIds());
        }
        HashMap msgContent = Maps.newHashMapWithExpectedSize((int)1);
        if (SendMessageType.TEXT == msg.getType()) {
            msgContent.put("content", msg.getContent());
        } else if (SendMessageType.CARD == msg.getType()) {
            msgContent.put("card_id", msg.getCardId());
        } else {
            msgContent.put("media_id", msg.getMediaId());
        }
        params.put(msg.getType().value(), msgContent);
        params.put("msgtype", msg.getType().value());
        if (!Strings.isNullOrEmpty((String)msg.getTitle())) {
            params.put("title", msg.getTitle());
        }
        if (!Strings.isNullOrEmpty((String)msg.getDescription())) {
            params.put("description", msg.getDescription());
        }
        if (!Strings.isNullOrEmpty((String)msg.getThumbMediaId())) {
            params.put("thumb_media_id", msg.getThumbMediaId());
        }
        return params;
    }

    public Boolean previewSend(SendPreviewMessage msg) {
        return this.previewSend(this.loadAccessToken(), msg);
    }

    public void previewSend(SendPreviewMessage msg, Callback<Boolean> cb) {
        this.previewSend(this.loadAccessToken(), msg, cb);
    }

    public void previewSend(final String accessToken, final SendPreviewMessage msg, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Messages.this.previewSend(accessToken, msg);
            }
        });
    }

    public Boolean previewSend(String accessToken, SendPreviewMessage msg) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNull((Object)msg, (Object)"msg can't be null");
        String url = PREVIEW_SEND + accessToken;
        Map<String, Object> params = this.buildPreviewParams(msg);
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    private Map<String, Object> buildPreviewParams(SendPreviewMessage msg) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("touser", msg.getOpenId());
        HashMap msgContent = Maps.newHashMapWithExpectedSize((int)1);
        if (SendMessageType.TEXT == msg.getType()) {
            msgContent.put("content", msg.getContent());
        } else if (SendMessageType.CARD == msg.getType()) {
            msgContent.put("card_id", msg.getCardId());
        } else {
            msgContent.put("media_id", msg.getMediaId());
        }
        params.put(msg.getType().value(), msgContent);
        params.put("msgtype", msg.getType().value());
        return params;
    }

    public Boolean deleteSend(Long id) {
        return this.deleteSend(this.loadAccessToken(), id);
    }

    public void deleteSend(Long id, Callback<Boolean> cb) {
        this.deleteSend(this.loadAccessToken(), id, cb);
    }

    public void deleteSend(final String accessToken, final Long id, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Messages.this.deleteSend(accessToken, id);
            }
        });
    }

    public Boolean deleteSend(String accessToken, Long id) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkArgument((id != null && id > 0L ? 1 : 0) != 0, (Object)"id must be > 0");
        String url = DELETE_SEND + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("msg_id", id);
        this.doPost(url, params);
        return Boolean.TRUE;
    }

    public String getSend(Long id) {
        return this.getSend(this.loadAccessToken(), id);
    }

    public void getSend(Long id, Callback<String> cb) {
        this.getSend(this.loadAccessToken(), id, cb);
    }

    public void getSend(final String accessToken, final Long id, Callback<String> cb) {
        this.doAsync(new AsyncFunction<String>(cb){

            @Override
            public String execute() {
                return Messages.this.getSend(accessToken, id);
            }
        });
    }

    public String getSend(String accessToken, Long id) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkArgument((id != null && id > 0L ? 1 : 0) != 0, (Object)"id must be > 0");
        String url = GET_SEND + accessToken;
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("msg_id", id);
        Map<String, Object> resp = this.doPost(url, params);
        return (String)resp.get("msg_status");
    }
}

