/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import me.hao0.common.json.Jsons;
import me.hao0.wechat.model.menu.Menu;
import me.hao0.wechat.model.menu.MenuType;

public final class MenuBuilder {
    @JsonProperty(value="button")
    private List<Menu> menus = new ArrayList<Menu>();

    private MenuBuilder() {
    }

    public static MenuBuilder newBuilder() {
        return new MenuBuilder();
    }

    public MenuBuilder menu(Menu m) {
        this.menus.add(m);
        return this;
    }

    public MenuBuilder click(String name, String key) {
        Menu m = this.newClickMenu(name, key);
        this.menus.add(m);
        return this;
    }

    public MenuBuilder click(Menu parent, String name, String key) {
        Menu m = this.newClickMenu(name, key);
        parent.getChildren().add(m);
        return this;
    }

    public MenuBuilder view(String name, String url) {
        Menu m = this.newViewMenu(name, url);
        this.menus.add(m);
        return this;
    }

    public MenuBuilder view(Menu parent, String name, String url) {
        Menu m = this.newViewMenu(name, url);
        parent.getChildren().add(m);
        return this;
    }

    public Menu newViewMenu(String name, String url) {
        Menu m = new Menu();
        m.setName(name);
        m.setType(MenuType.VIEW.value());
        m.setUrl(url);
        return m;
    }

    public Menu newClickMenu(String name, String key) {
        Menu m = new Menu();
        m.setName(name);
        m.setType(MenuType.CLICK.value());
        m.setKey(key);
        return m;
    }

    public Menu newParentMenu(String name) {
        Menu m = new Menu();
        m.setName(name);
        return m;
    }

    public String build() {
        return Jsons.EXCLUDE_EMPTY.toJson((Object)this);
    }
}

