/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Preconditions;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.model.base.AccessToken;
import me.hao0.wechat.model.base.AuthAccessToken;
import me.hao0.wechat.model.base.AuthType;

public final class Bases
extends Component {
    private static final String AUTH_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?";
    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential";
    private static final String AUTH_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?grant_type=authorization_code";
    private static final String WX_IP_URL = "https://api.weixin.qq.com/cgi-bin/getcallbackip?access_token=";

    Bases() {
    }

    public String authUrl(String redirectUrl) {
        return this.authUrl(redirectUrl, Boolean.TRUE);
    }

    public String authUrl(String redirectUrl, Boolean quiet) {
        try {
            Preconditions.checkNotNullAndEmpty((String)redirectUrl, (String)"redirectUrl");
            redirectUrl = URLEncoder.encode(redirectUrl, "utf-8");
            return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + this.wechat.getAppId() + "&redirect_uri=" + redirectUrl + "&response_type=code&scope=" + (quiet != false ? AuthType.BASE.scope() : AuthType.USER_INFO.scope()) + "&state=1#wechat_redirect";
        }
        catch (UnsupportedEncodingException e) {
            throw new WechatException(e);
        }
    }

    public void openId(final String code, Callback<String> cb) {
        this.doAsync(new AsyncFunction<String>(cb){

            @Override
            public String execute() {
                return Bases.this.openId(code);
            }
        });
    }

    public String openId(String code) {
        Preconditions.checkNotNullAndEmpty((String)code, (String)"code");
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?grant_type=authorization_code&appid=" + this.wechat.getAppId() + "&secret=" + this.wechat.getAppSecret() + "&code=" + code;
        Map<String, Object> resp = this.doGet(url);
        return (String)resp.get("openid");
    }

    public void accessToken(Callback<AccessToken> cb) {
        this.doAsync(new AsyncFunction<AccessToken>(cb){

            @Override
            public AccessToken execute() {
                return Bases.this.accessToken();
            }
        });
    }

    public AccessToken accessToken() {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.wechat.getAppId() + "&secret=" + this.wechat.getAppSecret();
        Map<String, Object> resp = this.doGet(url);
        AccessToken token = new AccessToken();
        token.setAccessToken((String)resp.get("access_token"));
        Integer expire = (Integer)resp.get("expires_in");
        token.setExpire(expire);
        token.setExpiredAt(System.currentTimeMillis() + (long)(expire * 1000));
        return token;
    }

    public void authAccessToken(final String code, Callback<AuthAccessToken> cb) {
        this.doAsync(new AsyncFunction<AuthAccessToken>(cb){

            @Override
            public AuthAccessToken execute() {
                return Bases.this.authAccessToken(code);
            }
        });
    }

    public AuthAccessToken authAccessToken(String code) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?grant_type=authorization_code&appid=" + this.wechat.getAppId() + "&secret=" + this.wechat.getAppSecret() + "&code=" + code;
        Map<String, Object> resp = this.doGet(url);
        AuthAccessToken token = (AuthAccessToken)Jsons.DEFAULT.fromJson(Jsons.DEFAULT.toJson(resp), AuthAccessToken.class);
        token.setExpiredAt(System.currentTimeMillis() + (long)(token.getExpire() * 1000));
        return token;
    }

    public List<String> ip() {
        return this.ip(this.loadAccessToken());
    }

    public void ip(Callback<List<String>> cb) {
        this.ip(this.loadAccessToken(), cb);
    }

    public void ip(final String accessToken, Callback<List<String>> cb) {
        this.doAsync(new AsyncFunction<List<String>>(cb){

            @Override
            public List<String> execute() {
                return Bases.this.ip(accessToken);
            }
        });
    }

    public List<String> ip(String accessToken) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        String url = WX_IP_URL + accessToken;
        Map<String, Object> resp = this.doGet(url);
        return (List)resp.get("ip_list");
    }
}

