/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.ErrorParser;
import brave.Tracing;
import brave.grpc.AsciiMetadataKeyFactory;
import brave.grpc.GrpcClientParser;
import brave.grpc.GrpcPropagation;
import brave.grpc.GrpcServerParser;
import brave.grpc.TracingClientInterceptor;
import brave.grpc.TracingServerInterceptor;
import brave.propagation.Propagation;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.ServerInterceptor;

public final class GrpcTracing {
    final Tracing tracing;
    final Propagation<Metadata.Key<String>> propagation;
    final GrpcClientParser clientParser;
    final GrpcServerParser serverParser;
    final boolean grpcPropagationFormatEnabled;

    public static GrpcTracing create(Tracing tracing) {
        if (tracing == null) {
            throw new NullPointerException("tracing == null");
        }
        return new Builder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    GrpcTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.grpcPropagationFormatEnabled = builder.grpcPropagationFormatEnabled;
        Propagation.Factory propagationFactory = this.tracing.propagationFactory();
        if (this.grpcPropagationFormatEnabled) {
            propagationFactory = GrpcPropagation.newFactory(propagationFactory);
        }
        this.propagation = propagationFactory.create((Propagation.KeyFactory)AsciiMetadataKeyFactory.INSTANCE);
        this.clientParser = builder.clientParser;
        this.serverParser = builder.serverParser;
    }

    public Builder toBuilder() {
        return new Builder(this.tracing).clientParser(this.clientParser).serverParser(this.serverParser);
    }

    public final ClientInterceptor newClientInterceptor() {
        return new TracingClientInterceptor(this);
    }

    public ServerInterceptor newServerInterceptor() {
        return new TracingServerInterceptor(this);
    }

    public static final class Builder {
        final Tracing tracing;
        GrpcClientParser clientParser;
        GrpcServerParser serverParser;
        boolean grpcPropagationFormatEnabled = false;

        Builder(Tracing tracing) {
            this.tracing = tracing;
            final ErrorParser errorParser = tracing.errorParser();
            this.clientParser = new GrpcClientParser(){

                @Override
                protected ErrorParser errorParser() {
                    return errorParser;
                }
            };
            this.serverParser = new GrpcServerParser(){

                @Override
                protected ErrorParser errorParser() {
                    return errorParser;
                }
            };
        }

        public Builder clientParser(GrpcClientParser clientParser) {
            if (clientParser == null) {
                throw new NullPointerException("clientParser == null");
            }
            this.clientParser = clientParser;
            return this;
        }

        public Builder serverParser(GrpcServerParser serverParser) {
            if (serverParser == null) {
                throw new NullPointerException("serverParser == null");
            }
            this.serverParser = serverParser;
            return this;
        }

        public Builder grpcPropagationFormatEnabled(boolean grpcPropagationFormatEnabled) {
            this.grpcPropagationFormatEnabled = grpcPropagationFormatEnabled;
            return this;
        }

        public GrpcTracing build() {
            return new GrpcTracing(this);
        }
    }
}

