/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Tracer;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalSpan;
import brave.propagation.TraceContext;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class StrictScopeDecorator
implements CurrentTraceContext.ScopeDecorator,
Closeable {
    final Set<CallerStackTrace> currentCallers = Collections.synchronizedSet(new LinkedHashSet());

    public static StrictScopeDecorator create() {
        return new StrictScopeDecorator();
    }

    @Override
    public CurrentTraceContext.Scope decorateScope(@Nullable TraceContext context, CurrentTraceContext.Scope scope) {
        String className;
        int i;
        if (scope == CurrentTraceContext.Scope.NOOP) {
            return scope;
        }
        CallerStackTrace caller = new CallerStackTrace(context);
        StackTraceElement[] stackTrace = caller.getStackTrace();
        for (i = 1; i < stackTrace.length && ((className = stackTrace[i].getClassName()).equals(Tracer.class.getName()) || className.endsWith("CurrentTraceContext") || className.equals(ThreadLocalSpan.class.getName())); ++i) {
        }
        int from = i;
        stackTrace = Arrays.copyOfRange(stackTrace, from, stackTrace.length);
        caller.setStackTrace(stackTrace);
        return new StrictScope(scope, caller, this.currentCallers);
    }

    @Override
    public void close() {
        int n = 0;
        CallerStackTrace[] leakedCallers = this.currentCallers.toArray(new CallerStackTrace[0]);
        CallerStackTrace[] callerStackTraceArray = leakedCallers;
        int n2 = callerStackTraceArray.length;
        if (n < n2) {
            CallerStackTrace caller = callerStackTraceArray[n];
            AssertionError toThrow = new AssertionError((Object)("Thread [" + caller.threadName + "] opened a scope of " + caller.context + " here:"));
            ((Throwable)((Object)toThrow)).setStackTrace(caller.getStackTrace());
            throw toThrow;
        }
    }

    StrictScopeDecorator() {
    }

    static class CallerStackTrace
    extends Throwable {
        final String threadName = Thread.currentThread().getName();
        final long threadId = Thread.currentThread().getId();
        final TraceContext context;

        CallerStackTrace(@Nullable TraceContext context) {
            super("Thread [" + Thread.currentThread().getName() + "] opened scope for " + context + " here:");
            this.context = context;
        }
    }

    static final class StrictScope
    implements CurrentTraceContext.Scope {
        final CurrentTraceContext.Scope delegate;
        final Set<CallerStackTrace> currentCallers;
        final CallerStackTrace caller;

        StrictScope(CurrentTraceContext.Scope delegate, CallerStackTrace caller, Set<CallerStackTrace> currentCallers) {
            this.delegate = delegate;
            this.currentCallers = currentCallers;
            this.caller = caller;
            this.currentCallers.add(caller);
        }

        @Override
        public void close() {
            this.currentCallers.remove(this.caller);
            if (Thread.currentThread().getId() != this.caller.threadId) {
                throw new IllegalStateException(String.format("Thread [%s] opened scope, but thread [%s] closed it", this.caller.threadName, Thread.currentThread().getName()), this.caller);
            }
            this.delegate.close();
        }

        public String toString() {
            return this.caller.getMessage();
        }
    }
}

