/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import reactor.util.Logger;
import reactor.util.annotation.Nullable;

public class TestLogger
implements Logger {
    private final ByteArrayOutputStream errContent;
    private final ByteArrayOutputStream logContent = new ByteArrayOutputStream();
    private final PrintStream err;
    private final PrintStream log = new PrintStream(this.logContent);

    public TestLogger() {
        this.errContent = new ByteArrayOutputStream();
        this.err = new PrintStream(this.errContent);
    }

    public String getName() {
        return "TestLogger";
    }

    public String getErrContent() {
        return this.errContent.toString();
    }

    public String getOutContent() {
        return this.logContent.toString();
    }

    public void reset() {
        this.errContent.reset();
        this.logContent.reset();
    }

    @Nullable
    private String format(@Nullable String from, Object ... arguments) {
        if (from != null) {
            String computed = from;
            if (arguments != null && arguments.length != 0) {
                for (Object argument : arguments) {
                    computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(argument.toString()));
                }
            }
            return computed;
        }
        return null;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public synchronized void trace(String msg) {
        this.log.format("[TRACE] (%s) %s\n", Thread.currentThread().getName(), msg);
    }

    public synchronized void trace(String format, Object ... arguments) {
        this.log.format("[TRACE] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
    }

    public synchronized void trace(String msg, Throwable t) {
        this.log.format("[TRACE] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
        t.printStackTrace(this.log);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public synchronized void debug(String msg) {
        this.log.format("[DEBUG] (%s) %s\n", Thread.currentThread().getName(), msg);
    }

    public synchronized void debug(String format, Object ... arguments) {
        this.log.format("[DEBUG] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
    }

    public synchronized void debug(String msg, Throwable t) {
        this.log.format("[DEBUG] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
        t.printStackTrace(this.log);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public synchronized void info(String msg) {
        this.log.format("[ INFO] (%s) %s\n", Thread.currentThread().getName(), msg);
    }

    public synchronized void info(String format, Object ... arguments) {
        this.log.format("[ INFO] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
    }

    public synchronized void info(String msg, Throwable t) {
        this.log.format("[ INFO] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
        t.printStackTrace(this.log);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public synchronized void warn(String msg) {
        this.err.format("[ WARN] (%s) %s\n", Thread.currentThread().getName(), msg);
    }

    public synchronized void warn(String format, Object ... arguments) {
        this.err.format("[ WARN] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
    }

    public synchronized void warn(String msg, Throwable t) {
        this.err.format("[ WARN] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
        t.printStackTrace(this.err);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public synchronized void error(String msg) {
        this.err.format("[ERROR] (%s) %s\n", Thread.currentThread().getName(), msg);
    }

    public synchronized void error(String format, Object ... arguments) {
        this.err.format("[ERROR] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
    }

    public synchronized void error(String msg, Throwable t) {
        this.err.format("[ERROR] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
        t.printStackTrace(this.err);
    }
}

