/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Objects;
import io.minio.ObjectReadArgs;
import io.minio.messages.InputSerialization;
import io.minio.messages.OutputSerialization;

public class SelectObjectContentArgs
extends ObjectReadArgs {
    private String sqlExpression;
    private InputSerialization inputSerialization;
    private OutputSerialization outputSerialization;
    private Boolean requestProgress;
    private Long scanStartRange;
    private Long scanEndRange;

    public Long scanEndRange() {
        return this.scanEndRange;
    }

    public Long scanStartRange() {
        return this.scanStartRange;
    }

    public Boolean requestProgress() {
        return this.requestProgress;
    }

    public OutputSerialization outputSerialization() {
        return this.outputSerialization;
    }

    public InputSerialization inputSerialization() {
        return this.inputSerialization;
    }

    public String sqlExpression() {
        return this.sqlExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectObjectContentArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelectObjectContentArgs that = (SelectObjectContentArgs)o;
        return Objects.equal((Object)this.sqlExpression, (Object)that.sqlExpression) && Objects.equal((Object)this.inputSerialization, (Object)that.inputSerialization) && Objects.equal((Object)this.outputSerialization, (Object)that.outputSerialization) && Objects.equal((Object)this.requestProgress, (Object)that.requestProgress) && Objects.equal((Object)this.scanStartRange, (Object)that.scanStartRange) && Objects.equal((Object)this.scanEndRange, (Object)that.scanEndRange);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.sqlExpression, this.inputSerialization, this.outputSerialization, this.requestProgress, this.scanStartRange, this.scanEndRange});
    }

    public static final class Builder
    extends ObjectReadArgs.Builder<Builder, SelectObjectContentArgs> {
        private void validateSqlExpression(String se) {
            this.validateNotEmptyString(se, "sqlExpression");
        }

        public Builder sqlExpression(String sqlExpression) {
            this.validateSqlExpression(sqlExpression);
            this.operations.add(args -> ((SelectObjectContentArgs)args).sqlExpression = sqlExpression);
            return this;
        }

        private void validateInputSerialization(InputSerialization is) {
            this.validateNotNull(is, "inputSerialization");
        }

        public Builder inputSerialization(InputSerialization inputSerialization) {
            this.validateInputSerialization(inputSerialization);
            this.operations.add(args -> ((SelectObjectContentArgs)args).inputSerialization = inputSerialization);
            return this;
        }

        private void validateOutputSerialization(OutputSerialization os) {
            this.validateNotNull(os, "outputSerialization");
        }

        public Builder outputSerialization(OutputSerialization outputSerialization) {
            this.validateOutputSerialization(outputSerialization);
            this.operations.add(args -> ((SelectObjectContentArgs)args).outputSerialization = outputSerialization);
            return this;
        }

        public Builder requestProgress(Boolean requestProgress) {
            this.operations.add(args -> ((SelectObjectContentArgs)args).requestProgress = requestProgress);
            return this;
        }

        public Builder scanStartRange(Long scanStartRange) {
            this.operations.add(args -> ((SelectObjectContentArgs)args).scanStartRange = scanStartRange);
            return this;
        }

        public Builder scanEndRange(Long scanEndRange) {
            this.operations.add(args -> ((SelectObjectContentArgs)args).scanEndRange = scanEndRange);
            return this;
        }

        @Override
        protected void validate(SelectObjectContentArgs args) {
            super.validate(args);
            this.validateSqlExpression(args.sqlExpression());
            this.validateInputSerialization(args.inputSerialization());
            this.validateOutputSerialization(args.outputSerialization());
        }
    }
}

