/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Objects;
import io.minio.ObjectWriteArgs;
import java.io.IOException;

public abstract class PutObjectBaseArgs
extends ObjectWriteArgs {
    protected long objectSize;
    protected long partSize;
    protected int partCount;
    protected String contentType;
    protected boolean preloadData;

    public long objectSize() {
        return this.objectSize;
    }

    public long partSize() {
        return this.partSize;
    }

    public int partCount() {
        return this.partCount;
    }

    public String contentType() throws IOException {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.headers().containsKey((Object)"Content-Type")) {
            return (String)this.headers().get((Object)"Content-Type").iterator().next();
        }
        return null;
    }

    public boolean preloadData() {
        return this.preloadData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutObjectBaseArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutObjectBaseArgs that = (PutObjectBaseArgs)o;
        return this.objectSize == that.objectSize && this.partSize == that.partSize && this.partCount == that.partCount && Objects.equal((Object)this.contentType, (Object)that.contentType) && this.preloadData == that.preloadData;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.objectSize, this.partSize, this.partCount, this.contentType, this.preloadData});
    }

    public static abstract class Builder<B extends Builder<B, A>, A extends PutObjectBaseArgs>
    extends ObjectWriteArgs.Builder<B, A> {
        public B preloadData(boolean preloadData) {
            this.operations.add(args -> {
                args.preloadData = preloadData;
            });
            return (B)this;
        }
    }
}

