/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Objects;
import io.minio.PutObjectBaseArgs;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PutObjectArgs
extends PutObjectBaseArgs {
    private BufferedInputStream stream;

    public BufferedInputStream stream() {
        return this.stream;
    }

    @Override
    public String contentType() throws IOException {
        String contentType = super.contentType();
        return contentType != null ? contentType : "application/octet-stream";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutObjectArgs)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutObjectArgs that = (PutObjectArgs)o;
        return Objects.equal((Object)this.stream, (Object)that.stream);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.stream});
    }

    public static final class Builder
    extends PutObjectBaseArgs.Builder<Builder, PutObjectArgs> {
        @Override
        protected void validate(PutObjectArgs args) {
            super.validate(args);
            this.validateNotNull(args.stream, "stream");
        }

        private void validateSizes(long objectSize, long partSize) {
            if (partSize > 0L) {
                if (partSize < 0x500000L) {
                    throw new IllegalArgumentException("part size " + partSize + " is not supported; minimum allowed 5MiB");
                }
                if (partSize > 0x140000000L) {
                    throw new IllegalArgumentException("part size " + partSize + " is not supported; maximum allowed 5GiB");
                }
            }
            if (objectSize >= 0L) {
                if (objectSize > 0x50000000000L) {
                    throw new IllegalArgumentException("object size " + objectSize + " is not supported; maximum allowed 5TiB");
                }
            } else if (partSize <= 0L) {
                throw new IllegalArgumentException("valid part size must be provided when object size is unknown");
            }
        }

        private void validatePartCount(int partCount, long objectSize, long partSize) {
            if (partCount > 10000) {
                throw new IllegalArgumentException("object size " + objectSize + " and part size " + partSize + " make more than " + 10000 + "parts for upload");
            }
        }

        private long[] partInfo(long objectSize, long partSize) {
            if (objectSize < 0L) {
                return new long[]{partSize, -1L};
            }
            if (partSize > 0L) {
                if (partSize > objectSize) {
                    partSize = objectSize;
                }
                long partCount = partSize > 0L ? (long)Math.ceil((double)objectSize / (double)partSize) : 1L;
                return new long[]{partSize, partCount == 0L ? 1L : partCount};
            }
            double pSize = Math.ceil((double)objectSize / 10000.0);
            pSize = Math.ceil(pSize / 5242880.0) * 5242880.0;
            partSize = (long)pSize;
            long partCount = 1L;
            if (pSize > 0.0) {
                partCount = (long)Math.ceil((double)objectSize / pSize);
            }
            return new long[]{partSize, partCount};
        }

        public Builder stream(InputStream stream, long objectSize, long partSize) {
            this.validateNotNull(stream, "stream");
            this.validateSizes(objectSize, partSize);
            long[] partinfo = this.partInfo(objectSize, partSize);
            long pSize = partinfo[0];
            int pCount = (int)partinfo[1];
            this.validatePartCount(pCount, objectSize, partSize);
            BufferedInputStream bis = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : new BufferedInputStream(stream);
            return this.setStream(bis, objectSize, pSize, pCount);
        }

        private Builder setStream(BufferedInputStream stream, long objectSize, long partSize, int partCount) {
            this.operations.add(args -> ((PutObjectArgs)args).stream = stream);
            this.operations.add(args -> {
                args.objectSize = objectSize;
            });
            this.operations.add(args -> {
                args.partSize = partSize;
            });
            this.operations.add(args -> {
                args.partCount = partCount;
            });
            return this;
        }

        public Builder contentType(String contentType) {
            this.validateNotEmptyString(contentType, "content type");
            this.operations.add(args -> {
                args.contentType = contentType;
            });
            return this;
        }
    }
}

