/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.errors.InvalidArgumentException;
import java.util.LinkedList;
import java.util.List;

public enum EventType {
    OBJECT_CREATED_ANY("s3:ObjectCreated:*"),
    OBJECT_CREATED_PUT("s3:ObjectCreated:Put"),
    OBJECT_CREATED_POST("s3:ObjectCreated:Post"),
    OBJECT_CREATED_COPY("s3:ObjectCreated:Copy"),
    OBJECT_CREATED_COMPLETE_MULTIPART_UPLOAD("s3:ObjectCreated:CompleteMultipartUpload"),
    OBJECT_ACCESSED_GET("s3:ObjectAccessed:Get"),
    OBJECT_ACCESSED_HEAD("s3:ObjectAccessed:Head"),
    OBJECT_ACCESSED_ANY("s3:ObjectAccessed:*"),
    OBJECT_REMOVED_ANY("s3:ObjectRemoved:*"),
    OBJECT_REMOVED_DELETE("s3:ObjectRemoved:Delete"),
    OBJECT_REMOVED_DELETED_MARKER_CREATED("s3:ObjectRemoved:DeleteMarkerCreated"),
    REDUCED_REDUNDANCY_LOST_OBJECT("s3:ReducedRedundancyLostObject");

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static EventType fromString(String eventTypeString) throws InvalidArgumentException {
        for (EventType et : EventType.values()) {
            if (!eventTypeString.equals(et.value)) continue;
            return et;
        }
        throw new InvalidArgumentException("unknown event '" + eventTypeString + "'");
    }

    public static List<EventType> fromStringList(List<String> eventList) throws InvalidArgumentException {
        LinkedList<EventType> eventTypeList = new LinkedList<EventType>();
        for (String event : eventList) {
            eventTypeList.add(EventType.fromString(event));
        }
        return eventTypeList;
    }

    public static List<String> toStringList(List<EventType> eventTypeList) {
        LinkedList<String> events = new LinkedList<String>();
        for (EventType eventType : eventTypeList) {
            events.add(eventType.toString());
        }
        return events;
    }
}

