/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.minio.AwsS3Endpoints;
import io.minio.BucketEventListener;
import io.minio.BucketRegionCache;
import io.minio.ChunkedInputStream;
import io.minio.CopyConditions;
import io.minio.DateFormat;
import io.minio.Digest;
import io.minio.ErrorCode;
import io.minio.HttpRequestBody;
import io.minio.HttpResponse;
import io.minio.MinioProperties;
import io.minio.ObjectStat;
import io.minio.PostPolicy;
import io.minio.ResponseHeader;
import io.minio.Result;
import io.minio.S3Escaper;
import io.minio.ServerSideEncryption;
import io.minio.Signer;
import io.minio.errors.BucketPolicyTooLargeException;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidArgumentException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidExpiresRangeException;
import io.minio.errors.InvalidObjectPrefixException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.NoResponseException;
import io.minio.errors.RegionConflictException;
import io.minio.http.HeaderParser;
import io.minio.http.Method;
import io.minio.http.Scheme;
import io.minio.messages.Bucket;
import io.minio.messages.CompleteMultipartUpload;
import io.minio.messages.CopyObjectResult;
import io.minio.messages.CreateBucketConfiguration;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.DeleteRequest;
import io.minio.messages.DeleteResult;
import io.minio.messages.ErrorResponse;
import io.minio.messages.InitiateMultipartUploadResult;
import io.minio.messages.Item;
import io.minio.messages.ListAllMyBucketsResult;
import io.minio.messages.ListBucketResult;
import io.minio.messages.ListBucketResultV1;
import io.minio.messages.ListMultipartUploadsResult;
import io.minio.messages.ListPartsResult;
import io.minio.messages.NotificationConfiguration;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.Part;
import io.minio.messages.Prefix;
import io.minio.messages.Upload;
import io.minio.notification.NotificationInfo;
import io.minio.org.apache.commons.validator.routines.InetAddressValidator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MinioClient {
    private static final Logger LOGGER = Logger.getLogger(MinioClient.class.getName());
    private static final long DEFAULT_CONNECTION_TIMEOUT = 900L;
    private static final long MAX_OBJECT_SIZE = 0x50000000000L;
    private static final int MAX_MULTIPART_COUNT = 10000;
    private static final int MIN_MULTIPART_SIZE = 0x500000;
    private static final int MAX_BUCKET_POLICY_SIZE = 12288;
    private static final int DEFAULT_EXPIRY_TIME = 604800;
    private static final String DEFAULT_USER_AGENT = "MinIO (" + System.getProperty("os.arch") + "; " + System.getProperty("os.arch") + ") minio-java/" + MinioProperties.INSTANCE.getVersion();
    private static final String NULL_STRING = "(null)";
    private static final String S3_AMAZONAWS_COM = "s3.amazonaws.com";
    private static final String END_HTTP = "----------END-HTTP----------";
    private static final String US_EAST_1 = "us-east-1";
    private static final String UPLOAD_ID = "uploadId";
    private static XmlPullParserFactory xmlPullParserFactory = null;
    private static final Set<String> amzHeaders = new HashSet<String>();
    private static final Set<String> standardHeaders;
    private PrintWriter traceStream;
    private HttpUrl baseUrl;
    private String accessKey;
    private String secretKey;
    private String region;
    private String userAgent = DEFAULT_USER_AGENT;
    private OkHttpClient httpClient;

    public MinioClient(String endpoint) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, null, null);
    }

    public MinioClient(URL url) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, null, null);
    }

    public MinioClient(HttpUrl url) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, null, null);
    }

    public MinioClient(String endpoint, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, accessKey, secretKey);
    }

    public MinioClient(String endpoint, String accessKey, String secretKey, String region) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, accessKey, secretKey, region, endpoint == null || !endpoint.startsWith("http://"));
    }

    public MinioClient(URL url, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, accessKey, secretKey);
    }

    public MinioClient(HttpUrl url, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(url.toString(), 0, accessKey, secretKey);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, port, accessKey, secretKey, endpoint == null || !endpoint.startsWith("http://"));
    }

    public MinioClient(String endpoint, String accessKey, String secretKey, boolean secure) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, 0, accessKey, secretKey, secure);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey, boolean secure) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, port, accessKey, secretKey, null, secure);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey, String region, boolean secure) throws InvalidEndpointException, InvalidPortException {
        this(endpoint, port, accessKey, secretKey, region, secure, null);
    }

    public MinioClient(String endpoint, int port, String accessKey, String secretKey, String region, boolean secure, OkHttpClient httpClient) throws InvalidEndpointException, InvalidPortException {
        if (endpoint == null) {
            throw new InvalidEndpointException(NULL_STRING, "null endpoint");
        }
        if (port < 0 || port > 65535) {
            throw new InvalidPortException(port, "port must be in range of 1 to 65535");
        }
        if (httpClient != null) {
            this.httpClient = httpClient;
        } else {
            LinkedList<Protocol> protocol = new LinkedList<Protocol>();
            protocol.add(Protocol.HTTP_1_1);
            this.httpClient = new OkHttpClient();
            this.httpClient = this.httpClient.newBuilder().connectTimeout(900L, TimeUnit.SECONDS).writeTimeout(900L, TimeUnit.SECONDS).readTimeout(900L, TimeUnit.SECONDS).protocols(protocol).build();
        }
        HttpUrl url = HttpUrl.parse((String)endpoint);
        if (url != null) {
            if (!"/".equals(url.encodedPath())) {
                throw new InvalidEndpointException(endpoint, "no path allowed in endpoint");
            }
            HttpUrl.Builder urlBuilder = url.newBuilder();
            Scheme scheme = Scheme.HTTP;
            if (secure) {
                scheme = Scheme.HTTPS;
            }
            urlBuilder.scheme(scheme.toString());
            if (port > 0) {
                urlBuilder.port(port);
            }
            this.baseUrl = urlBuilder.build();
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.region = region;
            return;
        }
        if (!this.isValidEndpoint(endpoint)) {
            throw new InvalidEndpointException(endpoint, "invalid host");
        }
        Scheme scheme = Scheme.HTTP;
        if (secure) {
            scheme = Scheme.HTTPS;
        }
        this.baseUrl = port == 0 ? new HttpUrl.Builder().scheme(scheme.toString()).host(endpoint).build() : new HttpUrl.Builder().scheme(scheme.toString()).host(endpoint).port(port).build();
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
    }

    private boolean isValidEndpoint(String endpoint) {
        if (InetAddressValidator.getInstance().isValid(endpoint)) {
            return true;
        }
        if (endpoint.length() < 1 || endpoint.length() > 253) {
            return false;
        }
        for (String label : endpoint.split("\\.")) {
            if (label.length() < 1 || label.length() > 63) {
                return false;
            }
            if (label.matches("^[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?$")) continue;
            return false;
        }
        return true;
    }

    private void checkBucketName(String name) throws InvalidBucketNameException {
        if (name == null) {
            throw new InvalidBucketNameException(NULL_STRING, "null bucket name");
        }
        if (name.length() < 3 || name.length() > 63) {
            String msg = "bucket name must be at least 3 and no more than 63 characters long";
            throw new InvalidBucketNameException(name, msg);
        }
        if (name.matches("\\.\\.")) {
            String msg = "bucket name cannot contain successive periods. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
            throw new InvalidBucketNameException(name, msg);
        }
        if (!name.matches("^[a-z0-9][a-z0-9\\.\\-]+[a-z0-9]$")) {
            String msg = "bucket name does not follow Amazon S3 standards. For more information refer http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html";
            throw new InvalidBucketNameException(name, msg);
        }
    }

    public void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        this.httpClient = this.httpClient.newBuilder().connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).build();
    }

    @SuppressFBWarnings(value={"SIC"}, justification="Should not be used in production anyways.")
    public void ignoreCertCheck() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        this.httpClient = this.httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
    }

    private Request createRequest(Method method, String bucketName, String objectName, String region, Multimap<String, String> headerMap, Multimap<String, String> queryParamMap, String contentType, Object body, int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InvalidKeyException, InsufficientDataException, IOException, InternalException {
        if (bucketName == null && objectName != null) {
            throw new InvalidBucketNameException(NULL_STRING, "null bucket name for object '" + objectName + "'");
        }
        HttpUrl.Builder urlBuilder = this.baseUrl.newBuilder();
        if (bucketName != null) {
            this.checkBucketName(bucketName);
            Object host = this.baseUrl.host();
            if (((String)host).equals(S3_AMAZONAWS_COM)) {
                if (region != null) {
                    host = AwsS3Endpoints.INSTANCE.endpoint(region);
                }
                boolean usePathStyle = false;
                if (method == Method.PUT && objectName == null && queryParamMap == null) {
                    usePathStyle = true;
                } else if (queryParamMap != null && queryParamMap.containsKey((Object)"location")) {
                    usePathStyle = true;
                } else if (bucketName.contains(".") && this.baseUrl.isHttps()) {
                    usePathStyle = true;
                }
                if (usePathStyle) {
                    urlBuilder.host((String)host);
                    urlBuilder.addEncodedPathSegment(S3Escaper.encode(bucketName));
                } else {
                    urlBuilder.host(bucketName + "." + (String)host);
                }
            } else {
                urlBuilder.addEncodedPathSegment(S3Escaper.encode(bucketName));
            }
        }
        if (objectName != null) {
            urlBuilder.addEncodedPathSegments(S3Escaper.encodePath(objectName));
        }
        if (queryParamMap != null) {
            for (Map.Entry entry : queryParamMap.entries()) {
                urlBuilder.addEncodedQueryParameter(S3Escaper.encode((String)entry.getKey()), S3Escaper.encode((String)entry.getValue()));
            }
        }
        HttpUrl url = urlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        if (headerMap != null) {
            for (Map.Entry entry : headerMap.entries()) {
                requestBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        String sha256Hash = null;
        String md5Hash = null;
        boolean chunkedUpload = false;
        if (this.accessKey != null && this.secretKey != null) {
            if (method == Method.PUT && objectName != null && body != null && body instanceof InputStream && length > 0) {
                sha256Hash = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
                String contentEncoding = "aws-chunked";
                if (headerMap != null) {
                    contentEncoding = Stream.concat(Stream.of("aws-chunked"), headerMap.get((Object)"Content-Encoding").stream()).distinct().filter(encoding -> !encoding.isEmpty()).collect(Collectors.joining(","));
                }
                requestBuilder.header("Content-Encoding", contentEncoding);
                requestBuilder.header("x-amz-decoded-content-length", Integer.toString(length));
                chunkedUpload = true;
            } else if (url.isHttps()) {
                sha256Hash = "UNSIGNED-PAYLOAD";
                if (body != null) {
                    md5Hash = Digest.md5Hash(body, length);
                }
            } else {
                String[] hashes;
                Object data = body;
                int len = length;
                if (data == null) {
                    data = new byte[0];
                    len = 0;
                }
                if (method == Method.POST && queryParamMap != null && queryParamMap.containsKey((Object)"delete")) {
                    hashes = Digest.sha256Md5Hashes(data, len);
                    sha256Hash = hashes[0];
                    md5Hash = hashes[1];
                } else if (method == Method.PUT && queryParamMap != null && queryParamMap.containsKey((Object)"lifecycle")) {
                    hashes = Digest.sha256Md5Hashes(data, len);
                    sha256Hash = hashes[0];
                    md5Hash = hashes[1];
                } else {
                    sha256Hash = Digest.sha256Hash(data, len);
                }
            }
        } else if (body != null) {
            md5Hash = Digest.md5Hash(body, length);
        }
        if (md5Hash != null) {
            requestBuilder.header("Content-MD5", md5Hash);
        }
        if (this.shouldOmitPortInHostHeader(url)) {
            requestBuilder.header("Host", url.host());
        } else {
            requestBuilder.header("Host", url.host() + ":" + url.port());
        }
        requestBuilder.header("User-Agent", this.userAgent);
        if (sha256Hash != null) {
            requestBuilder.header("x-amz-content-sha256", sha256Hash);
        }
        DateTime date = new DateTime();
        requestBuilder.header("x-amz-date", date.toString(DateFormat.AMZ_DATE_FORMAT));
        if (chunkedUpload) {
            requestBuilder.method(method.toString(), RequestBody.create(null, (String)""));
            Request request = requestBuilder.build();
            String seedSignature = Signer.getChunkSeedSignature(request, region, this.secretKey);
            requestBuilder = request.newBuilder();
            ChunkedInputStream cis = new ChunkedInputStream((InputStream)body, length, date, region, this.secretKey, seedSignature);
            body = cis;
            length = cis.length();
        }
        HttpRequestBody requestBody = null;
        if (body != null) {
            requestBody = new HttpRequestBody(contentType, body, length);
        }
        requestBuilder.method(method.toString(), requestBody);
        return requestBuilder.build();
    }

    private boolean shouldOmitPortInHostHeader(HttpUrl url) {
        return url.scheme().equals("http") && url.port() == 80 || url.scheme().equals("https") && url.port() == 443;
    }

    private HttpResponse execute(Method method, String region, String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, Object body, int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (headerMap != null) {
            headerMap = this.normalizeHeaders(headerMap);
        }
        SetMultimap queryParamMultiMap = null;
        if (queryParamMap != null) {
            queryParamMultiMap = Multimaps.forMap(queryParamMap);
        }
        SetMultimap headerMultiMap = null;
        if (headerMap != null) {
            headerMultiMap = Multimaps.forMap(headerMap);
        }
        return this.executeReq(method, region, bucketName, objectName, (Multimap<String, String>)headerMultiMap, (Multimap<String, String>)queryParamMultiMap, body, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeReq(Method method, String region, String bucketName, String objectName, Multimap<String, String> headerMap, Multimap<String, String> queryParamMap, Object body, int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        String contentType = null;
        if (headerMap != null && headerMap.get((Object)"Content-Type") != null) {
            contentType = String.join((CharSequence)" ", headerMap.get((Object)"Content-Type"));
        }
        if (!(body == null || body instanceof InputStream || body instanceof RandomAccessFile || body instanceof byte[])) {
            byte[] bytes = body.toString().getBytes(StandardCharsets.UTF_8);
            body = bytes;
            length = bytes.length;
        }
        Request request = this.createRequest(method, bucketName, objectName, region, headerMap, queryParamMap, contentType, body, length);
        if (this.accessKey != null && this.secretKey != null) {
            request = Signer.signV4(request, region, this.accessKey, this.secretKey);
        }
        if (this.traceStream != null) {
            this.traceStream.println("---------START-HTTP---------");
            String encodedPath = request.url().encodedPath();
            String encodedQuery = request.url().encodedQuery();
            if (encodedQuery != null) {
                encodedPath = encodedPath + "?" + encodedQuery;
            }
            this.traceStream.println(request.method() + " " + encodedPath + " HTTP/1.1");
            String headers = request.headers().toString().replaceAll("Signature=([0-9a-f]+)", "Signature=*REDACTED*").replaceAll("Credential=([^/]+)", "Credential=*REDACTED*");
            this.traceStream.println(headers);
        }
        Response response = this.httpClient.newCall(request).execute();
        if (this.traceStream != null) {
            this.traceStream.println(response.protocol().toString().toUpperCase(Locale.US) + " " + response.code());
            this.traceStream.println(response.headers());
        }
        ResponseHeader header = new ResponseHeader();
        HeaderParser.set(response.headers(), header);
        if (response.isSuccessful()) {
            if (this.traceStream != null) {
                this.traceStream.println(END_HTTP);
            }
            return new HttpResponse(header, response);
        }
        ErrorResponse errorResponse = null;
        if (!method.equals((Object)Method.HEAD)) {
            Scanner scanner = new Scanner(response.body().charStream());
            try {
                scanner.useDelimiter("\\A");
                String errorXml = "";
                if (scanner.hasNext()) {
                    errorXml = scanner.next();
                }
                if (!"application/xml".equals(response.headers().get("content-type"))) {
                    throw new InvalidResponseException();
                }
                errorResponse = new ErrorResponse(new StringReader(errorXml));
                if (this.traceStream != null) {
                    this.traceStream.println(errorXml);
                }
            }
            finally {
                response.body().close();
                scanner.close();
            }
        }
        if (this.traceStream != null) {
            this.traceStream.println(END_HTTP);
        }
        if (errorResponse == null) {
            ErrorCode ec;
            switch (response.code()) {
                case 307: {
                    ec = ErrorCode.REDIRECT;
                    break;
                }
                case 400: {
                    ec = ErrorCode.INVALID_URI;
                    break;
                }
                case 404: {
                    if (objectName != null) {
                        ec = ErrorCode.NO_SUCH_KEY;
                        break;
                    }
                    if (bucketName != null) {
                        ec = ErrorCode.NO_SUCH_BUCKET;
                        break;
                    }
                    ec = ErrorCode.RESOURCE_NOT_FOUND;
                    break;
                }
                case 405: 
                case 501: {
                    ec = ErrorCode.METHOD_NOT_ALLOWED;
                    break;
                }
                case 409: {
                    if (bucketName != null) {
                        ec = ErrorCode.NO_SUCH_BUCKET;
                        break;
                    }
                    ec = ErrorCode.RESOURCE_CONFLICT;
                    break;
                }
                case 403: {
                    ec = ErrorCode.ACCESS_DENIED;
                    break;
                }
                default: {
                    throw new InternalException("unhandled HTTP code " + response.code() + ".  Please report this issue at https://github.com/minio/minio-java/issues");
                }
            }
            errorResponse = new ErrorResponse(ec, bucketName, objectName, request.url().encodedPath(), header.xamzRequestId(), header.xamzId2());
        }
        if (errorResponse.errorCode() == ErrorCode.NO_SUCH_BUCKET) {
            BucketRegionCache.INSTANCE.remove(bucketName);
        }
        throw new ErrorResponseException(errorResponse, response);
    }

    private void updateRegionCache(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (bucketName != null && this.accessKey != null && this.secretKey != null && !BucketRegionCache.INSTANCE.exists(bucketName)) {
            HashMap<String, String> queryParamMap = new HashMap<String, String>();
            queryParamMap.put("location", null);
            HttpResponse response = this.execute(Method.GET, US_EAST_1, bucketName, null, null, queryParamMap, null, 0);
            XmlPullParser xpp = xmlPullParserFactory.newPullParser();
            String location = null;
            try (ResponseBody body = response.body();){
                xpp.setInput(body.charStream());
                while (xpp.getEventType() != 1) {
                    if (xpp.getEventType() == 2 && "LocationConstraint".equals(xpp.getName())) {
                        xpp.next();
                        location = this.getText(xpp);
                        break;
                    }
                    xpp.next();
                }
            }
            String region = location == null ? US_EAST_1 : ("EU".equals(location) ? "eu-west-1" : location);
            BucketRegionCache.INSTANCE.set(bucketName, region);
        }
    }

    private String getRegion(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        String region;
        if (this.region == null || "".equals(this.region)) {
            this.updateRegionCache(bucketName);
            region = BucketRegionCache.INSTANCE.region(bucketName);
        } else {
            region = this.region;
        }
        return region;
    }

    private String getText(XmlPullParser xpp) throws XmlPullParserException {
        if (xpp.getEventType() == 4) {
            return xpp.getText();
        }
        return null;
    }

    private void checkReadRequestSse(ServerSideEncryption sse) throws InvalidArgumentException {
        if (sse == null) {
            return;
        }
        if (sse.type() != ServerSideEncryption.Type.SSE_C) {
            throw new InvalidArgumentException("only SSE_C is supported for all read requests.");
        }
        if (sse.getType().requiresTls() && !this.baseUrl.isHttps()) {
            throw new InvalidArgumentException(sse.getType().name() + "operations must be performed over a secure connection.");
        }
    }

    private void checkWriteRequestSse(ServerSideEncryption sse) throws InvalidArgumentException {
        if (sse == null) {
            return;
        }
        if (sse.type().requiresTls() && !this.baseUrl.isHttps()) {
            throw new InvalidArgumentException(sse.type().name() + " operations must be performed over a secure connection.");
        }
    }

    private HttpResponse executeGet(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        return this.execute(Method.GET, this.getRegion(bucketName), bucketName, objectName, headerMap, queryParamMap, null, 0);
    }

    private HttpResponse executeHead(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HttpResponse response = this.execute(Method.HEAD, this.getRegion(bucketName), bucketName, objectName, null, null, null, 0);
        response.body().close();
        return response;
    }

    private HttpResponse executeHead(String bucketName, String objectName, Map<String, String> headerMap) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HttpResponse response = this.execute(Method.HEAD, this.getRegion(bucketName), bucketName, objectName, headerMap, null, null, 0);
        response.body().close();
        return response;
    }

    private HttpResponse executeDelete(String bucketName, String objectName, Map<String, String> queryParamMap) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HttpResponse response = this.execute(Method.DELETE, this.getRegion(bucketName), bucketName, objectName, null, queryParamMap, null, 0);
        response.body().close();
        return response;
    }

    private HttpResponse executePost(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, Object data) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        return this.execute(Method.POST, this.getRegion(bucketName), bucketName, objectName, headerMap, queryParamMap, data, 0);
    }

    private Map<String, String> normalizeHeaders(Map<String, String> headerMap) {
        HashMap<String, String> normHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String keyLowerCased = key.toLowerCase(Locale.US);
            if (amzHeaders.contains(keyLowerCased)) {
                key = "x-amz-" + key;
            } else if (!standardHeaders.contains(keyLowerCased) && !keyLowerCased.startsWith("x-amz-")) {
                key = "x-amz-meta-" + key;
            }
            normHeaderMap.put(key, value);
        }
        return normHeaderMap;
    }

    private HttpResponse executePut(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, String region, Object data, int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HttpResponse response = this.execute(Method.PUT, region, bucketName, objectName, headerMap, queryParamMap, data, length);
        return response;
    }

    private HttpResponse executePut(String bucketName, String objectName, Map<String, String> headerMap, Map<String, String> queryParamMap, Object data, int length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        return this.executePut(bucketName, objectName, headerMap, queryParamMap, this.getRegion(bucketName), data, length);
    }

    public void setAppInfo(String name, String version) {
        if (name == null || version == null) {
            return;
        }
        this.userAgent = DEFAULT_USER_AGENT + " " + name.trim() + "/" + version.trim();
    }

    public ObjectStat statObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException, InvalidArgumentException {
        return this.statObject(bucketName, objectName, null);
    }

    public ObjectStat statObject(String bucketName, String objectName, ServerSideEncryption sse) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        this.checkReadRequestSse(sse);
        Map<String, String> headers = null;
        if (sse != null) {
            headers = sse.headers();
        }
        HttpResponse response = this.executeHead(bucketName, objectName, headers);
        ResponseHeader header = response.header();
        Map<String, List<String>> httpHeaders = response.httpHeaders();
        ObjectStat objectStat = new ObjectStat(bucketName, objectName, header, httpHeaders);
        return objectStat;
    }

    public String getObjectUrl(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        Request request = this.createRequest(Method.GET, bucketName, objectName, this.getRegion(bucketName), null, null, null, null, 0);
        HttpUrl url = request.url();
        return url.toString();
    }

    public InputStream getObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        return this.getObject(bucketName, objectName, null, null, null);
    }

    public InputStream getObject(String bucketName, String objectName, ServerSideEncryption sse) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        return this.getObject(bucketName, objectName, null, null, sse);
    }

    public InputStream getObject(String bucketName, String objectName, long offset) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        return this.getObject(bucketName, objectName, offset, null, null);
    }

    public InputStream getObject(String bucketName, String objectName, long offset, Long length) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        return this.getObject(bucketName, objectName, offset, length, null);
    }

    public InputStream getObject(String bucketName, String objectName, Long offset, Long length, ServerSideEncryption sse) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new InvalidArgumentException("bucket name cannot be empty");
        }
        if (objectName == null || objectName.isEmpty()) {
            throw new InvalidArgumentException("object name cannot be empty");
        }
        if (offset != null && offset < 0L) {
            throw new InvalidArgumentException("offset should be zero or greater");
        }
        if (length != null && length <= 0L) {
            throw new InvalidArgumentException("length should be greater than zero");
        }
        this.checkReadRequestSse(sse);
        if (length != null && offset == null) {
            offset = 0L;
        }
        HashMap<String, String> headerMap = null;
        if (offset != null || length != null || sse != null) {
            headerMap = new HashMap<String, String>();
        }
        if (length != null) {
            headerMap.put("Range", "bytes=" + offset + "-" + (offset + length - 1L));
        } else if (offset != null) {
            headerMap.put("Range", "bytes=" + offset + "-");
        }
        if (sse != null) {
            headerMap.putAll(sse.headers());
        }
        HttpResponse response = this.executeGet(bucketName, objectName, headerMap, null);
        return response.body().byteStream();
    }

    public void getObject(String bucketName, String objectName, String fileName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        this.getObject(bucketName, objectName, null, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getObject(String bucketName, String objectName, ServerSideEncryption sse, String fileName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        this.checkReadRequestSse(sse);
        Path filePath = Paths.get(fileName, new String[0]);
        boolean fileExists = Files.exists(filePath, new LinkOption[0]);
        if (fileExists && !Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new InvalidArgumentException(fileName + ": not a regular file");
        }
        ObjectStat objectStat = this.statObject(bucketName, objectName, sse);
        long length = objectStat.length();
        String etag = objectStat.etag();
        String tempFileName = fileName + "." + etag + ".part.minio";
        Path tempFilePath = Paths.get(tempFileName, new String[0]);
        boolean tempFileExists = Files.exists(tempFilePath, new LinkOption[0]);
        if (tempFileExists && !Files.isRegularFile(tempFilePath, new LinkOption[0])) {
            throw new IOException(tempFileName + ": not a regular file");
        }
        long tempFileSize = 0L;
        if (tempFileExists && (tempFileSize = Files.size(tempFilePath)) > length) {
            Files.delete(tempFilePath);
            tempFileExists = false;
            tempFileSize = 0L;
        }
        if (fileExists) {
            long fileSize = Files.size(filePath);
            if (fileSize == length) {
                return;
            }
            if (fileSize > length) {
                throw new InvalidArgumentException("Source object, '" + objectName + "', size:" + length + " is smaller than the destination file, '" + fileName + "', size:" + fileSize);
            }
            if (!tempFileExists) {
                Files.copy(filePath, tempFilePath, new CopyOption[0]);
                tempFileSize = fileSize;
                tempFileExists = true;
            }
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.getObject(bucketName, objectName, tempFileSize, null, sse);
            os = Files.newOutputStream(tempFilePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            long bytesWritten = ByteStreams.copy((InputStream)is, (OutputStream)os);
            is.close();
            os.close();
            if (bytesWritten != length - tempFileSize) {
                throw new IOException(tempFileName + ": unexpected data written.  expected = " + (length - tempFileSize) + ", written = " + bytesWritten);
            }
            Files.move(tempFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    @Deprecated
    public void copyObject(String bucketName, String objectName, String destBucketName) throws InvalidKeyException, InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, NoResponseException, ErrorResponseException, InternalException, IOException, XmlPullParserException, InvalidArgumentException, InvalidResponseException {
        this.copyObject(destBucketName, objectName, null, null, bucketName, objectName, null, null);
    }

    @Deprecated
    public void copyObject(String bucketName, String objectName, String destBucketName, String destObjectName) throws InvalidKeyException, InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, NoResponseException, ErrorResponseException, InternalException, IOException, XmlPullParserException, InvalidArgumentException, InvalidResponseException {
        if (destObjectName == null) {
            destObjectName = objectName;
        }
        this.copyObject(destBucketName, destObjectName, null, null, bucketName, objectName, null, null);
    }

    @Deprecated
    public void copyObject(String bucketName, String objectName, String destBucketName, CopyConditions copyConditions) throws InvalidKeyException, InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, NoResponseException, ErrorResponseException, InternalException, IOException, XmlPullParserException, InvalidArgumentException, InvalidResponseException {
        this.copyObject(destBucketName, objectName, null, null, bucketName, objectName, null, copyConditions);
    }

    @Deprecated
    public void copyObject(String bucketName, String objectName, String destBucketName, String destObjectName, CopyConditions copyConditions) throws InvalidKeyException, InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, NoResponseException, ErrorResponseException, InternalException, IOException, XmlPullParserException, InvalidArgumentException, InvalidResponseException {
        if (destObjectName == null) {
            destObjectName = objectName;
        }
        this.copyObject(destBucketName, destObjectName, null, null, bucketName, objectName, null, copyConditions);
    }

    @Deprecated
    public void copyObject(String bucketName, String objectName, ServerSideEncryption sseSource, String destBucketName, String destObjectName, CopyConditions copyConditions, ServerSideEncryption sseTarget) throws InvalidKeyException, InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, NoResponseException, ErrorResponseException, InternalException, IOException, XmlPullParserException, InvalidArgumentException, InvalidResponseException {
        if (destObjectName == null) {
            destObjectName = objectName;
        }
        this.copyObject(destBucketName, destObjectName, null, sseTarget, bucketName, objectName, sseSource, copyConditions);
    }

    @Deprecated
    public void copyObject(String bucketName, String objectName, String destBucketName, String destObjectName, CopyConditions copyConditions, Map<String, String> metadata) throws InvalidKeyException, InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, NoResponseException, ErrorResponseException, InternalException, IOException, XmlPullParserException, InvalidArgumentException, InvalidResponseException {
        if (destObjectName == null) {
            destObjectName = objectName;
        }
        this.copyObject(destBucketName, destObjectName, metadata, null, bucketName, objectName, null, copyConditions);
    }

    public void copyObject(String bucketName, String objectName, Map<String, String> headerMap, ServerSideEncryption sse, String srcBucketName, String srcObjectName, ServerSideEncryption srcSse, CopyConditions copyConditions) throws InvalidKeyException, InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, NoResponseException, ErrorResponseException, InternalException, IOException, XmlPullParserException, InvalidArgumentException, InvalidResponseException {
        if (bucketName == null) {
            throw new InvalidArgumentException("bucket name cannot be empty");
        }
        if (objectName == null) {
            throw new InvalidArgumentException("object name cannot be empty");
        }
        this.checkWriteRequestSse(sse);
        if (srcBucketName == null) {
            throw new InvalidArgumentException("Source bucket name cannot be empty");
        }
        if (srcObjectName == null) {
            srcObjectName = objectName;
        }
        this.checkReadRequestSse(srcSse);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        headerMap.put("x-amz-copy-source", S3Escaper.encodePath(srcBucketName + "/" + srcObjectName));
        if (sse != null) {
            headerMap.putAll(sse.headers());
        }
        if (srcSse != null) {
            headerMap.putAll(srcSse.copySourceHeaders());
        }
        if (copyConditions != null) {
            headerMap.putAll(copyConditions.getConditions());
        }
        HttpResponse response = this.executePut(bucketName, objectName, headerMap, null, "", 0);
        CopyObjectResult result = new CopyObjectResult();
        try (ResponseBody body = response.body();){
            result.parseXml(body.charStream());
        }
    }

    public String getPresignedObjectUrl(Method method, String bucketName, String objectName, Integer expires, Map<String, String> reqParams) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException, InvalidResponseException {
        if (expires < 1 || expires > 604800) {
            throw new InvalidExpiresRangeException(expires, "expires must be in range of 1 to 604800");
        }
        byte[] body = null;
        if (method == Method.PUT || method == Method.POST) {
            body = new byte[]{};
        }
        HashMultimap queryParamMap = null;
        if (reqParams != null) {
            queryParamMap = HashMultimap.create();
            for (Map.Entry<String, String> m : reqParams.entrySet()) {
                queryParamMap.put((Object)m.getKey(), (Object)m.getValue());
            }
        }
        String region = this.getRegion(bucketName);
        Request request = this.createRequest(method, bucketName, objectName, region, null, (Multimap<String, String>)queryParamMap, null, body, 0);
        HttpUrl url = Signer.presignV4(request, region, this.accessKey, this.secretKey, expires);
        return url.toString();
    }

    public String presignedGetObject(String bucketName, String objectName, Integer expires, Map<String, String> reqParams) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException, InvalidResponseException {
        return this.getPresignedObjectUrl(Method.GET, bucketName, objectName, expires, reqParams);
    }

    public String presignedGetObject(String bucketName, String objectName, Integer expires) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException, InvalidResponseException {
        return this.presignedGetObject(bucketName, objectName, expires, null);
    }

    public String presignedGetObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException, InvalidResponseException {
        return this.presignedGetObject(bucketName, objectName, 604800, null);
    }

    public String presignedPutObject(String bucketName, String objectName, Integer expires) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException, InvalidResponseException {
        return this.getPresignedObjectUrl(Method.PUT, bucketName, objectName, expires, null);
    }

    public String presignedPutObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidExpiresRangeException, InvalidResponseException {
        return this.presignedPutObject(bucketName, objectName, 604800);
    }

    public Map<String, String> presignedPostPolicy(PostPolicy policy) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        return policy.formData(this.accessKey, this.secretKey, this.getRegion(policy.bucketName()));
    }

    public void removeObject(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        if (bucketName == null || bucketName.isEmpty()) {
            throw new InvalidArgumentException("bucket name cannot be empty");
        }
        if (objectName == null || objectName.isEmpty()) {
            throw new InvalidArgumentException("object name cannot be empty");
        }
        this.executeDelete(bucketName, objectName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DeleteError> removeObject(String bucketName, List<DeleteObject> objectList) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("delete", "");
        DeleteRequest request = new DeleteRequest(objectList);
        HttpResponse response = this.executePost(bucketName, null, null, queryParamMap, (Object)request);
        String bodyContent = "";
        Scanner scanner = new Scanner(response.body().charStream());
        try {
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                bodyContent = scanner.next();
            }
        }
        finally {
            response.body().close();
            scanner.close();
        }
        List<DeleteError> errorList = null;
        DeleteError error = new DeleteError(new StringReader(bodyContent = bodyContent.trim()));
        if (error.code() != null) {
            errorList = new LinkedList<DeleteError>();
            errorList.add(error);
        } else {
            DeleteResult result = new DeleteResult(new StringReader(bodyContent));
            errorList = result.errorList();
        }
        return errorList;
    }

    public Iterable<Result<DeleteError>> removeObjects(final String bucketName, final Iterable<String> objectNames) {
        return new Iterable<Result<DeleteError>>(){

            @Override
            public Iterator<Result<DeleteError>> iterator() {
                return new Iterator<Result<DeleteError>>(){
                    private Result<DeleteError> error;
                    private Iterator<DeleteError> errorIterator;
                    private boolean completed = false;
                    private Iterator<String> objectNameIter;
                    {
                        this.objectNameIter = objectNames.iterator();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private synchronized void populate() {
                        List errorList = null;
                        try {
                            int i;
                            LinkedList<DeleteObject> objectList = new LinkedList<DeleteObject>();
                            for (i = 0; this.objectNameIter.hasNext() && i < 1000; ++i) {
                                objectList.add(new DeleteObject(this.objectNameIter.next()));
                            }
                            if (i > 0) {
                                errorList = MinioClient.this.removeObject(bucketName, objectList);
                            }
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                            this.error = new Result<Object>(null, (Exception)e);
                        }
                        finally {
                            this.errorIterator = errorList != null ? errorList.iterator() : new LinkedList().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.errorIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && this.errorIterator != null && !this.errorIterator.hasNext()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.errorIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<DeleteError> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.errorIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && this.errorIterator != null && !this.errorIterator.hasNext()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.errorIterator.hasNext()) {
                            return new Result<DeleteError>(this.errorIterator.next(), null);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<Result<Item>> listObjects(String bucketName) throws XmlPullParserException {
        return this.listObjects(bucketName, null);
    }

    public Iterable<Result<Item>> listObjects(String bucketName, String prefix) throws XmlPullParserException {
        return this.listObjects(bucketName, prefix, true);
    }

    public Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive) {
        return this.listObjects(bucketName, prefix, recursive, false);
    }

    public Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive, boolean useVersion1) {
        if (useVersion1) {
            return this.listObjectsV1(bucketName, prefix, recursive);
        }
        return this.listObjectsV2(bucketName, prefix, recursive);
    }

    private Iterable<Result<Item>> listObjectsV2(final String bucketName, final String prefix, final boolean recursive) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new Iterator<Result<Item>>(){
                    private ListBucketResult listBucketResult;
                    private Result<Item> error;
                    private Iterator<Item> itemIterator;
                    private Iterator<Prefix> prefixIterator;
                    private boolean completed = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private synchronized void populate() {
                        String delimiter = "/";
                        if (recursive) {
                            delimiter = null;
                        }
                        String continuationToken = null;
                        if (this.listBucketResult != null) {
                            continuationToken = this.listBucketResult.nextContinuationToken();
                        }
                        this.listBucketResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        try {
                            this.listBucketResult = MinioClient.this.listObjectsV2(bucketName, continuationToken, prefix, delimiter);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                            this.error = new Result<Object>(null, (Exception)e);
                        }
                        finally {
                            if (this.listBucketResult != null) {
                                this.itemIterator = this.listBucketResult.contents().iterator();
                                this.prefixIterator = this.listBucketResult.commonPrefixes().iterator();
                            } else {
                                this.itemIterator = new LinkedList().iterator();
                                this.prefixIterator = new LinkedList().iterator();
                            }
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.itemIterator.hasNext()) {
                            return true;
                        }
                        if (this.prefixIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Item> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.itemIterator.hasNext()) {
                            Item item = this.itemIterator.next();
                            return new Result<Item>(item, null);
                        }
                        if (this.prefixIterator.hasNext()) {
                            Item item;
                            Prefix prefix = this.prefixIterator.next();
                            try {
                                item = new Item(prefix.prefix(), true);
                            }
                            catch (XmlPullParserException e) {
                                item = null;
                            }
                            return new Result<Item>(item, null);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ListBucketResult listObjectsV2(String bucketName, String continuationToken, String prefix, String delimiter) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("list-type", "2");
        if (continuationToken != null) {
            queryParamMap.put("continuation-token", continuationToken);
        }
        if (prefix != null) {
            queryParamMap.put("prefix", prefix);
        } else {
            queryParamMap.put("prefix", "");
        }
        if (delimiter != null) {
            queryParamMap.put("delimiter", delimiter);
        } else {
            queryParamMap.put("delimiter", "");
        }
        HttpResponse response = this.executeGet(bucketName, null, null, queryParamMap);
        ListBucketResult result = new ListBucketResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result;
    }

    private Iterable<Result<Item>> listObjectsV1(final String bucketName, final String prefix, final boolean recursive) {
        return new Iterable<Result<Item>>(){

            @Override
            public Iterator<Result<Item>> iterator() {
                return new Iterator<Result<Item>>(){
                    private String lastObjectName;
                    private ListBucketResultV1 listBucketResult;
                    private Result<Item> error;
                    private Iterator<Item> itemIterator;
                    private Iterator<Prefix> prefixIterator;
                    private boolean completed = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private synchronized void populate() {
                        String delimiter = "/";
                        if (recursive) {
                            delimiter = null;
                        }
                        String marker = null;
                        if (this.listBucketResult != null) {
                            marker = delimiter != null ? this.listBucketResult.nextMarker() : this.lastObjectName;
                        }
                        this.listBucketResult = null;
                        this.itemIterator = null;
                        this.prefixIterator = null;
                        try {
                            this.listBucketResult = MinioClient.this.listObjectsV1(bucketName, marker, prefix, delimiter);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                            this.error = new Result<Object>(null, (Exception)e);
                        }
                        finally {
                            if (this.listBucketResult != null) {
                                this.itemIterator = this.listBucketResult.contents().iterator();
                                this.prefixIterator = this.listBucketResult.commonPrefixes().iterator();
                            } else {
                                this.itemIterator = new LinkedList().iterator();
                                this.prefixIterator = new LinkedList().iterator();
                            }
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.itemIterator.hasNext()) {
                            return true;
                        }
                        if (this.prefixIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Item> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.itemIterator == null && this.prefixIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.itemIterator.hasNext() && !this.prefixIterator.hasNext() && this.listBucketResult.isTruncated()) {
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.itemIterator.hasNext()) {
                            Item item = this.itemIterator.next();
                            this.lastObjectName = item.objectName();
                            return new Result<Item>(item, null);
                        }
                        if (this.prefixIterator.hasNext()) {
                            Item item;
                            Prefix prefix = this.prefixIterator.next();
                            try {
                                item = new Item(prefix.prefix(), true);
                            }
                            catch (XmlPullParserException e) {
                                item = null;
                            }
                            return new Result<Item>(item, null);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ListBucketResultV1 listObjectsV1(String bucketName, String marker, String prefix, String delimiter) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        if (marker != null) {
            queryParamMap.put("marker", marker);
        }
        if (prefix != null) {
            queryParamMap.put("prefix", prefix);
        } else {
            queryParamMap.put("prefix", "");
        }
        if (delimiter != null) {
            queryParamMap.put("delimiter", delimiter);
        } else {
            queryParamMap.put("delimiter", "");
        }
        HttpResponse response = this.executeGet(bucketName, null, null, queryParamMap);
        ListBucketResultV1 result = new ListBucketResultV1();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result;
    }

    public List<Bucket> listBuckets() throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HttpResponse response = this.executeGet(null, null, null, null);
        ListAllMyBucketsResult result = new ListAllMyBucketsResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result.buckets();
    }

    public boolean bucketExists(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        try {
            this.executeHead(bucketName, null);
            return true;
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.NO_SUCH_BUCKET) {
                throw e;
            }
            return false;
        }
    }

    public void makeBucket(String bucketName) throws InvalidBucketNameException, RegionConflictException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        this.makeBucket(bucketName, null, false);
    }

    public void makeBucket(String bucketName, String region) throws InvalidBucketNameException, RegionConflictException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        this.makeBucket(bucketName, region, false);
    }

    public void makeBucket(String bucketName, String region, boolean objectLock) throws InvalidBucketNameException, RegionConflictException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        String configString;
        if (region == null) {
            region = this.region;
        }
        if (this.region != null && !this.region.equals(region)) {
            throw new RegionConflictException("passed region conflicts with the one previously specified");
        }
        if (region == null || US_EAST_1.equals(region)) {
            region = US_EAST_1;
            configString = "";
        } else {
            CreateBucketConfiguration config = new CreateBucketConfiguration(region);
            configString = config.toString();
        }
        HashMap<String, String> headerMap = null;
        if (objectLock) {
            headerMap = new HashMap<String, String>();
            headerMap.put("x-amz-bucket-object-lock-enabled", "true");
        }
        HttpResponse response = this.executePut(bucketName, null, headerMap, null, region, configString, 0);
        response.body().close();
    }

    public void enableVersioning(String bucketName) throws InvalidBucketNameException, RegionConflictException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("versioning", "");
        String config = "<VersioningConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Status>Enabled</Status></VersioningConfiguration>";
        HttpResponse response = this.executePut(bucketName, null, null, queryParamMap, config, 0);
        response.body().close();
    }

    public void disableVersioning(String bucketName) throws InvalidBucketNameException, RegionConflictException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("versioning", "");
        String config = "<VersioningConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Status>Suspended</Status></VersioningConfiguration>";
        HttpResponse response = this.executePut(bucketName, null, null, queryParamMap, config, 0);
        response.body().close();
    }

    public void setDefaultRetention(String bucketName, ObjectLockConfiguration config) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("object-lock", "");
        HttpResponse response = this.executePut(bucketName, null, null, queryParamMap, (Object)config, 0);
        response.body().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLockConfiguration getDefaultRetention(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("object-lock", "");
        HttpResponse response = this.executeGet(bucketName, null, null, queryParamMap);
        ObjectLockConfiguration result = new ObjectLockConfiguration();
        try {
            result.parseXml(response.body().charStream());
        }
        finally {
            response.body().close();
        }
        return result;
    }

    public void removeBucket(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        this.executeDelete(bucketName, null, null);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, String fileName) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, fileName, null, null, null, null);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, String fileName, String contentType) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, fileName, null, null, null, contentType);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, String fileName, ServerSideEncryption sse) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, fileName, null, null, sse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(String bucketName, String objectName, String fileName, Long size, Map<String, String> headerMap, ServerSideEncryption sse, String contentType) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        if (fileName == null || "".equals(fileName)) {
            throw new InvalidArgumentException("empty file name is not allowed");
        }
        Path filePath = Paths.get(fileName, new String[0]);
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new InvalidArgumentException("'" + fileName + "': not a regular file");
        }
        if (contentType == null) {
            contentType = Files.probeContentType(filePath);
        }
        if (size == null) {
            size = Files.size(filePath);
        }
        try (RandomAccessFile file = new RandomAccessFile(filePath.toFile(), "r");){
            this.putObject(bucketName, objectName, size, file, headerMap, sse, contentType);
        }
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, InputStream stream, long size, String contentType) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, stream, (Long)size, null, null, contentType);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, InputStream stream, Map<String, String> headerMap) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        this.putObject(bucketName, objectName, stream, null, headerMap, null, null);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, InputStream stream, long size, Map<String, String> headerMap) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, stream, (Long)size, headerMap, null, null);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, InputStream stream, long size, ServerSideEncryption sse) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, stream, (Long)size, null, sse, null);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, InputStream stream, Map<String, String> headerMap, ServerSideEncryption sse) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, stream, null, headerMap, sse, null);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, InputStream stream, long size, Map<String, String> headerMap, ServerSideEncryption sse) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, stream, (Long)size, headerMap, sse, null);
    }

    @Deprecated
    public void putObject(String bucketName, String objectName, InputStream stream, String contentType) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        this.putObject(bucketName, objectName, stream, null, null, null, contentType);
    }

    public void putObject(String bucketName, String objectName, InputStream stream, Long size, Map<String, String> headerMap, ServerSideEncryption sse, String contentType) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        this.putObject(bucketName, objectName, size, stream, headerMap, sse, contentType);
    }

    private String putObject(String bucketName, String objectName, Object data, int length, Map<String, String> headerMap, String uploadId, int partNumber) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HttpResponse response = null;
        HashMap<String, String> queryParamMap = null;
        if (partNumber > 0 && uploadId != null && !"".equals(uploadId)) {
            queryParamMap = new HashMap<String, String>();
            queryParamMap.put("partNumber", Integer.toString(partNumber));
            queryParamMap.put(UPLOAD_ID, uploadId);
        }
        response = this.executePut(bucketName, objectName, headerMap, queryParamMap, data, length);
        response.body().close();
        return response.header().etag();
    }

    private void putObject(String bucketName, String objectName, Long size, Object data, Map<String, String> headerMap, ServerSideEncryption sse, String contentType) throws InvalidBucketNameException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InsufficientDataException, InvalidResponseException {
        boolean unknownSize = false;
        if (size == null) {
            unknownSize = true;
            size = 0x50000000000L;
        }
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        if (contentType == null) {
            if (headerMap.get("Content-Type") == null) {
                headerMap.put("Content-Type", "application/octet-stream");
            }
        } else {
            headerMap.put("Content-Type", contentType);
        }
        if (sse != null) {
            this.checkWriteRequestSse(sse);
            headerMap.putAll(sse.headers());
        }
        if (size <= 0x500000L) {
            this.putObject(bucketName, objectName, data, size.intValue(), headerMap, null, 0);
            return;
        }
        int[] rv = MinioClient.calculateMultipartSize(size);
        int partSize = rv[0];
        int partCount = rv[1];
        int lastPartSize = rv[2];
        Part[] totalParts = new Part[partCount];
        String uploadId = this.initMultipartUpload(bucketName, objectName, headerMap);
        try {
            int expectedReadSize = partSize;
            for (int partNumber = 1; partNumber <= partCount; ++partNumber) {
                if (partNumber == partCount) {
                    expectedReadSize = lastPartSize;
                }
                int availableSize = 0;
                if (unknownSize && (availableSize = this.getAvailableSize(data, expectedReadSize + 1)) <= expectedReadSize) {
                    if (partNumber == 1) {
                        this.putObject(bucketName, objectName, data, availableSize, headerMap, null, 0);
                        return;
                    }
                    expectedReadSize = availableSize;
                    partCount = partNumber;
                }
                Map<String, String> encryptionHeaders = null;
                if (sse != null && sse.type() == ServerSideEncryption.Type.SSE_C) {
                    encryptionHeaders = sse.headers();
                }
                String etag = this.putObject(bucketName, objectName, data, expectedReadSize, encryptionHeaders, uploadId, partNumber);
                totalParts[partNumber - 1] = new Part(partNumber, etag);
            }
            this.completeMultipart(bucketName, objectName, uploadId, totalParts);
        }
        catch (RuntimeException e) {
            this.abortMultipartUpload(bucketName, objectName, uploadId);
            throw e;
        }
        catch (Exception e) {
            this.abortMultipartUpload(bucketName, objectName, uploadId);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBucketPolicy(String bucketName) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, BucketPolicyTooLargeException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("policy", "");
        HttpResponse response = null;
        byte[] buf = new byte[12288];
        int bytesRead = 0;
        try {
            response = this.executeGet(bucketName, null, null, queryParamMap);
            bytesRead = response.body().byteStream().read(buf, 0, 12288);
            if (bytesRead < 0) {
                throw new IOException("reached EOF when reading bucket policy");
            }
            if (bytesRead == 12288) {
                int byteRead = 0;
                while (byteRead == 0) {
                    byteRead = response.body().byteStream().read();
                    if (byteRead < 0) {
                        break;
                    }
                    if (byteRead <= 0) continue;
                    throw new BucketPolicyTooLargeException(bucketName);
                }
            }
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.NO_SUCH_BUCKET_POLICY) {
                throw e;
            }
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
        return new String(buf, 0, bytesRead, StandardCharsets.UTF_8);
    }

    public void setBucketPolicy(String bucketName, String policy) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("policy", "");
        HttpResponse response = this.executePut(bucketName, null, headerMap, queryParamMap, policy, 0);
        response.body().close();
    }

    public void setBucketLifeCycle(String bucketName, String lifeCycle) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidArgumentException, InvalidResponseException {
        if (lifeCycle == null || "".equals(lifeCycle)) {
            throw new InvalidArgumentException("life cycle cannot be empty");
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Length", Integer.toString(lifeCycle.length()));
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("lifecycle", "");
        HttpResponse response = this.executePut(bucketName, null, headerMap, queryParamMap, lifeCycle, 0);
        response.body().close();
    }

    public void deleteBucketLifeCycle(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("lifecycle", "");
        HttpResponse response = this.executeDelete(bucketName, "", queryParamMap);
        response.body().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBucketLifeCycle(String bucketName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("lifecycle", "");
        HttpResponse response = null;
        String bodyContent = "";
        Scanner scanner = null;
        try {
            response = this.executeGet(bucketName, "", null, queryParamMap);
            scanner = new Scanner(response.body().charStream());
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                bodyContent = scanner.next();
            }
        }
        catch (ErrorResponseException e) {
            if (e.errorResponse().errorCode() != ErrorCode.NO_SUCH_LIFECYCLE_CONFIGURATION) {
                throw e;
            }
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
            if (scanner != null) {
                scanner.close();
            }
        }
        return bodyContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationConfiguration getBucketNotification(String bucketName) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("notification", "");
        HttpResponse response = this.executeGet(bucketName, null, null, queryParamMap);
        NotificationConfiguration result = new NotificationConfiguration();
        try {
            result.parseXml(response.body().charStream());
        }
        finally {
            response.body().close();
        }
        return result;
    }

    public void setBucketNotification(String bucketName, NotificationConfiguration notificationConfiguration) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("notification", "");
        HttpResponse response = this.executePut(bucketName, null, null, queryParamMap, notificationConfiguration.toString(), 0);
        response.body().close();
    }

    public void removeAllBucketNotification(String bucketName) throws InvalidBucketNameException, InvalidObjectPrefixException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        NotificationConfiguration notificationConfiguration = new NotificationConfiguration();
        this.setBucketNotification(bucketName, notificationConfiguration);
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName) throws XmlPullParserException {
        return this.listIncompleteUploads(bucketName, null, true, true);
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName, String prefix) throws XmlPullParserException {
        return this.listIncompleteUploads(bucketName, prefix, true, true);
    }

    public Iterable<Result<Upload>> listIncompleteUploads(String bucketName, String prefix, boolean recursive) {
        return this.listIncompleteUploads(bucketName, prefix, recursive, true);
    }

    private Iterable<Result<Upload>> listIncompleteUploads(final String bucketName, final String prefix, final boolean recursive, final boolean aggregatePartSize) {
        return new Iterable<Result<Upload>>(){

            @Override
            public Iterator<Result<Upload>> iterator() {
                return new Iterator<Result<Upload>>(){
                    private String nextKeyMarker;
                    private String nextUploadIdMarker;
                    private ListMultipartUploadsResult listMultipartUploadsResult;
                    private Result<Upload> error;
                    private Iterator<Upload> uploadIterator;
                    private boolean completed = false;

                    private synchronized void populate() {
                        String delimiter = "/";
                        if (recursive) {
                            delimiter = null;
                        }
                        this.listMultipartUploadsResult = null;
                        this.uploadIterator = null;
                        try {
                            this.listMultipartUploadsResult = MinioClient.this.listIncompleteUploads(bucketName, this.nextKeyMarker, this.nextUploadIdMarker, prefix, delimiter, 1000);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                            this.error = new Result<Object>(null, (Exception)e);
                        }
                        finally {
                            this.uploadIterator = this.listMultipartUploadsResult != null ? this.listMultipartUploadsResult.uploads().iterator() : new LinkedList().iterator();
                        }
                    }

                    private synchronized long getAggregatedPartSize(String objectName, String uploadId) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException {
                        long aggregatedPartSize = 0L;
                        for (Result result : MinioClient.this.listObjectParts(bucketName, objectName, uploadId)) {
                            aggregatedPartSize += ((Part)((Object)result.get())).partSize();
                        }
                        return aggregatedPartSize;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.uploadIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.uploadIterator.hasNext() && this.listMultipartUploadsResult.isTruncated()) {
                            this.nextKeyMarker = this.listMultipartUploadsResult.nextKeyMarker();
                            this.nextUploadIdMarker = this.listMultipartUploadsResult.nextUploadIdMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.uploadIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Upload> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.uploadIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.uploadIterator.hasNext() && this.listMultipartUploadsResult.isTruncated()) {
                            this.nextKeyMarker = this.listMultipartUploadsResult.nextKeyMarker();
                            this.nextUploadIdMarker = this.listMultipartUploadsResult.nextUploadIdMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.uploadIterator.hasNext()) {
                            Upload upload = this.uploadIterator.next();
                            if (aggregatePartSize) {
                                long aggregatedPartSize;
                                try {
                                    aggregatedPartSize = this.getAggregatedPartSize(upload.objectName(), upload.uploadId());
                                }
                                catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                                    aggregatedPartSize = -1L;
                                }
                                upload.setAggregatedPartSize(aggregatedPartSize);
                            }
                            return new Result<Upload>(upload, null);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ListMultipartUploadsResult listIncompleteUploads(String bucketName, String keyMarker, String uploadIdMarker, String prefix, String delimiter, int maxUploads) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (maxUploads < 0 || maxUploads > 1000) {
            maxUploads = 1000;
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("uploads", "");
        queryParamMap.put("max-uploads", Integer.toString(maxUploads));
        if (prefix != null) {
            queryParamMap.put("prefix", prefix);
        } else {
            queryParamMap.put("prefix", "");
        }
        if (delimiter != null) {
            queryParamMap.put("delimiter", delimiter);
        } else {
            queryParamMap.put("delimiter", "");
        }
        if (keyMarker != null) {
            queryParamMap.put("key-marker", keyMarker);
        }
        if (uploadIdMarker != null) {
            queryParamMap.put("upload-id-marker", uploadIdMarker);
        }
        HttpResponse response = this.executeGet(bucketName, null, null, queryParamMap);
        ListMultipartUploadsResult result = new ListMultipartUploadsResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result;
    }

    private String initMultipartUpload(String bucketName, String objectName, Map<String, String> headerMap) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        if (headerMap.get("Content-Type") == null) {
            headerMap.put("Content-Type", "application/octet-stream");
        }
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put("uploads", "");
        HttpResponse response = this.executePost(bucketName, objectName, headerMap, queryParamMap, "");
        InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result.uploadId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeMultipart(String bucketName, String objectName, String uploadId, Part[] parts) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        ErrorResponse errorResponse;
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put(UPLOAD_ID, uploadId);
        CompleteMultipartUpload completeManifest = new CompleteMultipartUpload(parts);
        HttpResponse response = this.executePost(bucketName, objectName, null, queryParamMap, (Object)completeManifest);
        String bodyContent = "";
        Scanner scanner = new Scanner(response.body().charStream());
        try {
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                bodyContent = scanner.next();
            }
        }
        finally {
            response.body().close();
            scanner.close();
        }
        if (!(bodyContent = bodyContent.trim()).isEmpty() && (errorResponse = new ErrorResponse(new StringReader(bodyContent))).code() != null) {
            throw new ErrorResponseException(errorResponse, response.response());
        }
    }

    private Iterable<Result<Part>> listObjectParts(final String bucketName, final String objectName, final String uploadId) {
        return new Iterable<Result<Part>>(){

            @Override
            public Iterator<Result<Part>> iterator() {
                return new Iterator<Result<Part>>(){
                    private int nextPartNumberMarker;
                    private ListPartsResult listPartsResult;
                    private Result<Part> error;
                    private Iterator<Part> partIterator;
                    private boolean completed = false;

                    private synchronized void populate() {
                        this.listPartsResult = null;
                        this.partIterator = null;
                        try {
                            this.listPartsResult = MinioClient.this.listObjectParts(bucketName, objectName, uploadId, this.nextPartNumberMarker);
                        }
                        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | InvalidResponseException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                            this.error = new Result<Object>(null, (Exception)e);
                        }
                        finally {
                            this.partIterator = this.listPartsResult != null ? this.listPartsResult.partList().iterator() : new LinkedList().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.completed) {
                            return false;
                        }
                        if (this.error == null && this.partIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.partIterator.hasNext() && this.listPartsResult.isTruncated()) {
                            this.nextPartNumberMarker = this.listPartsResult.nextPartNumberMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            return true;
                        }
                        if (this.partIterator.hasNext()) {
                            return true;
                        }
                        this.completed = true;
                        return false;
                    }

                    @Override
                    public Result<Part> next() {
                        if (this.completed) {
                            throw new NoSuchElementException();
                        }
                        if (this.error == null && this.partIterator == null) {
                            this.populate();
                        }
                        if (this.error == null && !this.partIterator.hasNext() && this.listPartsResult.isTruncated()) {
                            this.nextPartNumberMarker = this.listPartsResult.nextPartNumberMarker();
                            this.populate();
                        }
                        if (this.error != null) {
                            this.completed = true;
                            return this.error;
                        }
                        if (this.partIterator.hasNext()) {
                            return new Result<Part>(this.partIterator.next(), null);
                        }
                        this.completed = true;
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ListPartsResult listObjectParts(String bucketName, String objectName, String uploadId, int partNumberMarker) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put(UPLOAD_ID, uploadId);
        if (partNumberMarker > 0) {
            queryParamMap.put("part-number-marker", Integer.toString(partNumberMarker));
        }
        HttpResponse response = this.executeGet(bucketName, objectName, null, queryParamMap);
        ListPartsResult result = new ListPartsResult();
        result.parseXml(response.body().charStream());
        response.body().close();
        return result;
    }

    private void abortMultipartUpload(String bucketName, String objectName, String uploadId) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMap<String, String> queryParamMap = new HashMap<String, String>();
        queryParamMap.put(UPLOAD_ID, uploadId);
        this.executeDelete(bucketName, objectName, queryParamMap);
    }

    public void removeIncompleteUpload(String bucketName, String objectName) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        for (Result<Upload> r : this.listIncompleteUploads(bucketName, objectName, true, false)) {
            Upload upload = r.get();
            if (!objectName.equals(upload.objectName())) continue;
            this.abortMultipartUpload(bucketName, objectName, upload.uploadId());
            return;
        }
    }

    public void listenBucketNotification(String bucketName, String prefix, String suffix, String[] events, BucketEventListener eventCallback) throws InvalidBucketNameException, NoSuchAlgorithmException, InsufficientDataException, IOException, InvalidKeyException, NoResponseException, XmlPullParserException, ErrorResponseException, InternalException, InvalidResponseException {
        HashMultimap queryParamMap = HashMultimap.create();
        queryParamMap.put((Object)"prefix", (Object)prefix);
        queryParamMap.put((Object)"suffix", (Object)suffix);
        for (String event : events) {
            queryParamMap.put((Object)"events", (Object)event);
        }
        String bodyContent = "";
        Scanner scanner = null;
        HttpResponse response = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            response = this.executeReq(Method.GET, this.getRegion(bucketName), bucketName, "", null, (Multimap<String, String>)queryParamMap, null, 0);
            scanner = new Scanner(response.body().charStream());
            scanner.useDelimiter("\n");
            while (scanner.hasNext()) {
                bodyContent = scanner.next().trim();
                if (bodyContent.equals("")) continue;
                NotificationInfo ni = (NotificationInfo)mapper.readValue(bodyContent, NotificationInfo.class);
                eventCallback.updateEvent(ni);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (response != null) {
                response.body().close();
            }
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private static int[] calculateMultipartSize(long size) throws InvalidArgumentException {
        double partCount;
        if (size > 0x50000000000L) {
            throw new InvalidArgumentException("size " + size + " is greater than allowed size 5TiB");
        }
        double partSize = Math.ceil((double)size / 10000.0);
        double lastPartSize = (partSize = Math.ceil(partSize / 5242880.0) * 5242880.0) - (partSize * (partCount = Math.ceil((double)size / partSize)) - (double)size);
        if (lastPartSize == 0.0) {
            lastPartSize = partSize;
        }
        return new int[]{(int)partSize, (int)partCount, (int)lastPartSize};
    }

    private int getAvailableSize(Object inputStream, int expectedReadSize) throws IOException, InternalException {
        int totalBytesRead;
        RandomAccessFile file = null;
        BufferedInputStream stream = null;
        if (inputStream instanceof RandomAccessFile) {
            file = (RandomAccessFile)inputStream;
        } else if (inputStream instanceof BufferedInputStream) {
            stream = (BufferedInputStream)inputStream;
        } else {
            throw new InternalException("Unknown input stream. This should not happen.  Please report to https://github.com/minio/minio-java/issues/");
        }
        long pos = 0L;
        if (file != null) {
            pos = file.getFilePointer();
        } else {
            stream.mark(expectedReadSize);
        }
        byte[] buf = new byte[16384];
        int bytesToRead = buf.length;
        int bytesRead = 0;
        for (totalBytesRead = 0; totalBytesRead < expectedReadSize; totalBytesRead += bytesRead) {
            if (expectedReadSize - totalBytesRead < bytesToRead) {
                bytesToRead = expectedReadSize - totalBytesRead;
            }
            if ((bytesRead = file != null ? file.read(buf, 0, bytesToRead) : stream.read(buf, 0, bytesToRead)) < 0) break;
        }
        if (file != null) {
            file.seek(pos);
        } else {
            stream.reset();
        }
        return totalBytesRead;
    }

    public void traceOn(OutputStream traceStream) {
        if (traceStream == null) {
            throw new NullPointerException();
        }
        this.traceStream = new PrintWriter((Writer)new OutputStreamWriter(traceStream, StandardCharsets.UTF_8), true);
    }

    public void traceOff() throws IOException {
        this.traceStream = null;
    }

    static {
        amzHeaders.add("server-side-encryption");
        amzHeaders.add("server-side-encryption-aws-kms-key-id");
        amzHeaders.add("server-side-encryption-context");
        amzHeaders.add("server-side-encryption-customer-algorithm");
        amzHeaders.add("server-side-encryption-customer-key");
        amzHeaders.add("server-side-encryption-customer-key-md5");
        amzHeaders.add("website-redirect-location");
        amzHeaders.add("storage-class");
        standardHeaders = new HashSet<String>();
        standardHeaders.add("content-type");
        standardHeaders.add("cache-control");
        standardHeaders.add("content-encoding");
        standardHeaders.add("content-disposition");
        standardHeaders.add("content-language");
        standardHeaders.add("expires");
        standardHeaders.add("range");
        try {
            xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(true);
        }
        catch (XmlPullParserException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

