/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;

class HttpRequestBody
extends RequestBody {
    private final String contentType;
    private final Object data;
    private final int len;

    HttpRequestBody(String contentType, Object data, int len) {
        this.contentType = contentType;
        this.data = data;
        this.len = len;
    }

    public MediaType contentType() {
        MediaType mediaType = null;
        if (this.contentType != null) {
            mediaType = MediaType.parse((String)this.contentType);
        }
        if (mediaType == null) {
            mediaType = MediaType.parse((String)"application/octet-stream");
        }
        return mediaType;
    }

    public long contentLength() {
        if (this.data instanceof InputStream || this.data instanceof RandomAccessFile || this.data instanceof byte[]) {
            return this.len;
        }
        if (this.len == 0) {
            return -1L;
        }
        return this.len;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.data instanceof InputStream) {
            InputStream stream = (InputStream)this.data;
            sink.writeAll(Okio.source((InputStream)stream));
        } else if (this.data instanceof RandomAccessFile) {
            RandomAccessFile file = (RandomAccessFile)this.data;
            sink.write(Okio.source((InputStream)Channels.newInputStream(file.getChannel())), (long)this.len);
        } else if (this.data instanceof byte[]) {
            byte[] bytes = (byte[])this.data;
            sink.write(bytes, 0, this.len);
        } else {
            sink.writeUtf8(this.data.toString());
        }
    }
}

