/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceFactories;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.OutputFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

public class NestedMultiOutput<K, V>
extends CommandOutput<K, V, List<Object>> {
    private final Deque<List<Object>> stack = LettuceFactories.newSpScQueue();
    private int depth = 0;
    private boolean initialized;

    public NestedMultiOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
    }

    @Override
    public void set(long integer) {
        if (!this.initialized) {
            this.output = new ArrayList();
        }
        ((List)this.output).add(integer);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (!this.initialized) {
            this.output = new ArrayList();
        }
        ((List)this.output).add(bytes == null ? null : (Object)this.codec.decodeValue(bytes));
    }

    @Override
    public void complete(int depth) {
        if (depth > 0 && depth < this.depth) {
            this.output = this.stack.pop();
            --this.depth;
        }
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(Math.max(1, count));
            this.initialized = true;
        }
        List a = OutputFactory.newList(count);
        ((List)this.output).add(a);
        this.stack.push((List<Object>)this.output);
        this.output = a;
        ++this.depth;
    }
}

