/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Kind2;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.Collections;
import javaslang.collection.Comparators;
import javaslang.collection.Iterator;
import javaslang.collection.Map;
import javaslang.collection.Maps;
import javaslang.collection.RedBlackTree;
import javaslang.collection.Seq;
import javaslang.collection.SortedMap;
import javaslang.collection.SortedSet;
import javaslang.collection.TreeSet;
import javaslang.control.Option;

public final class TreeMap<K, V>
implements Kind2<TreeMap<?, ?>, K, V>,
SortedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RedBlackTree<Tuple2<K, V>> entries;

    private TreeMap(RedBlackTree<Tuple2<K, V>> entries) {
        this.entries = entries;
    }

    public static <K, V> Collector<Tuple2<K, V>, ArrayList<Tuple2<K, V>>, TreeMap<K, V>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Tuple2> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Comparators.SerializableComparator comparator = Comparators.naturalComparator();
        Function<ArrayList, TreeMap> finisher = list -> TreeMap.ofEntries(comparator, list);
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> empty() {
        return TreeMap.empty(Comparable::compareTo);
    }

    public static <K, V> TreeMap<K, V> empty(Comparator<? super K> keyComparator) {
        Objects.requireNonNull(keyComparator, "keyComparator is null");
        return new TreeMap<K, V>(RedBlackTree.empty(new EntryComparator(keyComparator)));
    }

    public static <K, V> TreeMap<K, V> narrow(TreeMap<? extends K, ? extends V> treeMap) {
        return treeMap;
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> of(Tuple2<? extends K, ? extends V> entry) {
        return TreeMap.of(Comparable::compareTo, entry);
    }

    public static <K, V> TreeMap<K, V> of(Object ... pairs) {
        Objects.requireNonNull(pairs, "pairs is null");
        if ((pairs.length & 1) != 0) {
            throw new IllegalArgumentException("Odd length of key-value pairs list");
        }
        RedBlackTree<Tuple2<Object, Object>> result = RedBlackTree.empty();
        for (int i = 0; i < pairs.length; i += 2) {
            result = result.insert(Tuple.of(pairs[i], pairs[i + 1]));
        }
        return new TreeMap<K, V>(result);
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> ofAll(java.util.Map<? extends K, ? extends V> map) {
        Objects.requireNonNull(map, "map is null");
        RedBlackTree<Tuple2<K, V>> result = RedBlackTree.empty(new EntryComparator(Comparable::compareTo));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result = result.insert(Tuple.of(entry.getKey(), entry.getValue()));
        }
        return new TreeMap<K, V>(result);
    }

    public static <K, V> TreeMap<K, V> of(Comparator<? super K> keyComparator, Tuple2<? extends K, ? extends V> entry) {
        Objects.requireNonNull(keyComparator, "keyComparator is null");
        Objects.requireNonNull(entry, "entry is null");
        return TreeMap.empty(keyComparator).put(entry);
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> of(K key, V value) {
        return TreeMap.of(Comparable::compareTo, key, value);
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> of(Comparator<? super K> keyComparator, K key, V value) {
        Objects.requireNonNull(keyComparator, "keyComparator is null");
        return TreeMap.empty(keyComparator).put((Object)key, (Object)value);
    }

    public static <K, V> TreeMap<K, V> tabulate(Comparator<? super K> keyComparator, int n, Function<? super Integer, ? extends Tuple2<? extends K, ? extends V>> f) {
        Objects.requireNonNull(keyComparator, "keyComparator is null");
        Objects.requireNonNull(f, "f is null");
        return TreeMap.ofEntries(keyComparator, Collections.tabulate(n, f));
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> tabulate(int n, Function<? super Integer, ? extends Tuple2<? extends K, ? extends V>> f) {
        Objects.requireNonNull(f, "f is null");
        return TreeMap.tabulate(Comparable::compareTo, n, f);
    }

    public static <K, V> TreeMap<K, V> fill(Comparator<? super K> keyComparator, int n, Supplier<? extends Tuple2<? extends K, ? extends V>> s) {
        Objects.requireNonNull(keyComparator, "keyComparator is null");
        Objects.requireNonNull(s, "s is null");
        return TreeMap.ofEntries(keyComparator, Collections.fill(n, s));
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> fill(int n, Supplier<? extends Tuple2<? extends K, ? extends V>> s) {
        Objects.requireNonNull(s, "s is null");
        return TreeMap.fill(Comparable::compareTo, n, s);
    }

    @SafeVarargs
    public static <K extends Comparable<? super K>, V> TreeMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        return TreeMap.ofEntries(Comparable::compareTo, entries);
    }

    @SafeVarargs
    public static <K extends Comparable<? super K>, V> TreeMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        return TreeMap.ofEntries(Comparable::compareTo, entries);
    }

    @SafeVarargs
    public static <K, V> TreeMap<K, V> ofEntries(Comparator<? super K> keyComparator, Tuple2<? extends K, ? extends V> ... entries) {
        Objects.requireNonNull(keyComparator, "keyComparator is null");
        Objects.requireNonNull(entries, "entries is null");
        RedBlackTree<Tuple2<Object, Object>> tree = RedBlackTree.empty(new EntryComparator(keyComparator));
        for (Tuple2<? extends K, ? extends V> entry : entries) {
            tree = tree.insert(entry);
        }
        return tree.isEmpty() ? TreeMap.empty(keyComparator) : new TreeMap<K, V>(tree);
    }

    @SafeVarargs
    public static <K, V> TreeMap<K, V> ofEntries(Comparator<? super K> keyComparator, Map.Entry<? extends K, ? extends V> ... entries) {
        Objects.requireNonNull(keyComparator, "keyComparator is null");
        Objects.requireNonNull(entries, "entries is null");
        RedBlackTree<Tuple2<K, V>> tree = RedBlackTree.empty(new EntryComparator(keyComparator));
        for (Map.Entry<K, V> entry : entries) {
            tree = tree.insert(Tuple.of(entry.getKey(), entry.getValue()));
        }
        return tree.isEmpty() ? TreeMap.empty(keyComparator) : new TreeMap<K, V>(tree);
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> ofEntries(Iterable<? extends Tuple2<? extends K, ? extends V>> entries) {
        return TreeMap.ofEntries(Comparable::compareTo, entries);
    }

    public static <K, V> TreeMap<K, V> ofEntries(Comparator<? super K> keyComparator, Iterable<? extends Tuple2<? extends K, ? extends V>> entries) {
        Objects.requireNonNull(keyComparator, "keyComparator is null");
        Objects.requireNonNull(entries, "entries is null");
        if (entries instanceof TreeMap) {
            return (TreeMap)entries;
        }
        RedBlackTree<Tuple2<K, V>> tree = RedBlackTree.empty(new EntryComparator(keyComparator));
        for (Tuple2<K, V> tuple2 : entries) {
            tree = tree.insert(tuple2);
        }
        return new TreeMap<K, V>(tree);
    }

    @Override
    public <K2, V2> TreeMap<K2, V2> bimap(Function<? super K, ? extends K2> keyMapper, Function<? super V, ? extends V2> valueMapper) {
        return this.bimap((Comparator)Comparators.naturalComparator(), (Function)keyMapper, (Function)valueMapper);
    }

    @Override
    public <K2, V2> TreeMap<K2, V2> bimap(Comparator<? super K2> keyComparator, Function<? super K, ? extends K2> keyMapper, Function<? super V, ? extends V2> valueMapper) {
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        return TreeMap.createTreeMap(new EntryComparator(keyComparator), this.entries.iterator().map((T entry) -> Tuple.of(keyMapper.apply((Object)entry._1), valueMapper.apply((Object)entry._2))));
    }

    @Override
    public boolean containsKey(K key) {
        Object ignored = null;
        return this.entries.contains(new Tuple2<K, Object>(key, ignored));
    }

    @Override
    public TreeMap<K, V> distinct() {
        return Maps.distinct(this);
    }

    @Override
    public TreeMap<K, V> distinctBy(Comparator<? super Tuple2<K, V>> comparator) {
        return Maps.distinctBy(this, this::createFromEntries, comparator);
    }

    @Override
    public <U> TreeMap<K, V> distinctBy(Function<? super Tuple2<K, V>, ? extends U> keyExtractor) {
        return Maps.distinctBy(this, this::createFromEntries, keyExtractor);
    }

    @Override
    public TreeMap<K, V> drop(long n) {
        return Maps.drop(this, this::createFromEntries, this::emptyInstance, n);
    }

    @Override
    public TreeMap<K, V> dropRight(long n) {
        return Maps.dropRight(this, this::createFromEntries, this::emptyInstance, n);
    }

    @Override
    public TreeMap<K, V> dropUntil(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.dropUntil(this, this::createFromEntries, predicate);
    }

    @Override
    public TreeMap<K, V> dropWhile(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.dropWhile(this, this::createFromEntries, predicate);
    }

    @Override
    public TreeMap<K, V> filter(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.filter(this, this::createFromEntries, predicate);
    }

    @Override
    public <K2, V2> TreeMap<K2, V2> flatMap(BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> mapper) {
        return this.flatMap((Comparator)Comparators.naturalComparator(), (BiFunction)mapper);
    }

    @Override
    public <K2, V2> TreeMap<K2, V2> flatMap(Comparator<? super K2> keyComparator, BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeMap.createTreeMap(new EntryComparator(keyComparator), this.entries.iterator().flatMap((T entry) -> (Iterable)mapper.apply((Object)entry._1, (Object)entry._2)));
    }

    @Override
    public Option<V> get(K key) {
        Object ignored = null;
        return this.entries.find(new Tuple2<K, Object>(key, ignored)).map(Tuple2::_2);
    }

    @Override
    public <C> Map<C, TreeMap<K, V>> groupBy(Function<? super Tuple2<K, V>, ? extends C> classifier) {
        return Maps.groupBy(this, this::createFromEntries, classifier);
    }

    @Override
    public Iterator<TreeMap<K, V>> grouped(long size) {
        return Maps.grouped(this, this::createFromEntries, size);
    }

    @Override
    public Tuple2<K, V> head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty TreeMap");
        }
        return this.entries.min().get();
    }

    @Override
    public TreeMap<K, V> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty TreeMap");
        }
        Tuple2<K, V> max = this.entries.max().get();
        return new TreeMap<K, V>(this.entries.delete(max));
    }

    @Override
    public Option<TreeMap<K, V>> initOption() {
        return Maps.initOption(this);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Comparator<K> keyComparator() {
        return ((EntryComparator)this.entries.comparator()).keyComparator;
    }

    @Override
    public SortedSet<K> keySet() {
        return TreeSet.ofAll(this.keyComparator(), this.iterator().map(Tuple2::_1));
    }

    @Override
    public <K2, V2> TreeMap<K2, V2> map(BiFunction<? super K, ? super V, Tuple2<K2, V2>> mapper) {
        return this.map((Comparator)Comparators.naturalComparator(), (BiFunction)mapper);
    }

    @Override
    public <K2, V2> TreeMap<K2, V2> map(Comparator<? super K2> keyComparator, BiFunction<? super K, ? super V, Tuple2<K2, V2>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeMap.createTreeMap(new EntryComparator(keyComparator), this.entries.iterator().map((T entry) -> (Tuple2)mapper.apply((Object)entry._1, (Object)entry._2)));
    }

    @Override
    public <W> TreeMap<K, W> mapValues(Function<? super V, ? extends W> valueMapper) {
        Objects.requireNonNull(valueMapper, "valueMapper is null");
        return this.map(this.keyComparator(), (T k, U v) -> Tuple.of(k, valueMapper.apply((Object)v)));
    }

    @Override
    public TreeMap<K, V> merge(Map<? extends K, ? extends V> that) {
        return Maps.merge(this, this::createFromEntries, that);
    }

    @Override
    public <U extends V> TreeMap<K, V> merge(Map<? extends K, U> that, BiFunction<? super V, ? super U, ? extends V> collisionResolution) {
        return Maps.merge(this, this::createFromEntries, that, collisionResolution);
    }

    @Override
    public Tuple2<TreeMap<K, V>, TreeMap<K, V>> partition(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.partition(this, this::createFromEntries, predicate);
    }

    @Override
    public TreeMap<K, V> peek(Consumer<? super Tuple2<K, V>> action) {
        return Maps.peek(this, action);
    }

    @Override
    public TreeMap<K, V> put(K key, V value) {
        return new TreeMap<K, V>(this.entries.insert(new Tuple2<K, V>(key, value)));
    }

    @Override
    public TreeMap<K, V> put(Tuple2<? extends K, ? extends V> entry) {
        return Maps.put(this, entry);
    }

    @Override
    public TreeMap<K, V> remove(K key) {
        Object ignored = null;
        Tuple2<K, Object> entry = new Tuple2<K, Object>(key, ignored);
        if (this.entries.contains(entry)) {
            return new TreeMap<K, V>(this.entries.delete(entry));
        }
        return this;
    }

    @Override
    public TreeMap<K, V> removeAll(Iterable<? extends K> keys) {
        Object ignored = null;
        RedBlackTree<Tuple2<K, Object>> removed = this.entries;
        for (K key : keys) {
            Tuple2<K, Object> entry = new Tuple2<K, Object>(key, ignored);
            if (!removed.contains(entry)) continue;
            removed = removed.delete(entry);
        }
        if (removed.size() == this.entries.size()) {
            return this;
        }
        return new TreeMap<K, V>(removed);
    }

    @Override
    public TreeMap<K, V> replace(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return Maps.replace(this, currentElement, newElement);
    }

    @Override
    public TreeMap<K, V> replaceAll(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return Maps.replaceAll(this, currentElement, newElement);
    }

    @Override
    public TreeMap<K, V> retainAll(Iterable<? extends Tuple2<K, V>> elements) {
        Objects.requireNonNull(elements, "elements is null");
        RedBlackTree<Tuple2<K, V>> tree = RedBlackTree.empty(this.entries.comparator());
        for (Tuple2<K, V> entry : elements) {
            if (!this.contains(entry)) continue;
            tree = tree.insert(entry);
        }
        return new TreeMap<K, V>(tree);
    }

    @Override
    public TreeMap<K, V> scan(Tuple2<K, V> zero, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> operation) {
        return Maps.scan(this, this::emptyInstance, zero, operation);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<TreeMap<K, V>> sliding(long size) {
        return Maps.sliding(this, this::createFromEntries, size);
    }

    @Override
    public Iterator<TreeMap<K, V>> sliding(long size, long step) {
        return Maps.sliding(this, this::createFromEntries, size, step);
    }

    @Override
    public Tuple2<TreeMap<K, V>, TreeMap<K, V>> span(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.span(this, this::createFromEntries, predicate);
    }

    @Override
    public TreeMap<K, V> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty TreeMap");
        }
        Tuple2<K, V> min = this.entries.min().get();
        return new TreeMap<K, V>(this.entries.delete(min));
    }

    @Override
    public Option<TreeMap<K, V>> tailOption() {
        return Maps.tailOption(this);
    }

    @Override
    public TreeMap<K, V> take(long n) {
        return Maps.take(this, this::createFromEntries, n);
    }

    @Override
    public TreeMap<K, V> takeRight(long n) {
        return Maps.takeRight(this, this::createFromEntries, n);
    }

    @Override
    public TreeMap<K, V> takeUntil(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.takeUntil(this, this::createFromEntries, predicate);
    }

    @Override
    public TreeMap<K, V> takeWhile(Predicate<? super Tuple2<K, V>> predicate) {
        return Maps.takeWhile(this, this::createFromEntries, predicate);
    }

    @Override
    public java.util.TreeMap<K, V> toJavaMap() {
        return this.toJavaMap(() -> new java.util.TreeMap(this.keyComparator()), t -> t);
    }

    @Override
    public Seq<V> values() {
        return this.iterator().map(Tuple2::_2).toStream();
    }

    private static <K, V> TreeMap<K, V> createTreeMap(Comparator<? super Tuple2<K, V>> comparator, Iterable<? extends Tuple2<? extends K, ? extends V>> entries) {
        RedBlackTree<Tuple2<K, V>> tree = RedBlackTree.empty(comparator);
        for (Tuple2<K, V> tuple2 : entries) {
            tree = tree.insert(tuple2);
        }
        return tree.isEmpty() ? TreeMap.empty() : new TreeMap<K, V>(tree);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TreeMap) {
            TreeMap that = (TreeMap)o;
            return this.entries.equals(that.entries);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public String stringPrefix() {
        return "TreeMap";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private TreeMap<K, V> createFromEntries(Iterable<Tuple2<K, V>> tuples) {
        return TreeMap.createTreeMap(this.entries.comparator(), tuples);
    }

    private TreeMap<K, V> emptyInstance() {
        return this.isEmpty() ? this : new TreeMap<K, V>(this.entries.emptyInstance());
    }

    static class EntryComparator<K, V>
    implements Comparator<Tuple2<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Comparator<K> keyComparator;

        EntryComparator(Comparator<? super K> keyComparator) {
            this.keyComparator = keyComparator;
        }

        @Override
        public int compare(Tuple2<K, V> e1, Tuple2<K, V> e2) {
            return this.keyComparator.compare(e1._1, e2._1);
        }
    }
}

