/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.spring.elasticsearch;

import fr.pilato.elasticsearch.tools.alias.AliasElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.index.IndexElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.index.IndexFinder;
import fr.pilato.elasticsearch.tools.template.TemplateElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.template.TemplateFinder;
import fr.pilato.elasticsearch.tools.type.TypeElasticsearchUpdater;
import fr.pilato.elasticsearch.tools.type.TypeFinder;
import fr.pilato.spring.elasticsearch.ElasticsearchAbstractFactoryBean;
import fr.pilato.spring.elasticsearch.proxy.GenericInvocationHandler;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class ElasticsearchAbstractClientFactoryBean
extends ElasticsearchAbstractFactoryBean
implements FactoryBean<Client>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LogManager.getLogger(ElasticsearchAbstractClientFactoryBean.class);
    protected Client client;
    protected Client proxyfiedClient;
    protected boolean forceMapping;
    protected boolean forceTemplate;
    protected boolean mergeMapping;
    protected boolean mergeSettings = true;
    protected boolean autoscan = true;
    protected String[] mappings;
    protected String[] aliases;
    protected String[] templates;
    protected String classpathRoot = "es";

    protected abstract Client buildClient() throws Exception;

    public void setForceMapping(boolean forceMapping) {
        this.forceMapping = forceMapping;
    }

    public void setForceTemplate(boolean forceTemplate) {
        this.forceTemplate = forceTemplate;
    }

    public void setMergeMapping(boolean mergeMapping) {
        this.mergeMapping = mergeMapping;
    }

    public void setMergeSettings(boolean mergeSettings) {
        this.mergeSettings = mergeSettings;
    }

    public void setAutoscan(boolean autoscan) {
        this.autoscan = autoscan;
    }

    public void setMappings(String[] mappings) {
        this.mappings = mappings;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public void setTemplates(String[] templates) {
        this.templates = templates;
    }

    public void setClasspathRoot(String classpathRoot) {
        this.classpathRoot = classpathRoot.startsWith("/") ? classpathRoot.substring(1, classpathRoot.length()) : classpathRoot;
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("Starting ElasticSearch client");
        if (this.async) {
            Assert.notNull((Object)this.taskExecutor);
            Future future = this.taskExecutor.submit((Callable)new Callable<Client>(){

                @Override
                public Client call() throws Exception {
                    return ElasticsearchAbstractClientFactoryBean.this.initialize();
                }
            });
            this.proxyfiedClient = (Client)Proxy.newProxyInstance(Client.class.getClassLoader(), new Class[]{Client.class}, new GenericInvocationHandler(future));
        } else {
            this.client = this.initialize();
        }
    }

    private Client initialize() throws Exception {
        this.client = this.buildClient();
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().get();
        if (this.autoscan) {
            this.computeMappings();
            this.computeTemplates();
        }
        this.initTemplates();
        this.initMappings();
        this.initAliases();
        return this.client;
    }

    public void destroy() throws Exception {
        try {
            logger.info("Closing ElasticSearch client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public Client getObject() throws Exception {
        return this.async ? this.proxyfiedClient : this.client;
    }

    public Class<Client> getObjectType() {
        return Client.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void initTemplates() throws Exception {
        if (this.templates != null && this.templates.length > 0) {
            for (int i = 0; i < this.templates.length; ++i) {
                String template = this.templates[i];
                Assert.hasText((String)template, (String)("Can not read template in [" + this.templates[i] + "]. Check that templates is not empty."));
                TemplateElasticsearchUpdater.createTemplate((Client)this.client, (String)this.classpathRoot, (String)template, (boolean)this.forceTemplate);
            }
        }
    }

    private void computeMappings() {
        if (this.mappings == null || this.mappings.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Automatic discovery is activated. Looking for definition files in classpath under [{}].", new Object[]{this.classpathRoot});
            }
            ArrayList<String> autoMappings = new ArrayList<String>();
            try {
                List indices = IndexFinder.findIndexNames((String)this.classpathRoot);
                for (String index : indices) {
                    List types = TypeFinder.findTypes((String)this.classpathRoot, (String)index);
                    if (types.isEmpty()) {
                        autoMappings.add(index);
                        continue;
                    }
                    for (String type : types) {
                        autoMappings.add(index + "/" + type);
                    }
                }
                this.mappings = autoMappings.toArray(new String[autoMappings.size()]);
            }
            catch (IOException | URISyntaxException e) {
                logger.debug("Automatic discovery does not succeed for finding json files in classpath under " + this.classpathRoot + ".");
                logger.trace((Object)e);
            }
        }
    }

    private void computeTemplates() {
        if (this.templates == null || this.templates.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Automatic discovery is activated. Looking for template files in classpath under [{}].", new Object[]{this.classpathRoot});
            }
            ArrayList<String> autoTemplates = new ArrayList<String>();
            try {
                List scannedTemplates = TemplateFinder.findTemplates((String)this.classpathRoot);
                for (String template : scannedTemplates) {
                    autoTemplates.add(template);
                }
                this.templates = autoTemplates.toArray(new String[autoTemplates.size()]);
            }
            catch (IOException | URISyntaxException e) {
                logger.debug("Automatic discovery does not succeed for finding json files in classpath under " + this.classpathRoot + ".");
                logger.trace((Object)e);
            }
        }
    }

    private void initMappings() throws Exception {
        this.checkClient();
        if (this.mappings != null && this.mappings.length > 0) {
            HashMap indexes = new HashMap();
            for (int i = 0; i < this.mappings.length; ++i) {
                String indexmapping = this.mappings[i];
                String[] indexmappingsplitted = indexmapping.split("/");
                String index = indexmappingsplitted[0];
                if (index == null) {
                    throw new Exception("Can not read index in [" + indexmapping + "]. Check that mappings contains only indexname/mappingname elements.");
                }
                if (!indexes.containsKey(index)) {
                    indexes.put(index, new ArrayList());
                }
                if (indexmappingsplitted.length <= 1) continue;
                String mapping = indexmappingsplitted[1];
                ((Collection)indexes.get(index)).add(mapping);
            }
            for (String index : indexes.keySet()) {
                IndexElasticsearchUpdater.createIndex((Client)this.client, (String)this.classpathRoot, (String)index);
                if (this.mergeSettings) {
                    IndexElasticsearchUpdater.updateSettings((Client)this.client, (String)this.classpathRoot, (String)index);
                }
                Collection mappings = (Collection)indexes.get(index);
                for (String type : mappings) {
                    TypeElasticsearchUpdater.createMapping((Client)this.client, (String)this.classpathRoot, (String)index, (String)type, (boolean)this.mergeMapping, (boolean)this.forceMapping);
                }
            }
        }
    }

    private void initAliases() throws Exception {
        if (this.aliases != null && this.aliases.length > 0) {
            for (int i = 0; i < this.aliases.length; ++i) {
                String[] aliasessplitted = this.aliases[i].split(":");
                String alias = aliasessplitted[0];
                String index = aliasessplitted[1];
                if (index == null) {
                    throw new Exception("Can not read index in [" + this.aliases[i] + "]. Check that aliases contains only aliasname:indexname elements.");
                }
                if (alias == null) {
                    throw new Exception("Can not read mapping in [" + this.aliases[i] + "]. Check that aliases contains only aliasname:indexname elements.");
                }
                AliasElasticsearchUpdater.createAlias((Client)this.client, (String)alias, (String)index);
            }
        }
    }

    private void checkClient() throws Exception {
        if (this.client == null) {
            throw new Exception("ElasticSearch client doesn't exist. Your factory is not properly initialized.");
        }
    }
}

