/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.RouterPrx;
import com.zeroc.Ice.UnknownUserException;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AllocationException;
import com.zeroc.IceGrid.ObjectNotRegisteredException;
import com.zeroc.IceGrid._SessionPrxI;
import com.zeroc.IceInternal.OutgoingAsync;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface SessionPrx
extends com.zeroc.Glacier2.SessionPrx {
    public static final Class<?>[] _iceE_allocateObjectById = new Class[]{AllocationException.class, ObjectNotRegisteredException.class};
    public static final Class<?>[] _iceE_allocateObjectByType = new Class[]{AllocationException.class};
    public static final Class<?>[] _iceE_releaseObject = new Class[]{AllocationException.class, ObjectNotRegisteredException.class};

    default public void keepAlive() {
        this.keepAlive(ObjectPrx.noExplicitContext);
    }

    default public void keepAlive(Map<String, String> context) {
        this._iceI_keepAliveAsync(context, true).waitForResponse();
    }

    default public CompletableFuture<Void> keepAliveAsync() {
        return this._iceI_keepAliveAsync(ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> keepAliveAsync(Map<String, String> context) {
        return this._iceI_keepAliveAsync(context, false);
    }

    default public OutgoingAsync<Void> _iceI_keepAliveAsync(Map<String, String> context, boolean sync) {
        OutgoingAsync f = new OutgoingAsync((ObjectPrx)this, "keepAlive", OperationMode.Idempotent, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    default public ObjectPrx allocateObjectById(Identity id) throws AllocationException, ObjectNotRegisteredException {
        return this.allocateObjectById(id, ObjectPrx.noExplicitContext);
    }

    default public ObjectPrx allocateObjectById(Identity id, Map<String, String> context) throws AllocationException, ObjectNotRegisteredException {
        try {
            return (ObjectPrx)this._iceI_allocateObjectByIdAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch (AllocationException ex) {
            throw ex;
        }
        catch (ObjectNotRegisteredException ex) {
            throw ex;
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), (Throwable)ex);
        }
    }

    default public CompletableFuture<ObjectPrx> allocateObjectByIdAsync(Identity id) {
        return this._iceI_allocateObjectByIdAsync(id, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<ObjectPrx> allocateObjectByIdAsync(Identity id, Map<String, String> context) {
        return this._iceI_allocateObjectByIdAsync(id, context, false);
    }

    default public OutgoingAsync<ObjectPrx> _iceI_allocateObjectByIdAsync(Identity iceP_id, Map<String, String> context, boolean sync) {
        OutgoingAsync f = new OutgoingAsync((ObjectPrx)this, "allocateObjectById", null, sync, (Class[])_iceE_allocateObjectById);
        f.invoke(true, context, null, ostr -> Identity.ice_write((OutputStream)ostr, (Identity)iceP_id), istr -> {
            ObjectPrx ret = istr.readProxy();
            return ret;
        });
        return f;
    }

    default public ObjectPrx allocateObjectByType(String type) throws AllocationException {
        return this.allocateObjectByType(type, ObjectPrx.noExplicitContext);
    }

    default public ObjectPrx allocateObjectByType(String type, Map<String, String> context) throws AllocationException {
        try {
            return (ObjectPrx)this._iceI_allocateObjectByTypeAsync(type, context, true).waitForResponseOrUserEx();
        }
        catch (AllocationException ex) {
            throw ex;
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), (Throwable)ex);
        }
    }

    default public CompletableFuture<ObjectPrx> allocateObjectByTypeAsync(String type) {
        return this._iceI_allocateObjectByTypeAsync(type, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<ObjectPrx> allocateObjectByTypeAsync(String type, Map<String, String> context) {
        return this._iceI_allocateObjectByTypeAsync(type, context, false);
    }

    default public OutgoingAsync<ObjectPrx> _iceI_allocateObjectByTypeAsync(String iceP_type, Map<String, String> context, boolean sync) {
        OutgoingAsync f = new OutgoingAsync((ObjectPrx)this, "allocateObjectByType", null, sync, (Class[])_iceE_allocateObjectByType);
        f.invoke(true, context, null, ostr -> ostr.writeString(iceP_type), istr -> {
            ObjectPrx ret = istr.readProxy();
            return ret;
        });
        return f;
    }

    default public void releaseObject(Identity id) throws AllocationException, ObjectNotRegisteredException {
        this.releaseObject(id, ObjectPrx.noExplicitContext);
    }

    default public void releaseObject(Identity id, Map<String, String> context) throws AllocationException, ObjectNotRegisteredException {
        try {
            this._iceI_releaseObjectAsync(id, context, true).waitForResponseOrUserEx();
        }
        catch (AllocationException ex) {
            throw ex;
        }
        catch (ObjectNotRegisteredException ex) {
            throw ex;
        }
        catch (UserException ex) {
            throw new UnknownUserException(ex.ice_id(), (Throwable)ex);
        }
    }

    default public CompletableFuture<Void> releaseObjectAsync(Identity id) {
        return this._iceI_releaseObjectAsync(id, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> releaseObjectAsync(Identity id, Map<String, String> context) {
        return this._iceI_releaseObjectAsync(id, context, false);
    }

    default public OutgoingAsync<Void> _iceI_releaseObjectAsync(Identity iceP_id, Map<String, String> context, boolean sync) {
        OutgoingAsync f = new OutgoingAsync((ObjectPrx)this, "releaseObject", null, sync, (Class[])_iceE_releaseObject);
        f.invoke(true, context, null, ostr -> Identity.ice_write((OutputStream)ostr, (Identity)iceP_id), null);
        return f;
    }

    default public void setAllocationTimeout(int timeout) {
        this.setAllocationTimeout(timeout, ObjectPrx.noExplicitContext);
    }

    default public void setAllocationTimeout(int timeout, Map<String, String> context) {
        this._iceI_setAllocationTimeoutAsync(timeout, context, true).waitForResponse();
    }

    default public CompletableFuture<Void> setAllocationTimeoutAsync(int timeout) {
        return this._iceI_setAllocationTimeoutAsync(timeout, ObjectPrx.noExplicitContext, false);
    }

    default public CompletableFuture<Void> setAllocationTimeoutAsync(int timeout, Map<String, String> context) {
        return this._iceI_setAllocationTimeoutAsync(timeout, context, false);
    }

    default public OutgoingAsync<Void> _iceI_setAllocationTimeoutAsync(int iceP_timeout, Map<String, String> context, boolean sync) {
        OutgoingAsync f = new OutgoingAsync((ObjectPrx)this, "setAllocationTimeout", OperationMode.Idempotent, sync, null);
        f.invoke(false, context, null, ostr -> ostr.writeInt(iceP_timeout), null);
        return f;
    }

    public static SessionPrx checkedCast(ObjectPrx obj) {
        return (SessionPrx)ObjectPrx._checkedCast((ObjectPrx)obj, (String)SessionPrx.ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx checkedCast(ObjectPrx obj, Map<String, String> context) {
        return (SessionPrx)ObjectPrx._checkedCast((ObjectPrx)obj, context, (String)SessionPrx.ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx checkedCast(ObjectPrx obj, String facet) {
        return (SessionPrx)ObjectPrx._checkedCast((ObjectPrx)obj, (String)facet, (String)SessionPrx.ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx checkedCast(ObjectPrx obj, String facet, Map<String, String> context) {
        return (SessionPrx)ObjectPrx._checkedCast((ObjectPrx)obj, (String)facet, context, (String)SessionPrx.ice_staticId(), SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx uncheckedCast(ObjectPrx obj) {
        return (SessionPrx)ObjectPrx._uncheckedCast((ObjectPrx)obj, SessionPrx.class, _SessionPrxI.class);
    }

    public static SessionPrx uncheckedCast(ObjectPrx obj, String facet) {
        return (SessionPrx)ObjectPrx._uncheckedCast((ObjectPrx)obj, (String)facet, SessionPrx.class, _SessionPrxI.class);
    }

    default public SessionPrx ice_context(Map<String, String> newContext) {
        return (SessionPrx)this._ice_context(newContext);
    }

    default public SessionPrx ice_adapterId(String newAdapterId) {
        return (SessionPrx)this._ice_adapterId(newAdapterId);
    }

    default public SessionPrx ice_endpoints(Endpoint[] newEndpoints) {
        return (SessionPrx)this._ice_endpoints(newEndpoints);
    }

    default public SessionPrx ice_locatorCacheTimeout(int newTimeout) {
        return (SessionPrx)this._ice_locatorCacheTimeout(newTimeout);
    }

    default public SessionPrx ice_invocationTimeout(int newTimeout) {
        return (SessionPrx)this._ice_invocationTimeout(newTimeout);
    }

    default public SessionPrx ice_connectionCached(boolean newCache) {
        return (SessionPrx)this._ice_connectionCached(newCache);
    }

    default public SessionPrx ice_endpointSelection(EndpointSelectionType newType) {
        return (SessionPrx)this._ice_endpointSelection(newType);
    }

    default public SessionPrx ice_secure(boolean b) {
        return (SessionPrx)this._ice_secure(b);
    }

    default public SessionPrx ice_encodingVersion(EncodingVersion e) {
        return (SessionPrx)this._ice_encodingVersion(e);
    }

    default public SessionPrx ice_preferSecure(boolean b) {
        return (SessionPrx)this._ice_preferSecure(b);
    }

    default public SessionPrx ice_router(RouterPrx router) {
        return (SessionPrx)this._ice_router(router);
    }

    default public SessionPrx ice_locator(LocatorPrx locator) {
        return (SessionPrx)this._ice_locator(locator);
    }

    default public SessionPrx ice_collocationOptimized(boolean b) {
        return (SessionPrx)this._ice_collocationOptimized(b);
    }

    default public SessionPrx ice_twoway() {
        return (SessionPrx)this._ice_twoway();
    }

    default public SessionPrx ice_oneway() {
        return (SessionPrx)this._ice_oneway();
    }

    default public SessionPrx ice_batchOneway() {
        return (SessionPrx)this._ice_batchOneway();
    }

    default public SessionPrx ice_datagram() {
        return (SessionPrx)this._ice_datagram();
    }

    default public SessionPrx ice_batchDatagram() {
        return (SessionPrx)this._ice_batchDatagram();
    }

    default public SessionPrx ice_compress(boolean co) {
        return (SessionPrx)this._ice_compress(co);
    }

    default public SessionPrx ice_timeout(int t) {
        return (SessionPrx)this._ice_timeout(t);
    }

    default public SessionPrx ice_connectionId(String connectionId) {
        return (SessionPrx)this._ice_connectionId(connectionId);
    }

    public static String ice_staticId() {
        return "::IceGrid::Session";
    }
}

