/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AllocationException;
import com.zeroc.IceGrid.ObjectNotRegisteredException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface Session
extends com.zeroc.Glacier2.Session {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public void keepAlive(Current var1);

    public CompletionStage<ObjectPrx> allocateObjectByIdAsync(Identity var1, Current var2) throws AllocationException, ObjectNotRegisteredException;

    public CompletionStage<ObjectPrx> allocateObjectByTypeAsync(String var1, Current var2) throws AllocationException;

    public void releaseObject(Identity var1, Current var2) throws AllocationException, ObjectNotRegisteredException;

    public void setAllocationTimeout(int var1, Current var2);

    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    default public String ice_id(Current current) {
        return Session.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::Session";
    }

    public static CompletionStage<OutputStream> _iceD_keepAlive(Session obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        inS.readEmptyParams();
        obj.keepAlive(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_allocateObjectById(Session obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        Identity iceP_id = Identity.ice_read((InputStream)istr);
        inS.endReadParams();
        return inS.setResultFuture(obj.allocateObjectByIdAsync(iceP_id, current), (ostr, ret) -> ostr.writeProxy(ret));
    }

    public static CompletionStage<OutputStream> _iceD_allocateObjectByType(Session obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_type = istr.readString();
        inS.endReadParams();
        return inS.setResultFuture(obj.allocateObjectByTypeAsync(iceP_type, current), (ostr, ret) -> ostr.writeProxy(ret));
    }

    public static CompletionStage<OutputStream> _iceD_releaseObject(Session obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        Identity iceP_id = Identity.ice_read((InputStream)istr);
        inS.endReadParams();
        obj.releaseObject(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_setAllocationTimeout(Session obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        int iceP_timeout = istr.readInt();
        inS.endReadParams();
        obj.setAllocationTimeout(iceP_timeout, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Session._iceD_allocateObjectById(this, in, current);
            }
            case 1: {
                return Session._iceD_allocateObjectByType(this, in, current);
            }
            case 2: {
                return com.zeroc.Glacier2.Session._iceD_destroy((com.zeroc.Glacier2.Session)this, (Incoming)in, (Current)current);
            }
            case 3: {
                return Object._iceD_ice_id((Object)this, (Incoming)in, (Current)current);
            }
            case 4: {
                return Object._iceD_ice_ids((Object)this, (Incoming)in, (Current)current);
            }
            case 5: {
                return Object._iceD_ice_isA((Object)this, (Incoming)in, (Current)current);
            }
            case 6: {
                return Object._iceD_ice_ping((Object)this, (Incoming)in, (Current)current);
            }
            case 7: {
                return Session._iceD_keepAlive(this, in, current);
            }
            case 8: {
                return Session._iceD_releaseObject(this, in, current);
            }
            case 9: {
                return Session._iceD_setAllocationTimeout(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Glacier2::Session", "::Ice::Object", "::IceGrid::Session"};
        _iceOps = new String[]{"allocateObjectById", "allocateObjectByType", "destroy", "ice_id", "ice_ids", "ice_isA", "ice_ping", "keepAlive", "releaseObject", "setAllocationTimeout"};
    }
}

