/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.AdminSessionPrx;
import com.zeroc.IceGrid.PermissionDeniedException;
import com.zeroc.IceGrid.SessionPrx;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface Registry
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public SessionPrx createSession(String var1, String var2, Current var3) throws PermissionDeniedException;

    public AdminSessionPrx createAdminSession(String var1, String var2, Current var3) throws PermissionDeniedException;

    public SessionPrx createSessionFromSecureConnection(Current var1) throws PermissionDeniedException;

    public AdminSessionPrx createAdminSessionFromSecureConnection(Current var1) throws PermissionDeniedException;

    public int getSessionTimeout(Current var1);

    public int getACMTimeout(Current var1);

    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    default public String ice_id(Current current) {
        return Registry.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::Registry";
    }

    public static CompletionStage<OutputStream> _iceD_createSession(Registry obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_userId = istr.readString();
        String iceP_password = istr.readString();
        inS.endReadParams();
        SessionPrx ret = obj.createSession(iceP_userId, iceP_password, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_createAdminSession(Registry obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_userId = istr.readString();
        String iceP_password = istr.readString();
        inS.endReadParams();
        AdminSessionPrx ret = obj.createAdminSession(iceP_userId, iceP_password, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_createSessionFromSecureConnection(Registry obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        inS.readEmptyParams();
        SessionPrx ret = obj.createSessionFromSecureConnection(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_createAdminSessionFromSecureConnection(Registry obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        inS.readEmptyParams();
        AdminSessionPrx ret = obj.createAdminSessionFromSecureConnection(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy((ObjectPrx)ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getSessionTimeout(Registry obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        inS.readEmptyParams();
        int ret = obj.getSessionTimeout(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getACMTimeout(Registry obj, Incoming inS, Current current) {
        Object._iceCheckMode((OperationMode)OperationMode.Idempotent, (OperationMode)current.mode);
        inS.readEmptyParams();
        int ret = obj.getACMTimeout(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Registry._iceD_createAdminSession(this, in, current);
            }
            case 1: {
                return Registry._iceD_createAdminSessionFromSecureConnection(this, in, current);
            }
            case 2: {
                return Registry._iceD_createSession(this, in, current);
            }
            case 3: {
                return Registry._iceD_createSessionFromSecureConnection(this, in, current);
            }
            case 4: {
                return Registry._iceD_getACMTimeout(this, in, current);
            }
            case 5: {
                return Registry._iceD_getSessionTimeout(this, in, current);
            }
            case 6: {
                return Object._iceD_ice_id((Object)this, (Incoming)in, (Current)current);
            }
            case 7: {
                return Object._iceD_ice_ids((Object)this, (Incoming)in, (Current)current);
            }
            case 8: {
                return Object._iceD_ice_isA((Object)this, (Incoming)in, (Current)current);
            }
            case 9: {
                return Object._iceD_ice_ping((Object)this, (Incoming)in, (Current)current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceGrid::Registry"};
        _iceOps = new String[]{"createAdminSession", "createAdminSessionFromSecureConnection", "createSession", "createSessionFromSecureConnection", "getACMTimeout", "getSessionTimeout", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }
}

