/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGrid;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceGrid.ObjectInfo;
import com.zeroc.IceGrid.ObjectInfoSeqHelper;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface ObjectObserver
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public void objectInit(ObjectInfo[] var1, Current var2);

    public void objectAdded(ObjectInfo var1, Current var2);

    public void objectUpdated(ObjectInfo var1, Current var2);

    public void objectRemoved(Identity var1, Current var2);

    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    default public String ice_id(Current current) {
        return ObjectObserver.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceGrid::ObjectObserver";
    }

    public static CompletionStage<OutputStream> _iceD_objectInit(ObjectObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        ObjectInfo[] iceP_objects = ObjectInfoSeqHelper.read(istr);
        inS.endReadParams();
        obj.objectInit(iceP_objects, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_objectAdded(ObjectObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        ObjectInfo iceP_info = ObjectInfo.ice_read(istr);
        inS.endReadParams();
        obj.objectAdded(iceP_info, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_objectUpdated(ObjectObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        ObjectInfo iceP_info = ObjectInfo.ice_read(istr);
        inS.endReadParams();
        obj.objectUpdated(iceP_info, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_objectRemoved(ObjectObserver obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, (OperationMode)current.mode);
        InputStream istr = inS.startReadParams();
        Identity iceP_id = Identity.ice_read((InputStream)istr);
        inS.endReadParams();
        obj.objectRemoved(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Object._iceD_ice_id((Object)this, (Incoming)in, (Current)current);
            }
            case 1: {
                return Object._iceD_ice_ids((Object)this, (Incoming)in, (Current)current);
            }
            case 2: {
                return Object._iceD_ice_isA((Object)this, (Incoming)in, (Current)current);
            }
            case 3: {
                return Object._iceD_ice_ping((Object)this, (Incoming)in, (Current)current);
            }
            case 4: {
                return ObjectObserver._iceD_objectAdded(this, in, current);
            }
            case 5: {
                return ObjectObserver._iceD_objectInit(this, in, current);
            }
            case 6: {
                return ObjectObserver._iceD_objectRemoved(this, in, current);
            }
            case 7: {
                return ObjectObserver._iceD_objectUpdated(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceGrid::ObjectObserver"};
        _iceOps = new String[]{"ice_id", "ice_ids", "ice_isA", "ice_ping", "objectAdded", "objectInit", "objectRemoved", "objectUpdated"};
    }
}

