/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.utils.QSJSONUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QSStringUtil {
    public static String objectToJson(String key, Object o) throws QSException {
        StringBuffer buffer = new StringBuffer("{ \"" + key + "\":");
        buffer.append(QSStringUtil.objectJSONKeyValue(key, o));
        buffer.append("}");
        return buffer.toString();
    }

    private static String objectJSONKeyValue(String key, Object o) throws QSException {
        StringBuffer buffer = new StringBuffer(" \"" + key + "\":");
        buffer.append(QSStringUtil.objectJSONValue(o));
        return buffer.toString();
    }

    public static Object objectJSONValue(Object o) throws QSException {
        if (o instanceof List) {
            List lst = (List)o;
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < lst.size(); ++i) {
                QSJSONUtil.putJsonData(jsonArray, i, QSStringUtil.objectJSONValue(lst.get(i)));
            }
            return jsonArray;
        }
        if (o instanceof Integer || o instanceof Double || o instanceof Boolean || o instanceof Long || o instanceof Float || o instanceof String) {
            return o;
        }
        if (o instanceof Map) {
            return QSStringUtil.getMapToJson((Map)o);
        }
        HashMap params = new HashMap();
        QSParamInvokeUtil.invokeObject2Map(o.getClass(), o, params);
        return QSStringUtil.getMapToJson(params);
    }

    public static JSONObject getMapToJson(Map o) throws QSException {
        JSONObject json = new JSONObject();
        try {
            for (Map.Entry entry : o.entrySet()) {
                String key = (String)entry.getKey();
                Object bodyObj = o.get(key);
                json.put(key, QSStringUtil.objectJSONValue(bodyObj));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new QSException("ObjectToJson", e);
        }
        return json;
    }

    public static String getObjectToJson(Object o) {
        JSONObject json = null;
        if (o instanceof Map) {
            json = new JSONObject();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                String key = (String)entry.getKey();
                Object bodyObj = ((Map)o).get(key);
                json.put(key, bodyObj);
            }
        } else {
            json = new JSONObject(o);
        }
        return json.toString();
    }

    public static String percentEncode(String value, String encoding) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, encoding).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
    }

    public static String getUserAgent() {
        String osName = System.getProperty("os.name");
        String langVersion = System.getProperty("java.version");
        String userAgent = QSConstant.SDK_NAME + "/" + QSConstant.SDK_VERSION + " ( java v" + langVersion + ";" + osName + ")";
        return userAgent;
    }

    public static String getParameterRequired(String paraName, String value) {
        return String.format("%s is required in %s ", paraName, value);
    }

    public static String getParameterValueNotAllowedError(String paraName, String value, String[] values) {
        StringBuffer buf = new StringBuffer();
        for (String o : values) {
            buf.append(o.toString()).append(",");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return String.format("%s value %s is not allowed, should be one of %s ", paraName, value, buf.toString());
    }

    public static String asciiCharactersEncoding(String str) throws QSException {
        if (QSStringUtil.isEmpty(str)) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(str, "UTF-8");
            encoded = encoded.replace("%2F", "/");
            encoded = encoded.replace("%3D", "=");
            encoded = encoded.replace("+", "%20");
            encoded = encoded.replace("%3A", ":");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new QSException("UnsupportedEncodingException:", e);
        }
    }
}

